/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.MemoryImageSource;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import java.util.Vector;

public class DatabaseManager
extends Applet
implements ActionListener,
WindowListener,
KeyListener {
    static final int iMaxRecent = 24;
    static boolean bMustExit;
    static Random rRandom;
    Connection cConn;
    DatabaseMetaData dMeta;
    Statement sStatement;
    Menu mRecent;
    String[] sRecent;
    int iRecent;
    TextArea txtCommand;
    Button butExecute;
    Tree tTree;
    Panel pResult;
    long lTime;
    int iResult;
    Grid gResult;
    TextArea txtResult;
    boolean bHelp;
    Frame fMain;
    Image imgEmpty;

    void connect(Connection connection) {
        if (connection == null) {
            return;
        }
        if (this.cConn != null) {
            try {
                this.cConn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.cConn = connection;
        try {
            this.dMeta = this.cConn.getMetaData();
            this.sStatement = this.cConn.createStatement();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        this.refreshTree();
    }

    public void init() {
        DatabaseManager databaseManager = new DatabaseManager();
        databaseManager.main();
        try {
            databaseManager.connect(ConnectionDialog.createConnection("org.hsql.jdbcDriver", "jdbc:HypersonicSQL:.", "sa", ""));
            databaseManager.insertTestData();
            databaseManager.refreshTree();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        bMustExit = true;
        DatabaseManager databaseManager = new DatabaseManager();
        databaseManager.main();
        Connection connection = ConnectionDialog.createConnection(databaseManager.fMain, "Connect");
        if (connection == null) {
            return;
        }
        databaseManager.connect(connection);
    }

    void insertTestData() {
        String[] stringArray = new String[]{"DROP TABLE Address", "DROP TABLE Product", "DROP TABLE Document", "DROP TABLE Position", "CREATE TABLE Address(ID INTEGER PRIMARY KEY,FirstName VARCHAR(255),LastName VARCHAR(255),Street VARCHAR(255),City VARCHAR(255))", "CREATE TABLE Product(ID INTEGER PRIMARY KEY,Name VARCHAR(255),Cost DECIMAL)", "CREATE TABLE Document(ID INTEGER PRIMARY KEY,AddressID INTEGER,Total DECIMAL)", "CREATE TABLE Position(DocumentID INTEGER,Position INTEGER,ProductID INTEGER,Quantity INTEGER,Price DECIMAL,PRIMARY KEY(DocumentID,Position))"};
        String[] stringArray2 = new String[]{"White", "Karsen", "Smith", "Ringer", "May", "King", "Fuller", "Miller", "Ott", "Sommer", "Schneider", "Steel", "Peterson", "Heiniger", "Clancy"};
        String[] stringArray3 = new String[]{"Mary", "James", "Anne", "George", "Sylvia", "Robert", "Janet", "Michael", "Andrew", "Bill", "Susanne", "Laura", "Bob", "Julia", "John"};
        String[] stringArray4 = new String[]{"Upland Pl.", "College Av.", "- 20th Ave.", "Seventh Av."};
        String[] stringArray5 = new String[]{"New York", "Dallas", "Boston", "Chicago", "Seattle", "San Francisco", "Berne", "Oslo", "Paris", "Lyon", "Palo Alto", "Olten"};
        String[] stringArray6 = new String[]{"Iron", "Ice Tea", "Clock", "Chair", "Telephone", "Shoe"};
        try {
            int n;
            int n2 = 0;
            while (n2 < stringArray.length) {
                try {
                    this.sStatement.execute(stringArray[n2]);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                ++n2;
            }
            this.refreshTree();
            n2 = 50;
            int n3 = 0;
            while (n3 < n2) {
                this.sStatement.execute("INSERT INTO Address VALUES(" + n3 + ",'" + DatabaseManager.random(stringArray3) + "','" + DatabaseManager.random(stringArray2) + "','" + DatabaseManager.random(554) + " " + DatabaseManager.random(stringArray4) + "','" + DatabaseManager.random(stringArray5) + "')");
                this.sStatement.execute("INSERT INTO Product VALUES(" + n3 + ",'" + DatabaseManager.random(stringArray6) + " " + DatabaseManager.random(stringArray6) + "'," + (20 + 2 * DatabaseManager.random(120)) + ")");
                this.sStatement.execute("INSERT INTO Document VALUES(" + n3 + "," + DatabaseManager.random(n2) + ",0.0)");
                n = DatabaseManager.random(20) + 2;
                while (n >= 0) {
                    this.sStatement.execute("INSERT INTO Position VALUES(" + n3 + "," + n + "," + DatabaseManager.random(n2) + "," + (1 + DatabaseManager.random(24)) + ",1.5)");
                    --n;
                }
                ++n3;
            }
            this.sStatement.execute("UPDATE Product SET Cost=Cost*.1");
            this.sStatement.execute("UPDATE Position SET Price=Price*SELECT Cost FROM Product prod WHERE ProductID=prod.ID");
            this.sStatement.execute("UPDATE Document SET Total=SELECT SUM(Price*Quantity) FROM Position WHERE DocumentID=Document.ID");
            String[] stringArray7 = new String[]{"SELECT * FROM Product", "SELECT * FROM Document", "SELECT * FROM Position", "SELECT * FROM Address a\nINNER JOIN Document d ON a.ID=d.AddressID", "SELECT * FROM Document d\nINNER JOIN Position p ON d.ID=p.DocumentID", "SELECT * FROM Address WHERE Street LIKE '1%' ORDER BY Lastname"};
            n = 0;
            while (n < stringArray7.length) {
                this.addToRecent(stringArray7[n]);
                ++n;
            }
            this.refreshTree();
            this.txtCommand.setText("SELECT * FROM Address");
            this.execute();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public static String random(String[] stringArray) {
        return stringArray[DatabaseManager.random(stringArray.length)];
    }

    public static int random(int n) {
        n = rRandom.nextInt() % n;
        return n < 0 ? -n : n;
    }

    void main() {
        this.fMain = new Frame("Hypersonic Database Manager");
        this.imgEmpty = this.createImage(new MemoryImageSource(2, 2, new int[16], 2, 2));
        this.fMain.setIconImage(this.imgEmpty);
        this.fMain.addWindowListener(this);
        MenuBar menuBar = new MenuBar();
        String[] stringArray = new String[]{"-Connect...", "--", "-Open Script...", "-Save Script...", "-Save Result...", "--", "-Exit"};
        this.addMenu(menuBar, "File", stringArray);
        String[] stringArray2 = new String[]{"RRefresh Tree", "--", "GResults in Grid", "TResults in Text", "--", "1Shrink Tree", "2Enlarge Tree", "3Shrink Command", "4Enlarge Command"};
        this.addMenu(menuBar, "View", stringArray2);
        String[] stringArray3 = new String[]{"SSELECT", "IINSERT", "UUPDATE", "DDELETE", "--", "-CREATE TABLE", "-DROP TABLE", "-CREATE INDEX", "-DROP INDEX", "--", "-SCRIPT", "-SHUTDOWN", "--", "-Test Script"};
        this.addMenu(menuBar, "Command", stringArray3);
        Menu menu = new Menu("Recent");
        this.mRecent = new Menu("Recent");
        menuBar.add(this.mRecent);
        String[] stringArray4 = new String[]{"-AutoCommit on", "-AutoCommit off", "OCommit", "LRollback", "--", "-Disable MaxRows", "-Set MaxRows to 100", "--", "-Logging on", "-Logging off", "--", "-Insert test data", "-Transfer"};
        this.addMenu(menuBar, "Options", stringArray4);
        this.fMain.setMenuBar(menuBar);
        this.fMain.setSize(640, 480);
        this.fMain.add("Center", this);
        this.initGUI();
        this.sRecent = new String[24];
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.fMain.getSize();
        this.fMain.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.fMain.show();
        this.txtCommand.requestFocus();
    }

    void addMenu(MenuBar menuBar, String string, String[] stringArray) {
        Menu menu = new Menu(string);
        this.addMenuItems(menu, stringArray);
        menuBar.add(menu);
    }

    void addMenuItems(Menu menu, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            MenuItem menuItem = new MenuItem(stringArray[n].substring(1));
            char c = stringArray[n].charAt(0);
            if (c != '-') {
                menuItem.setShortcut(new MenuShortcut(c));
            }
            menuItem.addActionListener(this);
            menu.add(menuItem);
            ++n;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getKeyChar() == '\n' && keyEvent.isControlDown()) {
            keyEvent.consume();
            this.execute();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null && actionEvent.getSource() instanceof MenuItem) {
            string = ((MenuItem)actionEvent.getSource()).getLabel();
        }
        if (string.equals("Execute")) {
            this.execute();
        } else if (string.equals("Exit")) {
            this.windowClosing(null);
        } else if (string.equals("Transfer")) {
            Transfer.work();
        } else if (string.equals("Logging on")) {
            DriverManager.setLogStream(System.out);
        } else if (string.equals("Logging off")) {
            DriverManager.setLogStream(null);
        } else if (string.equals("Refresh Tree")) {
            this.refreshTree();
        } else if (string.startsWith("#")) {
            int n = Integer.parseInt(string.substring(1));
            this.txtCommand.setText(this.sRecent[n]);
        } else if (string.equals("Connect...")) {
            this.connect(ConnectionDialog.createConnection(this.fMain, "Connect"));
            this.refreshTree();
        } else if (string.equals("Results in Grid")) {
            this.iResult = 0;
            this.pResult.removeAll();
            this.pResult.add("Center", this.gResult);
            this.pResult.doLayout();
        } else if (string.equals("Open Script...")) {
            FileDialog fileDialog = new FileDialog(this.fMain, "Open Script", 0);
            fileDialog.show();
            String string2 = fileDialog.getFile();
            if (string2 != null) {
                this.txtCommand.setText(this.readFile(fileDialog.getDirectory() + string2));
            }
        } else if (string.equals("Save Script...")) {
            FileDialog fileDialog = new FileDialog(this.fMain, "Save Script", 1);
            fileDialog.show();
            String string3 = fileDialog.getFile();
            if (string3 != null) {
                this.writeFile(fileDialog.getDirectory() + string3, this.txtCommand.getText());
            }
        } else if (string.equals("Save Result...")) {
            FileDialog fileDialog = new FileDialog(this.fMain, "Save Result", 1);
            fileDialog.show();
            String string4 = fileDialog.getFile();
            if (string4 != null) {
                this.showResultInText();
                this.writeFile(fileDialog.getDirectory() + string4, this.txtResult.getText());
            }
        } else if (string.equals("Results in Text")) {
            this.iResult = 1;
            this.pResult.removeAll();
            this.pResult.add("Center", this.txtResult);
            this.pResult.doLayout();
            this.showResultInText();
        } else if (string.equals("AutoCommit on")) {
            try {
                this.cConn.setAutoCommit(true);
            }
            catch (SQLException sQLException) {}
        } else if (string.equals("AutoCommit off")) {
            try {
                this.cConn.setAutoCommit(false);
            }
            catch (SQLException sQLException) {}
        } else if (string.equals("Enlarge Tree")) {
            Dimension dimension = this.tTree.getMinimumSize();
            dimension.width += 20;
            this.tTree.setMinimumSize(dimension);
            this.fMain.pack();
        } else if (string.equals("Shrink Tree")) {
            Dimension dimension = this.tTree.getMinimumSize();
            dimension.width -= 20;
            if (dimension.width >= 0) {
                this.tTree.setMinimumSize(dimension);
            }
            this.fMain.pack();
        } else if (string.equals("Enlarge Command")) {
            this.txtCommand.setRows(this.txtCommand.getRows() + 1);
            this.fMain.pack();
        } else if (string.equals("Shrink Command")) {
            int n = this.txtCommand.getRows() - 1;
            this.txtCommand.setRows(n < 1 ? 1 : n);
            this.fMain.pack();
        } else if (string.equals("Commit")) {
            try {
                this.cConn.commit();
            }
            catch (SQLException sQLException) {}
        } else if (string.equals("Insert test data")) {
            this.insertTestData();
        } else if (string.equals("Rollback")) {
            try {
                this.cConn.rollback();
            }
            catch (SQLException sQLException) {}
        } else if (string.equals("Disable MaxRows")) {
            try {
                this.sStatement.setMaxRows(0);
            }
            catch (SQLException sQLException) {}
        } else if (string.equals("Set MaxRows to 100")) {
            try {
                this.sStatement.setMaxRows(100);
            }
            catch (SQLException sQLException) {}
        } else if (string.equals("SELECT")) {
            this.showHelp("SELECT * FROM ", "SELECT [DISTINCT] \n{ selectExpression | table.* | * } [, ... ] \n[INTO newTable] \nFROM tableList \n[WHERE Expression] \n[ORDER BY selectExpression [{ASC | DESC}] [, ...] ] \n[GROUP BY Expression [, ...] ] \n[UNION [ALL] selectStatement]");
        } else if (string.equals("INSERT")) {
            this.showHelp("INSERT INTO ", "INSERT INTO table [ (column [,...] ) ] \n{ VALUES(Expression [,...]) | SelectStatement }");
        } else if (string.equals("UPDATE")) {
            this.showHelp("UPDATE ", "UPDATE table SET column = Expression [, ...] \n[WHERE Expression]");
        } else if (string.equals("DELETE")) {
            this.showHelp("DELETE FROM ", "DELETE FROM table [WHERE Expression]");
        } else if (string.equals("CREATE TABLE")) {
            this.showHelp("CREATE TABLE ", "CREATE TABLE name \n( columnDefinition [, ...] ) \n\ncolumnDefinition: \ncolumn DataType [ [NOT] NULL] [PRIMARY KEY] \nDataType: \n{ INTEGER | DOUBLE | VARCHAR | DATE | TIME |... }");
        } else if (string.equals("DROP TABLE")) {
            this.showHelp("DROP TABLE ", "DROP TABLE table");
        } else if (string.equals("CREATE INDEX")) {
            this.showHelp("CREATE INDEX ", "CREATE [UNIQUE] INDEX index ON \ntable (column [, ...])");
        } else if (string.equals("DROP INDEX")) {
            this.showHelp("DROP INDEX ", "DROP INDEX table.index");
        } else if (string.equals("SCRIPT")) {
            this.showHelp("SCRIPT", "SCRIPT ['file']\n\n(Hypersonic SQL only)");
        } else if (string.equals("SHUTDOWN")) {
            this.showHelp("SHUTDOWN", "SHUTDOWN [IMMEDIATELY]\n\n(Hypersonic SQL only)");
        } else if (string.equals("Test Script")) {
            this.showHelp("-->>>TEST<<<-- ;\n--#1000;\nDROP TABLE Test ;\nCREATE TABLE Test(\n  Id INTEGER PRIMARY KEY,\n  FirstName VARCHAR(20),\n  Name VARCHAR(50),\n  ZIP INTEGER) ;\nINSERT INTO Test \n  VALUES(#,'Julia','Peterson-Clancy',#) ;\nUPDATE Test SET Name='Hans' WHERE Id=# ;\nSELECT * FROM Test WHERE Id=# ;\nDELETE FROM Test WHERE Id=# ;\nDROP TABLE Test", "This test script is parsed by the DatabaseManager\nIt may be changed manually. Rules:\n- it must start with -->>>TEST<<<--.\n- each line must end with ';' (no spaces after)\n- lines starting with -- are comments\n- lines starting with --#<count> means set new count\n");
        }
    }

    String readFile(String string) {
        try {
            int n;
            FileReader fileReader = new FileReader(string);
            char[] cArray = new char[1024];
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = fileReader.read(cArray, 0, 1024)) != -1) {
                stringBuffer.append(cArray, 0, n);
            }
            fileReader.close();
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            return iOException.getMessage();
        }
    }

    void writeFile(String string, String string2) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write(string2.toCharArray());
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void showHelp(String string, String string2) {
        this.txtCommand.setText(string);
        this.txtResult.setText(string2);
        this.bHelp = true;
        this.pResult.removeAll();
        this.pResult.add("Center", this.txtResult);
        this.pResult.doLayout();
        this.txtCommand.requestFocus();
        this.txtCommand.setCaretPosition(string.length());
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        try {
            this.cConn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.fMain.dispose();
        if (bMustExit) {
            System.exit(0);
        }
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    void trace(String string) {
        System.out.println(string);
    }

    void execute() {
        String string = this.txtCommand.getText();
        if (string.startsWith("-->>>TEST<<<--")) {
            this.testPerformance();
            return;
        }
        String[] stringArray = new String[1];
        try {
            this.lTime = System.currentTimeMillis();
            this.sStatement.execute(string);
            int n = this.sStatement.getUpdateCount();
            if (n == -1) {
                this.formatResultSet(this.sStatement.getResultSet());
            } else {
                stringArray[0] = "update count";
                this.gResult.setHead(stringArray);
                stringArray[0] = "" + n;
                this.gResult.addRow(stringArray);
            }
            this.lTime = System.currentTimeMillis() - this.lTime;
            this.addToRecent(this.txtCommand.getText());
        }
        catch (SQLException sQLException) {
            this.lTime = System.currentTimeMillis() - this.lTime;
            stringArray[0] = "SQL Error";
            this.gResult.setHead(stringArray);
            String string2 = sQLException.getMessage();
            string2 = string2 + " / Error Code: " + sQLException.getErrorCode();
            stringArray[0] = string2 = string2 + " / State: " + sQLException.getSQLState();
            this.gResult.addRow(stringArray);
        }
        this.updateResult();
    }

    void updateResult() {
        if (this.iResult == 0) {
            if (this.bHelp) {
                this.pResult.removeAll();
                this.pResult.add("Center", this.gResult);
                this.pResult.doLayout();
                this.bHelp = false;
            }
            this.gResult.update();
            this.gResult.repaint();
        } else {
            this.showResultInText();
        }
        this.txtCommand.selectAll();
        this.txtCommand.requestFocus();
    }

    void formatResultSet(ResultSet resultSet) {
        if (resultSet == null) {
            String[] stringArray = new String[]{"Result"};
            this.gResult.setHead(stringArray);
            stringArray[0] = "(empty)";
            this.gResult.addRow(stringArray);
            return;
        }
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            String[] stringArray = new String[n];
            int n2 = 1;
            while (n2 <= n) {
                stringArray[n2 - 1] = resultSetMetaData.getColumnLabel(n2);
                ++n2;
            }
            this.gResult.setHead(stringArray);
            while (resultSet.next()) {
                n2 = 1;
                while (n2 <= n) {
                    stringArray[n2 - 1] = resultSet.getString(n2);
                    if (resultSet.wasNull()) {
                        stringArray[n2 - 1] = "(null)";
                    }
                    ++n2;
                }
                this.gResult.addRow(stringArray);
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    long testStatement(String string, int n) throws SQLException {
        long l = System.currentTimeMillis();
        if (string.indexOf(35) == -1) {
            n = 1;
        }
        int n2 = 0;
        while (n2 < n) {
            int n3;
            String string2 = string;
            while ((n3 = string2.indexOf("#r#")) != -1) {
                string2 = string2.substring(0, n3) + (int)(Math.random() * (double)n2) + string2.substring(n3 + 3);
            }
            while ((n3 = string2.indexOf(35)) != -1) {
                string2 = string2.substring(0, n3) + n2 + string2.substring(n3 + 1);
            }
            this.sStatement.execute(string2);
            ++n2;
        }
        return System.currentTimeMillis() - l;
    }

    void testPerformance() {
        int n;
        String string = this.txtCommand.getText();
        StringBuffer stringBuffer = new StringBuffer();
        long l = 0L;
        int n2 = 0;
        while (n2 < string.length()) {
            n = string.charAt(n2);
            if (n != 10) {
                stringBuffer.append((char)n);
            }
            ++n2;
        }
        string = stringBuffer.toString();
        String[] stringArray = new String[]{"ms", "count", "sql", "error"};
        this.gResult.setHead(stringArray);
        n = 1;
        this.lTime = System.currentTimeMillis() - this.lTime;
        while (!string.equals("")) {
            String string2;
            int n3 = string.indexOf(59);
            if (n3 != -1) {
                string2 = string.substring(0, n3);
                string = string.substring(n3 + 1);
            } else {
                string2 = string;
                string = "";
            }
            if (string2.startsWith("--#")) {
                n = Integer.parseInt(string2.substring(3));
                continue;
            }
            if (string2.startsWith("--")) continue;
            stringArray[2] = string2;
            long l2 = 0L;
            try {
                l2 = this.testStatement(string2, n);
                l += l2;
                stringArray[0] = "" + l2;
                stringArray[1] = "" + n;
                stringArray[3] = "";
            }
            catch (SQLException sQLException) {
                stringArray[1] = "n/a";
                stringArray[0] = "n/a";
                stringArray[3] = sQLException.toString();
            }
            this.gResult.addRow(stringArray);
            System.out.println(l2 + " ms : " + string2);
        }
        stringArray[0] = "" + l;
        stringArray[1] = "total";
        stringArray[2] = "";
        this.gResult.addRow(stringArray);
        this.lTime = System.currentTimeMillis() - this.lTime;
        this.updateResult();
    }

    void showResultInText() {
        int n;
        int n2;
        String[] stringArray = this.gResult.getHead();
        int n3 = stringArray.length;
        Vector vector = this.gResult.getData();
        int[] nArray = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            nArray[n4] = stringArray[n4].length();
            ++n4;
        }
        n4 = vector.size();
        int n5 = 0;
        while (n5 < n4) {
            stringArray = (String[])vector.elementAt(n5);
            n2 = 0;
            while (n2 < n3) {
                n = stringArray[n2].length();
                if (n > nArray[n2]) {
                    nArray[n2] = n;
                }
                ++n2;
            }
            ++n5;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringArray = this.gResult.getHead();
        n2 = 0;
        while (n2 < n3) {
            stringBuffer.append(stringArray[n2]);
            n = stringArray[n2].length();
            while (n <= nArray[n2]) {
                stringBuffer.append(' ');
                ++n;
            }
            ++n2;
        }
        stringBuffer.append('\n');
        n2 = 0;
        while (n2 < n3) {
            n = 0;
            while (n < nArray[n2]) {
                stringBuffer.append('-');
                ++n;
            }
            stringBuffer.append(' ');
            ++n2;
        }
        stringBuffer.append('\n');
        n2 = 0;
        while (n2 < n4) {
            stringArray = (String[])vector.elementAt(n2);
            n = 0;
            while (n < n3) {
                stringBuffer.append(stringArray[n]);
                int n6 = stringArray[n].length();
                while (n6 <= nArray[n]) {
                    stringBuffer.append(' ');
                    ++n6;
                }
                ++n;
            }
            stringBuffer.append('\n');
            ++n2;
        }
        stringBuffer.append("\n" + n4 + " row(s) in " + this.lTime + " ms");
        this.txtResult.setText(stringBuffer.toString());
    }

    private void addToRecent(String string) {
        int n = 0;
        while (n < 24) {
            if (string.equals(this.sRecent[n])) {
                return;
            }
            ++n;
        }
        if (this.sRecent[this.iRecent] != null) {
            this.mRecent.remove(this.iRecent);
        }
        this.sRecent[this.iRecent] = string;
        if (string.length() > 43) {
            string = string.substring(0, 40) + "...";
        }
        MenuItem menuItem = new MenuItem(string);
        menuItem.setActionCommand("#" + this.iRecent);
        menuItem.addActionListener(this);
        this.mRecent.insert(menuItem, this.iRecent);
        this.iRecent = (this.iRecent + 1) % 24;
    }

    private void initGUI() {
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        this.pResult = new Panel();
        panel.setLayout(new BorderLayout());
        panel2.setLayout(new BorderLayout());
        this.pResult.setLayout(new BorderLayout());
        Font font = new Font("Dialog", 0, 12);
        this.txtCommand = new TextArea(5, 40);
        this.txtCommand.addKeyListener(this);
        this.txtResult = new TextArea(20, 40);
        this.txtCommand.setFont(font);
        this.txtResult.setFont(new Font("Courier", 0, 12));
        this.butExecute = new Button("Execute");
        this.butExecute.addActionListener(this);
        panel2.add("East", this.butExecute);
        panel2.add("Center", this.txtCommand);
        this.gResult = new Grid();
        this.setLayout(new BorderLayout());
        this.pResult.add("Center", this.gResult);
        panel.add("North", panel2);
        panel.add("Center", this.pResult);
        this.fMain.add("Center", panel);
        this.tTree = new Tree();
        this.tTree.setMinimumSize(new Dimension(200, 100));
        this.gResult.setMinimumSize(new Dimension(200, 300));
        this.fMain.add("West", this.tTree);
        this.doLayout();
        this.fMain.pack();
    }

    private void refreshTree() {
        this.tTree.removeAll();
        try {
            int n = Color.yellow.getRGB();
            int n2 = Color.orange.getRGB();
            int n3 = Color.red.getRGB();
            this.tTree.addRow("", this.dMeta.getURL(), "-", 0);
            String[] stringArray = new String[]{"TABLE"};
            ResultSet resultSet = this.dMeta.getTables(null, null, null, stringArray);
            Vector<String> vector = new Vector<String>();
            while (resultSet.next()) {
                vector.addElement(resultSet.getString(3));
            }
            resultSet.close();
            int n4 = 0;
            while (n4 < vector.size()) {
                String string;
                Object object;
                String string2 = (String)vector.elementAt(n4);
                String string3 = "tab-" + string2 + "-";
                this.tTree.addRow(string3, string2, "+", n);
                ResultSet resultSet2 = this.dMeta.getColumns(null, null, string2, null);
                while (resultSet2.next()) {
                    object = resultSet2.getString(4);
                    string = string3 + "col-" + (String)object + "-";
                    this.tTree.addRow(string, (String)object, "+", n2);
                    String string4 = resultSet2.getString(6);
                    this.tTree.addRow(string + "t", "Type: " + string4);
                    boolean bl = resultSet2.getInt(11) != 0;
                    this.tTree.addRow(string + "n", "Nullable: " + bl);
                }
                resultSet2.close();
                this.tTree.addRow(string3 + "ind", "Indices", "+", 0);
                object = this.dMeta.getIndexInfo(null, null, string2, false, false);
                string = null;
                while (object.next()) {
                    boolean bl = object.getBoolean(4);
                    String string5 = object.getString(6);
                    String string6 = string3 + "ind-" + string5 + "-";
                    if (string == null || !string.equals(string5)) {
                        this.tTree.addRow(string6, string5, "+", n3);
                        this.tTree.addRow(string6 + "u", "Unique: " + !bl);
                        string = string5;
                    }
                    String string7 = object.getString(9);
                    this.tTree.addRow(string6 + "c-" + string7 + "-", string7);
                }
                object.close();
                ++n4;
            }
            this.tTree.addRow("p", "Properties", "+", 0);
            this.tTree.addRow("pu", "User: " + this.dMeta.getUserName());
            this.tTree.addRow("pr", "ReadOnly: " + this.cConn.isReadOnly());
            this.tTree.addRow("pa", "AutoCommit: " + this.cConn.getAutoCommit());
            this.tTree.addRow("pd", "Driver: " + this.dMeta.getDriverName());
            this.tTree.addRow("pp", "Product: " + this.dMeta.getDatabaseProductName());
            this.tTree.addRow("pv", "Version: " + this.dMeta.getDatabaseProductVersion());
        }
        catch (SQLException sQLException) {
            this.tTree.addRow("", "Error getting metadata:", "-", 0);
            this.tTree.addRow("-", sQLException.getMessage());
            this.tTree.addRow("-", sQLException.getSQLState());
        }
        this.tTree.update();
    }

    static {
        rRandom = new Random(100L);
    }
}

