/*
 * Decompiled with CFR 0.152.
 */
package org.hsql;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.hsql.Access;
import org.hsql.Channel;
import org.hsql.Column;
import org.hsql.Constraint;
import org.hsql.Database;
import org.hsql.Index;
import org.hsql.Node;
import org.hsql.Result;
import org.hsql.Table;
import org.hsql.User;

class DatabaseInformation {
    static final String META_SCHEM = "SCHEM";
    static final String META_CAT = "CAT";
    static final String META_COLUMN_SIZE = "COLUMN_SIZE";
    static final String META_BUFFER_LENGTH = "BUFFER_LENGTH";
    static final String META_DECIMAL_DIGITS = "DECIMAL_DIGITS";
    static final String META_NUM_PREC_RADIX = "NUM_PREC_RADIX";
    static final String META_FIXED_PREC_SCALE = "FIXED_PREC_SCALE";
    static final String META_ORDINAL_POSITON = "ORDINAL_POSITON";
    static final String META_ASC_OR_DESC = "ASC_OR_DESC";
    private Database dDatabase;
    private Access aAccess;
    private Vector tTable;

    Table getSystemTable(String string, Channel channel) throws SQLException {
        if (string.equals("SYSTEM_PROCEDURES")) {
            Table table = this.createTable(string);
            table.addColumn("PROCEDURE_CAT", 12);
            table.addColumn("PROCEDURE_SCHEM", 12);
            table.addColumn("PROCEDURE_NAME", 12);
            table.addColumn("NUM_INPUT_PARAMS", 4);
            table.addColumn("NUM_OUTPUT_PARAMS", 4);
            table.addColumn("NUM_RESULT_SETS", 4);
            table.addColumn("REMARKS", 12);
            table.addColumn("PROCEDURE_TYPE", 5);
            table.createPrimaryKey();
            return table;
        }
        if (string.equals("SYSTEM_PROCEDURECOLUMNS")) {
            Table table = this.createTable(string);
            table.addColumn("PROCEDURE_CAT", 12);
            table.addColumn("PROCEDURE_SCHEM", 12);
            table.addColumn("PROCEDURE_NAME", 12);
            table.addColumn("COLUMN_NAME", 12);
            table.addColumn("COLUMN_TYPE", 5);
            table.addColumn("DATA_TYPE", 5);
            table.addColumn("TYPE_NAME", 12);
            table.addColumn("PRECISION", 4);
            table.addColumn("LENGTH", 4);
            table.addColumn("SCALE", 5);
            table.addColumn("RADIX", 5);
            table.addColumn("NULLABLE", 5);
            table.addColumn("REMARKS", 12);
            table.createPrimaryKey();
            return table;
        }
        if (string.equals("SYSTEM_TABLES")) {
            Table table = this.createTable(string);
            table.addColumn("TABLE_CAT", 12);
            table.addColumn("TABLE_SCHEM", 12);
            table.addColumn("TABLE_NAME", 12);
            table.addColumn("TABLE_TYPE", 12);
            table.addColumn("REMARKS", 12);
            table.createPrimaryKey();
            int n = 0;
            while (n < this.tTable.size()) {
                Table table2 = (Table)this.tTable.elementAt(n);
                Object[] objectArray = table.getNewRow();
                objectArray[2] = table2.getName();
                objectArray[3] = "TABLE";
                table.insert(objectArray, null);
                ++n;
            }
            return table;
        }
        if (string.equals("SYSTEM_SCHEMAS")) {
            Table table = this.createTable(string);
            table.addColumn("TABLE_SCHEM", 12);
            table.createPrimaryKey();
            return table;
        }
        if (string.equals("SYSTEM_CATALOGS")) {
            Table table = this.createTable(string);
            table.addColumn("TABLE_CAT", 12);
            table.createPrimaryKey();
            return table;
        }
        if (string.equals("SYSTEM_TABLETYPES")) {
            Table table = this.createTable(string);
            table.addColumn("TABLE_TYPE", 12);
            table.createPrimaryKey();
            Object[] objectArray = table.getNewRow();
            objectArray[0] = "TABLE";
            table.insert(objectArray, null);
            return table;
        }
        if (string.equals("SYSTEM_COLUMNS")) {
            Table table = this.createTable(string);
            table.addColumn("TABLE_CAT", 12);
            table.addColumn("TABLE_SCHEM", 12);
            table.addColumn("TABLE_NAME", 12);
            table.addColumn("COLUMN_NAME", 12);
            table.addColumn("DATA_TYPE", 5);
            table.addColumn("TYPE_NAME", 12);
            table.addColumn(META_COLUMN_SIZE, 4);
            table.addColumn(META_BUFFER_LENGTH, 4);
            table.addColumn(META_DECIMAL_DIGITS, 4);
            table.addColumn(META_NUM_PREC_RADIX, 4);
            table.addColumn("NULLABLE", 4);
            table.addColumn("REMARKS", 12);
            table.addColumn("COLUMN_DEF", 12);
            table.addColumn("SQL_DATA_TYPE", 12);
            table.addColumn("SQL_DATETIME_SUB", 4);
            table.addColumn("CHAR_OCTET_LENGTH", 4);
            table.addColumn("ORDINAL_POSITION", 12);
            table.addColumn("IS_NULLABLE", 12);
            table.createPrimaryKey();
            int n = 0;
            while (n < this.tTable.size()) {
                Table table3 = (Table)this.tTable.elementAt(n);
                int n2 = table3.getColumnCount();
                int n3 = 0;
                while (n3 < n2) {
                    Object[] objectArray = table.getNewRow();
                    objectArray[2] = table3.getName();
                    objectArray[3] = table3.getColumnName(n3);
                    objectArray[4] = new Short((short)table3.getColumnType(n3));
                    objectArray[5] = Column.getType(table3.getColumnType(n3));
                    int n4 = table3.getColumnIsNullable(n3) ? 1 : 0;
                    objectArray[10] = new Integer(n4);
                    if (table3.getIdentityColumn() == n3) {
                        objectArray[11] = "IDENDITY";
                    }
                    table.insert(objectArray, null);
                    ++n3;
                }
                ++n;
            }
            return table;
        }
        if (string.equals("SYSTEM_COLUMNPRIVILEGES")) {
            Table table = this.createTable(string);
            table.addColumn("TABLE_CAT", 12);
            table.addColumn("TABLE_SCHEM", 12);
            table.addColumn("TABLE_NAME", 12);
            table.addColumn("COLUMN_NAME", 12);
            table.addColumn("GRANTOR", 12);
            table.addColumn("GRANTEE", 12);
            table.addColumn("PRIVILEGE", 12);
            table.addColumn("IS_GRANTABLE", 12);
            table.createPrimaryKey();
            return table;
        }
        if (string.equals("SYSTEM_TABLEPRIVILEGES")) {
            Table table = this.createTable(string);
            table.addColumn("TABLE_CAT", 12);
            table.addColumn("TABLE_SCHEM", 12);
            table.addColumn("TABLE_NAME", 12);
            table.addColumn("GRANTOR", 12);
            table.addColumn("GRANTEE", 12);
            table.addColumn("PRIVILEGE", 12);
            table.addColumn("IS_GRANTABLE", 12);
            table.createPrimaryKey();
            int n = 0;
            while (n < this.tTable.size()) {
                Table table4 = (Table)this.tTable.elementAt(n);
                Object[] objectArray = table.getNewRow();
                objectArray[2] = table4.getName();
                objectArray[3] = "sa";
                objectArray[5] = "FULL";
                table.insert(objectArray, null);
                ++n;
            }
            return table;
        }
        if (string.equals("SYSTEM_BESTROWIDENTIFIER")) {
            Table table = this.createTable(string);
            table.addColumn("SCOPE", 5);
            table.addColumn("COLUMN_NAME", 12);
            table.addColumn("DATA_TYPE", 5);
            table.addColumn("TYPE_NAME", 12);
            table.addColumn(META_COLUMN_SIZE, 4);
            table.addColumn(META_BUFFER_LENGTH, 4);
            table.addColumn(META_DECIMAL_DIGITS, 5);
            table.addColumn("PSEUDO_COLUMN", 5);
            table.createPrimaryKey();
            return table;
        }
        if (string.equals("SYSTEM_VERSIONCOLUMNS")) {
            Table table = this.createTable(string);
            table.addColumn("SCOPE", 4);
            table.addColumn("COLUMN_NAME", 12);
            table.addColumn("DATA_TYPE", 5);
            table.addColumn("TYPE_NAME", 12);
            table.addColumn(META_COLUMN_SIZE, 5);
            table.addColumn(META_BUFFER_LENGTH, 4);
            table.addColumn(META_DECIMAL_DIGITS, 5);
            table.addColumn("PSEUDO_COLUMN", 5);
            table.createPrimaryKey();
            return table;
        }
        if (string.equals("SYSTEM_PRIMARYKEYS")) {
            Table table = this.createTable(string);
            table.addColumn("TABLE_CAT", 12);
            table.addColumn("TABLE_SCHEM", 12);
            table.addColumn("TABLE_NAME", 12);
            table.addColumn("COLUMN_NAME", 12);
            table.addColumn("KEY_SEQ", 5);
            table.addColumn("PK_NAME", 12);
            table.createPrimaryKey();
            int n = 0;
            while (n < this.tTable.size()) {
                Table table5 = (Table)this.tTable.elementAt(n);
                Index index = table5.getIndex("SYSTEM_PK");
                int[] nArray = index.getColumns();
                int n5 = nArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    Object[] objectArray = table.getNewRow();
                    objectArray[2] = table5.getName();
                    objectArray[3] = table5.getColumnName(nArray[n6]);
                    objectArray[4] = new Short((short)(n6 + 1));
                    objectArray[5] = "SYSTEM_PK";
                    table.insert(objectArray, null);
                    ++n6;
                }
                ++n;
            }
            return table;
        }
        if (string.equals("SYSTEM_IMPORTEDKEYS")) {
            Table table = this.createTable(string);
            table.addColumn("PKTABLE_CAT", 12);
            table.addColumn("PKTABLE_SCHEM", 12);
            table.addColumn("PKTABLE_NAME", 12);
            table.addColumn("PKCOLUMN_NAME", 12);
            table.addColumn("FKTABLE_CAT", 12);
            table.addColumn("FKTABLE_SCHEM", 12);
            table.addColumn("FKTABLE_NAME", 12);
            table.addColumn("FKCOLUMN_NAME", 12);
            table.addColumn("KEY_SEQ", 5);
            table.addColumn("UPDATE_RULE", 5);
            table.addColumn("DELETE_RULE", 5);
            table.addColumn("FK_NAME", 12);
            table.addColumn("PK_NAME", 12);
            table.addColumn("DEFERRABILITY", 5);
            table.createPrimaryKey();
            return table;
        }
        if (string.equals("SYSTEM_EXPORTEDKEYS")) {
            Table table = this.createTable(string);
            table.addColumn("PKTABLE_CAT", 12);
            table.addColumn("PKTABLE_SCHEM", 12);
            table.addColumn("PKTABLE_NAME", 12);
            table.addColumn("PKCOLUMN_NAME", 12);
            table.addColumn("FKTABLE_CAT", 12);
            table.addColumn("FKTABLE_SCHEM", 12);
            table.addColumn("FKTABLE_NAME", 12);
            table.addColumn("FKCOLUMN_NAME", 12);
            table.addColumn("KEY_SEQ", 5);
            table.addColumn("UPDATE_RULE", 5);
            table.addColumn("DELETE_RULE", 5);
            table.addColumn("FK_NAME", 12);
            table.addColumn("PK_NAME", 12);
            table.addColumn("DEFERRABILITY", 5);
            table.createPrimaryKey();
            return table;
        }
        if (string.equals("SYSTEM_CROSSREFERENCE")) {
            Table table = this.createTable(string);
            table.addColumn("PKTABLE_CAT", 12);
            table.addColumn("PKTABLE_SCHEM", 12);
            table.addColumn("PKTABLE_NAME", 12);
            table.addColumn("PKCOLUMN_NAME", 12);
            table.addColumn("FKTABLE_CAT", 12);
            table.addColumn("FKTABLE_SCHEM", 12);
            table.addColumn("FKTABLE_NAME", 12);
            table.addColumn("FKCOLUMN_NAME", 12);
            table.addColumn("KEY_SEQ", 4);
            table.addColumn("UPDATE_RULE", 5);
            table.addColumn("DELETE_RULE", 5);
            table.addColumn("FK_NAME", 12);
            table.addColumn("PK_NAME", 12);
            table.addColumn("DEFERRABILITY", 5);
            table.createPrimaryKey();
            return table;
        }
        if (string.equals("SYSTEM_TYPEINFO")) {
            Table table = this.createTable(string);
            table.addColumn("TYPE_NAME", 12);
            table.addColumn("DATA_TYPE", 5);
            table.addColumn("PRECISION", 4);
            table.addColumn("LITERAL_PREFIX", 12);
            table.addColumn("LITERAL_SUFFIX", 12);
            table.addColumn("CREATE_PARAMS", 12);
            table.addColumn("NULLABLE", 5);
            table.addColumn("CASE_SENSITIVE", 12);
            table.addColumn("SEARCHABLE", 5);
            table.addColumn("UNSIGNED_ATTRIBUTE", -7);
            table.addColumn(META_FIXED_PREC_SCALE, -7);
            table.addColumn("AUTO_INCREMENT", -7);
            table.addColumn("LOCAL_TYPE_NAME", 12);
            table.addColumn("MINIMUM_SCALE", 5);
            table.addColumn("MAXIMUM_SCALE", 5);
            table.addColumn("SQL_DATE_TYPE", 4);
            table.addColumn("SQL_DATETIME_SUB", 4);
            table.addColumn(META_NUM_PREC_RADIX, 4);
            table.createPrimaryKey();
            int n = 0;
            while (n < Column.TYPES.length) {
                Object[] objectArray = table.getNewRow();
                int n7 = Column.TYPES[n];
                objectArray[0] = Column.getType(n7);
                objectArray[1] = new Short((short)n7);
                objectArray[2] = new Integer(0);
                objectArray[6] = new Short(1);
                objectArray[7] = new Boolean(true);
                objectArray[8] = new Short(3);
                objectArray[9] = new Boolean(false);
                objectArray[10] = new Boolean(n7 == 2 || n7 == 2);
                objectArray[11] = new Boolean(n7 == 4);
                objectArray[12] = objectArray[0];
                objectArray[13] = new Short(0);
                objectArray[14] = new Short(0);
                objectArray[15] = new Short(0);
                objectArray[16] = objectArray[15];
                objectArray[17] = new Integer(10);
                table.insert(objectArray, null);
                ++n;
            }
            return table;
        }
        if (string.equals("SYSTEM_INDEXINFO")) {
            Table table = this.createTable(string);
            table.addColumn("TABLE_CAT", 12);
            table.addColumn("TABLE_SCHEM", 12);
            table.addColumn("TABLE_NAME", 12);
            table.addColumn("NON_UNIQUE", -7);
            table.addColumn("INDEX_QUALIFIER", 12);
            table.addColumn("INDEX_NAME", 12);
            table.addColumn("TYPE", 5);
            table.addColumn(META_ORDINAL_POSITON, 5);
            table.addColumn("COLUMN_NAME", 12);
            table.addColumn(META_ASC_OR_DESC, 12);
            table.addColumn("CARDINALITY", 4);
            table.addColumn("PAGES", 4);
            table.addColumn("FILTER_CONDITION", 12);
            table.createPrimaryKey();
            int n = 0;
            while (n < this.tTable.size()) {
                Table table6 = (Table)this.tTable.elementAt(n);
                Index index = null;
                while ((index = table6.getNextIndex(index)) != null) {
                    int[] nArray = index.getColumns();
                    int n8 = nArray.length;
                    if (!index.isUnique()) {
                        --n8;
                    }
                    int n9 = 0;
                    while (n9 < n8) {
                        Object[] objectArray = table.getNewRow();
                        objectArray[2] = table6.getName();
                        objectArray[3] = new Boolean(!index.isUnique());
                        objectArray[5] = index.getName();
                        objectArray[6] = new Short(3);
                        objectArray[7] = new Short((short)(n9 + 1));
                        objectArray[8] = table6.getColumnName(nArray[n9]);
                        objectArray[9] = "A";
                        table.insert(objectArray, null);
                        ++n9;
                    }
                }
                ++n;
            }
            return table;
        }
        if (string.equals("SYSTEM_UDTS")) {
            Table table = this.createTable(string);
            table.addColumn("TYPE_CAT", 12);
            table.addColumn("TYPE_SCHEM", 12);
            table.addColumn("TYPE_NAME", 12);
            table.addColumn("CLASS_NAME", -7);
            table.addColumn("DATA_TYPE", 12);
            table.addColumn("REMARKS", 12);
            table.createPrimaryKey();
            return table;
        }
        if (string.equals("SYSTEM_CONNECTIONINFO")) {
            Table table = this.createTable(string);
            table.addColumn("KEY", 12);
            table.addColumn("VALUE", 12);
            table.createPrimaryKey();
            Object[] objectArray = table.getNewRow();
            objectArray[0] = "USER";
            objectArray[1] = channel.getUsername();
            table.insert(objectArray, null);
            objectArray = table.getNewRow();
            objectArray[0] = "READONLY";
            objectArray[1] = channel.isReadOnly() ? "TRUE" : "FALSE";
            table.insert(objectArray, null);
            objectArray = table.getNewRow();
            objectArray[0] = "MAXROWS";
            objectArray[1] = "" + channel.getMaxRows();
            table.insert(objectArray, null);
            objectArray = table.getNewRow();
            objectArray[0] = "DATABASE";
            objectArray[1] = "" + channel.getDatabase().getName();
            table.insert(objectArray, null);
            objectArray = table.getNewRow();
            objectArray[0] = "IDENTITY";
            objectArray[1] = "" + channel.getLastIdentity();
            table.insert(objectArray, null);
            return table;
        }
        return null;
    }

    Result getScript(boolean bl, boolean bl2, boolean bl3, Channel channel) throws SQLException {
        Object object;
        Object object2;
        Object object3;
        StringBuffer stringBuffer;
        channel.checkAdmin();
        Result result = new Result(1);
        result.iType[0] = 12;
        result.sTable[0] = "SYSTEM_SCRIPT";
        result.sLabel[0] = "COMMAND";
        result.sName[0] = "COMMAND";
        int n = 0;
        while (n < this.tTable.size()) {
            Object object4;
            Table table = (Table)this.tTable.elementAt(n);
            if (bl) {
                this.addRow(result, "DROP TABLE " + table.getName());
            }
            stringBuffer = new StringBuffer("CREATE ");
            if (table.isCached()) {
                stringBuffer.append("CACHED ");
            }
            stringBuffer.append("TABLE ");
            stringBuffer.append(table.getName());
            stringBuffer.append('(');
            int n2 = table.getColumnCount();
            object3 = table.getIndex("SYSTEM_PK");
            int n3 = object3 == null ? -1 : ((Index)object3).getColumns()[0];
            int n4 = 0;
            while (n4 < n2) {
                stringBuffer.append(table.getColumnName(n4));
                stringBuffer.append(' ');
                stringBuffer.append(Column.getType(table.getType(n4)));
                if (!table.getColumnIsNullable(n4)) {
                    stringBuffer.append(" NOT NULL");
                }
                if (n4 == table.getIdentityColumn()) {
                    stringBuffer.append(" IDENTITY");
                }
                if (n4 == n3) {
                    stringBuffer.append(" PRIMARY KEY");
                }
                if (n4 < n2 - 1) {
                    stringBuffer.append(',');
                }
                ++n4;
            }
            object2 = table.getConstraints();
            int n5 = 0;
            while (n5 < ((Vector)object2).size()) {
                object4 = (Constraint)((Vector)object2).elementAt(n5);
                if (((Constraint)object4).getType() == 0) {
                    stringBuffer.append(",FOREIGN KEY");
                    int[] nArray = ((Constraint)object4).getRefColumns();
                    stringBuffer.append(this.getColumnList(((Constraint)object4).getRef(), nArray, nArray.length));
                    stringBuffer.append("REFERENCES ");
                    stringBuffer.append(((Constraint)object4).getMain().getName());
                    nArray = ((Constraint)object4).getMainColumns();
                    stringBuffer.append(this.getColumnList(((Constraint)object4).getMain(), nArray, nArray.length));
                }
                ++n5;
            }
            stringBuffer.append(')');
            this.addRow(result, stringBuffer.toString());
            object = null;
            while ((object = table.getNextIndex((Index)object)) != null) {
                if (((Index)object).getName().equals("SYSTEM_PK") || ((Index)object).getName().startsWith("SYSTEM_FOREIGN_KEY")) continue;
                stringBuffer = new StringBuffer("CREATE ");
                if (((Index)object).isUnique()) {
                    stringBuffer.append("UNIQUE ");
                }
                stringBuffer.append("INDEX ");
                stringBuffer.append(((Index)object).getName());
                stringBuffer.append(" ON ");
                stringBuffer.append(table.getName());
                object4 = ((Index)object).getColumns();
                int n6 = ((Object)object4).length;
                if (!((Index)object).isUnique()) {
                    --n6;
                }
                stringBuffer.append(this.getColumnList(table, (int[])object4, n6));
                this.addRow(result, stringBuffer.toString());
            }
            if (bl2) {
                object4 = table.getPrimaryIndex();
                Node node = ((Index)object4).first();
                boolean bl4 = true;
                if (node != null) {
                    bl4 = false;
                    this.addRow(result, "SET REFERENTIAL_INTEGRITY FALSE");
                }
                while (node != null) {
                    this.addRow(result, table.getInsertStatement(node.getData()));
                    node = ((Index)object4).next(node);
                }
                if (!bl4) {
                    this.addRow(result, "SET REFERENTIAL_INTEGRITY TRUE");
                }
            }
            if (bl3 && table.isCached()) {
                stringBuffer = new StringBuffer("SET TABLE ");
                stringBuffer.append(table.getName());
                stringBuffer.append(" INDEX '");
                stringBuffer.append(table.getIndexRoots());
                stringBuffer.append("'");
                this.addRow(result, stringBuffer.toString());
            }
            ++n;
        }
        Vector vector = this.aAccess.getUsers();
        int n7 = 0;
        while (n7 < vector.size()) {
            User user = (User)vector.elementAt(n7);
            if (user != null) {
                Hashtable hashtable;
                object3 = user.getName();
                if (!((String)object3).equals("PUBLIC")) {
                    stringBuffer = new StringBuffer("CREATE USER ");
                    stringBuffer.append((String)object3);
                    stringBuffer.append(" PASSWORD ");
                    stringBuffer.append("\"" + user.getPassword() + "\"");
                    if (user.isAdmin()) {
                        stringBuffer.append(" ADMIN");
                    }
                    this.addRow(result, stringBuffer.toString());
                }
                if ((hashtable = user.getRights()) != null) {
                    object2 = hashtable.keys();
                    while (object2.hasMoreElements()) {
                        object = (String)object2.nextElement();
                        int n8 = (Integer)hashtable.get(object);
                        if (n8 == 0) continue;
                        stringBuffer = new StringBuffer("GRANT ");
                        stringBuffer.append(Access.getRight(n8));
                        stringBuffer.append(" ON ");
                        stringBuffer.append((String)object);
                        stringBuffer.append(" TO ");
                        stringBuffer.append(user.getName());
                        this.addRow(result, stringBuffer.toString());
                    }
                }
            }
            ++n7;
        }
        if (this.dDatabase.isIgnoreCase()) {
            this.addRow(result, "SET IGNORECASE TRUE");
        }
        Hashtable hashtable = this.dDatabase.getAlias();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object3 = (String)enumeration.nextElement();
            String string = (String)hashtable.get(object3);
            this.addRow(result, "CREATE ALIAS " + (String)object3 + " FOR \"" + string + "\"");
        }
        return result;
    }

    private String getColumnList(Table table, int[] nArray, int n) {
        StringBuffer stringBuffer = new StringBuffer("(");
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(table.getColumnName(nArray[n2]));
            if (n2 < n - 1) {
                stringBuffer.append(',');
            }
            ++n2;
        }
        return stringBuffer.append(')').toString();
    }

    private void addRow(Result result, String string) {
        Object[] objectArray = new String[]{string};
        result.add(objectArray);
    }

    private Table createTable(String string) {
        return new Table(this.dDatabase, false, string, false);
    }

    DatabaseInformation(Database database, Vector vector, Access access) {
        this.dDatabase = database;
        this.tTable = vector;
        this.aAccess = access;
    }
}

