/*
 * Decompiled with CFR 0.152.
 */
package org.hsql;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.hsql.Column;
import org.hsql.Function;
import org.hsql.Like;
import org.hsql.Record;
import org.hsql.Result;
import org.hsql.Select;
import org.hsql.TableFilter;
import org.hsql.Trace;

class Expression {
    static final int VALUE = 1;
    static final int COLUMN = 2;
    static final int QUERY = 3;
    static final int TRUE = 4;
    static final int VALUELIST = 5;
    static final int ASTERIX = 6;
    static final int FUNCTION = 7;
    static final int NEGATE = 9;
    static final int ADD = 10;
    static final int SUBTRACT = 11;
    static final int MULTIPLY = 12;
    static final int DIVIDE = 14;
    static final int CONCAT = 15;
    static final int NOT = 20;
    static final int EQUAL = 21;
    static final int BIGGER_EQUAL = 22;
    static final int BIGGER = 23;
    static final int SMALLER = 24;
    static final int SMALLER_EQUAL = 25;
    static final int NOT_EQUAL = 26;
    static final int LIKE = 27;
    static final int AND = 28;
    static final int OR = 29;
    static final int IN = 30;
    static final int EXISTS = 31;
    static final int COUNT = 40;
    static final int SUM = 41;
    static final int MIN = 42;
    static final int MAX = 43;
    static final int AVG = 44;
    static final int IFNULL = 60;
    static final int CONVERT = 61;
    static final int CASEWHEN = 62;
    static final int PLUS = 100;
    static final int OPEN = 101;
    static final int CLOSE = 102;
    static final int SELECT = 103;
    static final int COMMA = 104;
    static final int STRINGCONCAT = 105;
    static final int BETWEEN = 106;
    static final int CAST = 107;
    static final int END = 108;
    private int iType;
    private Expression eArg;
    private Expression eArg2;
    private Object oData;
    private int iDataType;
    private Hashtable hList;
    private Select sSelect;
    private Function fFunction;
    private char cLikeEscape;
    private String sTable;
    private String sColumn;
    private TableFilter tFilter;
    private int iColumn;
    private String sAlias;
    private boolean bDescending;

    void setLikeEscape(char c) {
        this.cLikeEscape = c;
    }

    void setDataType(int n) {
        this.iDataType = n;
    }

    void setTrue() {
        this.iType = 4;
    }

    boolean isAggregate() {
        return this.iType == 40 || this.iType == 43 || this.iType == 42 || this.iType == 41 || this.iType == 44;
    }

    void setDescending() {
        this.bDescending = true;
    }

    boolean isDescending() {
        return this.bDescending;
    }

    void setAlias(String string) {
        this.sAlias = string;
    }

    String getAlias() {
        if (this.sAlias != null) {
            return this.sAlias;
        }
        if (this.iType == 1) {
            return "";
        }
        if (this.iType == 2) {
            return this.sColumn;
        }
        return "";
    }

    int getType() {
        return this.iType;
    }

    int getColumnNr() {
        return this.iColumn;
    }

    Expression getArg() {
        return this.eArg;
    }

    Expression getArg2() {
        return this.eArg2;
    }

    TableFilter getFilter() {
        return this.tFilter;
    }

    void checkResolved() throws SQLException {
        Trace.check(this.iType != 2 || this.tFilter != null, 27, this.sColumn);
        if (this.eArg != null) {
            this.eArg.checkResolved();
        }
        if (this.eArg2 != null) {
            this.eArg2.checkResolved();
        }
        if (this.sSelect != null) {
            this.sSelect.checkResolved();
        }
        if (this.fFunction != null) {
            this.fFunction.checkResolved();
        }
    }

    void resolve(TableFilter tableFilter) throws SQLException {
        int n;
        if (tableFilter != null && this.iType == 2 && (this.sTable == null || tableFilter.getName().equals(this.sTable)) && (n = tableFilter.getTable().searchColumn(this.sColumn)) != -1) {
            Trace.check(this.tFilter == null || this.tFilter == tableFilter, 27, this.sColumn);
            this.tFilter = tableFilter;
            this.iColumn = n;
            this.sTable = tableFilter.getName();
            this.iDataType = tableFilter.getTable().getColumnType(n);
        }
        if (this.eArg != null) {
            this.eArg.resolve(tableFilter);
        }
        if (this.eArg2 != null) {
            this.eArg2.resolve(tableFilter);
        }
        if (this.sSelect != null) {
            this.sSelect.resolve(tableFilter, false);
            this.sSelect.resolve();
        }
        if (this.fFunction != null) {
            this.fFunction.resolve(tableFilter);
        }
        if (this.iDataType != 0) {
            return;
        }
        switch (this.iType) {
            case 7: {
                this.iDataType = this.fFunction.getReturnType();
                break;
            }
            case 3: {
                this.iDataType = this.sSelect.eColumn[0].iDataType;
                break;
            }
            case 9: {
                this.iDataType = this.eArg.iDataType;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                this.iDataType = this.eArg.iDataType;
                break;
            }
            case 15: {
                this.iDataType = 12;
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                this.iDataType = -7;
                break;
            }
            case 40: {
                this.iDataType = 4;
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                this.iDataType = this.eArg.iDataType;
                break;
            }
            case 61: {
                break;
            }
            case 60: 
            case 62: {
                this.iDataType = this.eArg2.iDataType;
                break;
            }
        }
    }

    boolean isResolved() {
        if (this.iType == 1) {
            return true;
        }
        if (this.iType == 2) {
            return this.tFilter != null;
        }
        return false;
    }

    static boolean isCompare(int n) {
        switch (n) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    String getTableName() {
        if (this.iType == 6) {
            return this.sTable;
        }
        if (this.iType == 2) {
            if (this.tFilter == null) {
                return this.sTable;
            }
            return this.tFilter.getTable().getName();
        }
        return "";
    }

    String getColumnName() {
        if (this.iType == 2) {
            if (this.tFilter == null) {
                return this.sColumn;
            }
            return this.tFilter.getTable().getColumnName(this.iColumn);
        }
        return this.getAlias();
    }

    void swapCondition() throws SQLException {
        int n = 21;
        switch (this.iType) {
            case 22: {
                n = 25;
                break;
            }
            case 25: {
                n = 22;
                break;
            }
            case 24: {
                n = 23;
                break;
            }
            case 23: {
                n = 24;
                break;
            }
            case 21: {
                break;
            }
            default: {
                Trace.assert(false, "Expression.swapCondition");
            }
        }
        this.iType = n;
        Expression expression = this.eArg;
        this.eArg = this.eArg2;
        this.eArg2 = expression;
    }

    Object getValue(int n) throws SQLException {
        Object object = this.getValue();
        if (object == null || this.iDataType == n) {
            return object;
        }
        String string = Column.convertObject(object);
        return Column.convertString(string, n);
    }

    int getDataType() {
        return this.iDataType;
    }

    Object getValue() throws SQLException {
        switch (this.iType) {
            case 1: {
                return this.oData;
            }
            case 2: {
                try {
                    return this.tFilter.oCurrentData[this.iColumn];
                }
                catch (NullPointerException nullPointerException) {
                    throw Trace.error(27, this.sColumn);
                }
            }
            case 7: {
                return this.fFunction.getValue();
            }
            case 3: {
                return this.sSelect.getValue(this.iDataType);
            }
            case 9: {
                return Column.negate(this.eArg.getValue(this.iDataType), this.iDataType);
            }
            case 40: {
                if (this.eArg.iType == 6 || this.eArg.getValue() != null) {
                    return new Integer(1);
                }
                return new Integer(0);
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                return this.eArg.getValue();
            }
            case 31: {
                return new Boolean(this.test());
            }
            case 61: {
                return this.eArg.getValue(this.iDataType);
            }
            case 62: {
                if (this.eArg.test()) {
                    return this.eArg2.eArg.getValue();
                }
                return this.eArg2.eArg2.getValue();
            }
        }
        Object object = null;
        Object object2 = null;
        if (this.eArg != null) {
            object = this.eArg.getValue(this.iDataType);
        }
        if (this.eArg2 != null) {
            object2 = this.eArg2.getValue(this.iDataType);
        }
        switch (this.iType) {
            case 10: {
                return Column.add(object, object2, this.iDataType);
            }
            case 11: {
                return Column.subtract(object, object2, this.iDataType);
            }
            case 12: {
                return Column.multiply(object, object2, this.iDataType);
            }
            case 14: {
                return Column.divide(object, object2, this.iDataType);
            }
            case 15: {
                return Column.concat(object, object2);
            }
            case 60: {
                return object == null ? object2 : object;
            }
        }
        return new Boolean(this.test());
    }

    private boolean testValueList(String string) throws SQLException {
        if (this.iType == 5) {
            return this.hList.containsKey(string);
        }
        if (this.iType == 3) {
            Hashtable<String, Expression> hashtable = new Hashtable<String, Expression>();
            Result result = this.sSelect.getResult(0);
            Record record = result.rRoot;
            int n = result.iType[0];
            while (record != null) {
                String string2 = Column.createString(record.data[0], n);
                if (string2 != null) {
                    hashtable.put(string2, this);
                }
                record = record.next;
            }
            return hashtable.containsKey(string);
        }
        throw Trace.error(15);
    }

    boolean test() throws SQLException {
        switch (this.iType) {
            case 4: {
                return true;
            }
            case 20: {
                Trace.assert(this.eArg2 == null, "Expression.test");
                return !this.eArg.test();
            }
            case 28: {
                return this.eArg.test() && this.eArg2.test();
            }
            case 29: {
                return this.eArg.test() || this.eArg2.test();
            }
            case 27: {
                String string = (String)this.eArg2.getValue(12);
                Like like = new Like(string, this.cLikeEscape);
                String string2 = (String)this.eArg.getValue(12);
                return like.compare(string2);
            }
            case 30: {
                String string = (String)this.eArg.getValue(12);
                return this.eArg2.testValueList(string);
            }
            case 31: {
                Result result = this.eArg.sSelect.getResult(1);
                return result.rRoot != null;
            }
        }
        Trace.check(this.eArg != null, 38);
        Object object = this.eArg.getValue();
        int n = this.eArg.iDataType;
        Trace.check(this.eArg2 != null, 38);
        Object object2 = this.eArg2.getValue(n);
        int n2 = Column.compare(object, object2, n);
        switch (this.iType) {
            case 21: {
                return n2 == 0;
            }
            case 23: {
                return n2 > 0;
            }
            case 22: {
                return n2 >= 0;
            }
            case 25: {
                return n2 <= 0;
            }
            case 24: {
                return n2 < 0;
            }
            case 26: {
                return n2 != 0;
            }
        }
        Trace.assert(false, "Expression.test2");
        return false;
    }

    Expression(Function function) {
        this.iType = 7;
        this.fFunction = function;
    }

    Expression(Expression expression) {
        this.iType = expression.iType;
        this.iDataType = expression.iDataType;
        this.eArg = expression.eArg;
        this.eArg2 = expression.eArg2;
        this.cLikeEscape = expression.cLikeEscape;
        this.sSelect = expression.sSelect;
        this.fFunction = expression.fFunction;
    }

    Expression(Select select) {
        this.iType = 3;
        this.sSelect = select;
    }

    Expression(Vector vector) {
        this.iType = 5;
        int n = vector.size();
        this.hList = new Hashtable(n);
        int n2 = 0;
        while (n2 < n) {
            Object e = vector.elementAt(n2);
            if (e != null) {
                this.hList.put(e, this);
            }
            ++n2;
        }
    }

    Expression(int n, Expression expression, Expression expression2) {
        this.iType = n;
        this.eArg = expression;
        this.eArg2 = expression2;
    }

    Expression(String string, String string2) {
        this.sTable = string;
        if (string2 == null) {
            this.iType = 6;
        } else {
            this.iType = 2;
            this.sColumn = string2;
        }
    }

    Expression(int n, Object object) {
        this.iType = 1;
        this.iDataType = n;
        this.oData = object;
    }
}

