/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.proxy;

import com.sun.javaws.ConfigProperties;
import com.sun.javaws.proxy.InternetProxyFactory;
import com.sun.javaws.proxy.InternetProxyInfo;
import com.sun.javaws.proxy.NSRegistry;
import java.io.File;
import java.util.List;
import java.util.StringTokenizer;

public abstract class InternetProxy {
    private static InternetProxy _internetProxy = null;

    public static synchronized InternetProxy getInstance() {
        if (_internetProxy == null) {
            _internetProxy = InternetProxyFactory.newInstance();
        }
        return _internetProxy;
    }

    public abstract InternetProxyInfo getBrowserInfo();

    public InternetProxyInfo getDefaultInfo() {
        InternetProxyInfo internetProxyInfo = new InternetProxyInfo();
        ConfigProperties configProperties = ConfigProperties.getInstance();
        int n = configProperties.getProxyType();
        if (n == 1) {
            try {
                int n2 = Integer.parseInt(configProperties.getHTTPProxyPort());
                String string = configProperties.getHTTPProxy();
                List list = configProperties.getProxyOverrideList();
                if (string != null && string.length() > 0 && n2 != 0) {
                    internetProxyInfo.setHTTPPort(n2);
                    internetProxyInfo.setHTTPHost(string);
                    internetProxyInfo.setOverrides(list);
                    internetProxyInfo.setType(n);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (n == 2) {
            internetProxyInfo = this.getBrowserInfo();
        }
        return internetProxyInfo;
    }

    File getNS6RegFile() {
        return null;
    }

    public String getNS6PrefsDir() {
        File file = this.getNS6RegFile();
        if (file != null) {
            return InternetProxy.getNS6PrefsDirFromReg(file);
        }
        return null;
    }

    static File getNS6PrefsFile(File file) {
        String string = InternetProxy.getNS6PrefsDirFromReg(file);
        return string != null ? new File(string, "prefs.js") : null;
    }

    private static String getNS6PrefsDirFromReg(File file) {
        NSRegistry nSRegistry = new NSRegistry().open(file);
        if (nSRegistry == null) {
            return null;
        }
        String string = nSRegistry.get("Common/Profiles/CurrentProfile");
        String string2 = null;
        if (nSRegistry != null) {
            string2 = nSRegistry.get("Common/Profiles/" + string + "/directory");
        }
        if (string2 == null) {
            string2 = nSRegistry.get("Common/Profiles/default/directory");
        }
        nSRegistry.close();
        return string2;
    }

    public String extractAutoProxySetting(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                int n = string2.indexOf("PROXY");
                if (n != -1) {
                    return string2.substring(n + 6);
                }
                n = string2.indexOf("SOCKS");
                if (n != -1) {
                    return string2.substring(n + 6);
                }
                n = string2.indexOf("DIRECT");
                if (n == -1) continue;
                return "";
            }
        }
        return null;
    }

    public String getProxyStringFromPacFile(String string) {
        String string2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            int n = string3.indexOf("DIRECT");
            int n2 = string3.indexOf("PROXY");
            int n3 = n2 >= 0 ? n2 : n;
            int n4 = string3.lastIndexOf("\"");
            if (n3 == -1) continue;
            if (n4 <= n3) {
                string2 = string3.substring(n3);
                break;
            }
            string2 = string3.substring(n3, n4);
            break;
        }
        return this.extractAutoProxySetting(string2);
    }
}

