/*
 * Decompiled with CFR 0.152.
 */
package sun.net.spi.nameservice.dns;

import java.lang.ref.SoftReference;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.spi.NamingManager;
import sun.net.dns.ResolverConfiguration;
import sun.net.spi.nameservice.NameService;
import sun.security.action.GetPropertyAction;

public final class DNSNameService
implements NameService {
    private LinkedList domainList = null;
    private String nameProviderUrl = null;
    private static ThreadLocal contextRef;
    static final /* synthetic */ boolean $assertionsDisabled;

    private DirContext getTemporaryContext() throws NamingException {
        SoftReference softReference = (SoftReference)contextRef.get();
        ThreadContext threadContext = null;
        List<String> list = null;
        if (this.nameProviderUrl == null) {
            list = ResolverConfiguration.open().nameservers();
        }
        if (softReference != null && (threadContext = (ThreadContext)softReference.get()) != null && this.nameProviderUrl == null && !((Object)threadContext.nameservers()).equals(list)) {
            threadContext = null;
        }
        if (threadContext == null) {
            DirContext dirContext;
            final Properties properties = new Properties();
            properties.setProperty("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            String string = this.nameProviderUrl;
            if (string == null && (string = DNSNameService.createProviderURL(list)).length() == 0) {
                throw new RuntimeException("bad nameserver configuration");
            }
            properties.setProperty("java.naming.provider.url", string);
            try {
                dirContext = (DirContext)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws NamingException {
                        Context context = NamingManager.getInitialContext(properties);
                        if (!(context instanceof DirContext)) {
                            return null;
                        }
                        return context;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (NamingException)privilegedActionException.getException();
            }
            threadContext = new ThreadContext(dirContext, list);
            contextRef.set(new SoftReference<ThreadContext>(threadContext));
        }
        return threadContext.dirContext();
    }

    private ArrayList resolve(final DirContext dirContext, final String string, final String[] stringArray, int n) throws UnknownHostException {
        Attributes attributes;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            attributes = (Attributes)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    return dirContext.getAttributes(string, stringArray);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new UnknownHostException(privilegedActionException.getException().getMessage());
        }
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
        if (!namingEnumeration.hasMoreElements()) {
            throw new UnknownHostException("DNS record not found");
        }
        UnknownHostException unknownHostException = null;
        try {
            while (namingEnumeration.hasMoreElements()) {
                Attribute attribute = namingEnumeration.next();
                String string2 = attribute.getID();
                NamingEnumeration<?> namingEnumeration2 = attribute.getAll();
                while (namingEnumeration2.hasMoreElements()) {
                    String string3 = (String)namingEnumeration2.next();
                    if (string2.equals("CNAME")) {
                        if (n > 4) {
                            throw new UnknownHostException(string + ": possible CNAME loop");
                        }
                        try {
                            arrayList.addAll(this.resolve(dirContext, string3, stringArray, n + 1));
                        }
                        catch (UnknownHostException unknownHostException2) {
                            if (unknownHostException != null) continue;
                            unknownHostException = unknownHostException2;
                        }
                        continue;
                    }
                    arrayList.add(string3);
                }
            }
        }
        catch (NamingException namingException) {
            throw new UnknownHostException(namingException.getMessage());
        }
        if (arrayList.isEmpty() && unknownHostException != null) {
            throw unknownHostException;
        }
        return arrayList;
    }

    public DNSNameService() throws Exception {
        String string;
        String string2 = AccessController.doPrivileged(new GetPropertyAction("sun.net.spi.nameservice.domain"));
        if (string2 != null && string2.length() > 0) {
            this.domainList = new LinkedList();
            this.domainList.add(string2);
        }
        if ((string = AccessController.doPrivileged(new GetPropertyAction("sun.net.spi.nameservice.nameservers"))) != null && string.length() > 0) {
            this.nameProviderUrl = DNSNameService.createProviderURL(string);
            if (this.nameProviderUrl.length() == 0) {
                throw new RuntimeException("malformed nameservers property");
            }
        } else {
            List<String> list = ResolverConfiguration.open().nameservers();
            if (list.size() == 0) {
                throw new RuntimeException("no nameservers provided");
            }
            boolean bl = false;
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                String string3 = iterator.next();
                if (!DNSNameService.isIPv4LiteralAddress(string3) && !DNSNameService.isIPv6LiteralAddress(string3)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                throw new RuntimeException("bad nameserver configuration");
            }
        }
    }

    public byte[][] lookupAllHostAddr(String string) throws UnknownHostException {
        String string2;
        int n;
        List<String> list;
        DirContext dirContext;
        String[] stringArray = new String[]{"A", "AAAA", "CNAME"};
        try {
            dirContext = this.getTemporaryContext();
        }
        catch (NamingException namingException) {
            throw new Error(namingException);
        }
        ArrayList arrayList = null;
        UnknownHostException unknownHostException = null;
        if (string.indexOf(46) >= 0) {
            try {
                arrayList = this.resolve(dirContext, string, stringArray, 0);
            }
            catch (UnknownHostException unknownHostException2) {
                unknownHostException = unknownHostException2;
            }
        }
        if (arrayList == null) {
            Iterator iterator;
            list = null;
            n = 0;
            if (this.domainList != null) {
                iterator = this.domainList.iterator();
            } else {
                list = ResolverConfiguration.open().searchlist();
                if (list.size() > 1) {
                    n = 1;
                }
                iterator = list.iterator();
            }
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                int n2 = 0;
                while ((n2 = string2.indexOf(".")) != -1 && n2 < string2.length() - 1) {
                    try {
                        arrayList = this.resolve(dirContext, string + "." + string2, stringArray, 0);
                        break;
                    }
                    catch (UnknownHostException unknownHostException3) {
                        unknownHostException = unknownHostException3;
                        if (n != 0) break;
                        string2 = string2.substring(n2 + 1);
                    }
                }
                if (arrayList == null) continue;
            }
        }
        if (arrayList == null && string.indexOf(46) < 0) {
            arrayList = this.resolve(dirContext, string, stringArray, 0);
        }
        if (arrayList == null) {
            if (!$assertionsDisabled && unknownHostException == null) {
                throw new AssertionError();
            }
            throw unknownHostException;
        }
        if (!$assertionsDisabled && arrayList.size() <= 0) {
            throw new AssertionError();
        }
        list = (List<String>)new byte[arrayList.size()][];
        int n3 = 0;
        for (n = 0; n < arrayList.size(); ++n) {
            string2 = (String)arrayList.get(n);
            byte[] byArray = DNSNameService.textToIPv4Address(string2);
            if (byArray == null) {
                byArray = DNSNameService.textToIPv6Address(string2);
            }
            if (byArray == null) continue;
            list[n3++] = byArray;
        }
        if (n3 == 0) {
            throw new UnknownHostException(string + ": no valid DNS records");
        }
        if (n3 < arrayList.size()) {
            byte[][] byArrayArray = new byte[n3][];
            for (int i = 0; i < n3; ++i) {
                byArrayArray[i] = (byte[])list[i];
            }
            list = (List<String>)byArrayArray;
        }
        return list;
    }

    public String getHostByAddr(byte[] byArray) throws UnknownHostException {
        try {
            DirContext dirContext;
            int n;
            String string = "";
            if (byArray.length == 4) {
                for (n = byArray.length - 1; n >= 0; --n) {
                    string = string + (byArray[n] & 0xFF) + ".";
                }
            } else if (byArray.length == 16) {
                for (n = byArray.length - 1; n >= 0; --n) {
                    string = string + (byArray[n] & 0xF) + "." + (byArray[n] & 0xF0) + ".";
                }
            }
            if (byArray.length == 4) {
                string = string + "IN-ADDR.ARPA.";
            } else if (byArray.length == 16) {
                string = string + "IP6.INT.";
            }
            String[] stringArray = new String[]{"PTR"};
            try {
                dirContext = this.getTemporaryContext();
            }
            catch (NamingException namingException) {
                throw new Error(namingException);
            }
            ArrayList arrayList = this.resolve(dirContext, string, stringArray, 0);
            String string2 = (String)arrayList.get(0);
            if (string2.endsWith(".")) {
                string2 = string2.substring(0, string2.length() - 1);
            }
            return string2;
        }
        catch (Exception exception) {
            throw new UnknownHostException(exception.getMessage());
        }
    }

    private static void appendIfLiteralAddress(String string, StringBuffer stringBuffer) {
        if (DNSNameService.isIPv4LiteralAddress(string)) {
            stringBuffer.append("dns://" + string + " ");
        } else if (DNSNameService.isIPv6LiteralAddress(string)) {
            stringBuffer.append("dns://[" + string + "] ");
        }
    }

    private static String createProviderURL(List list) {
        Iterator iterator = list.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            DNSNameService.appendIfLiteralAddress((String)iterator.next(), stringBuffer);
        }
        return stringBuffer.toString();
    }

    private static String createProviderURL(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            DNSNameService.appendIfLiteralAddress(stringTokenizer.nextToken(), stringBuffer);
        }
        return stringBuffer.toString();
    }

    private static boolean isIPv4LiteralAddress(String string) {
        return DNSNameService.textToIPv4Address(string) != null;
    }

    private static boolean isIPv6LiteralAddress(String string) {
        return DNSNameService.textToIPv6Address(string) != null;
    }

    private static byte[] textToIPv4Address(String string) {
        if (string.length() == 0) {
            return null;
        }
        byte[] byArray = new byte[4];
        char[] cArray = string.toCharArray();
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n2 < cArray.length) {
            char c;
            if (Character.isDigit(c = cArray[n2++])) {
                int n4 = byArray[n3] * 10 + (Character.digit(c, 10) & 0xFF);
                if (n4 > 255) {
                    return null;
                }
                byArray[n3] = (byte)(n4 & 0xFF);
                if (bl) continue;
                if (++n > 4) {
                    return null;
                }
                bl = true;
                continue;
            }
            if (c == '.' && bl) {
                if (n == 4) {
                    return null;
                }
                byArray[++n3] = 0;
                bl = false;
                continue;
            }
            return null;
        }
        if (n < 4) {
            return null;
        }
        return byArray;
    }

    private static byte[] textToIPv6Address(String string) {
        int n;
        if (string.length() == 0) {
            return null;
        }
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[16];
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        if (cArray[n3] == ':' && cArray[++n3] != ':') {
            return null;
        }
        int n5 = n3;
        boolean bl = false;
        int n6 = 0;
        while (n3 < cArray.length) {
            char c;
            if ((n = Character.digit(c = cArray[n3++], 16)) != -1) {
                n6 <<= 4;
                if ((n6 |= n) > 65535) {
                    return null;
                }
                bl = true;
                continue;
            }
            if (c == ':') {
                n5 = n3;
                if (!bl) {
                    if (n2 != -1) {
                        return null;
                    }
                    n2 = n4;
                    continue;
                }
                if (n3 == cArray.length) {
                    return null;
                }
                if (n4 + 2 > 16) {
                    return null;
                }
                byArray[n4++] = (byte)(n6 >> 8 & 0xFF);
                byArray[n4++] = (byte)(n6 & 0xFF);
                bl = false;
                n6 = 0;
                continue;
            }
            if (c == '.' && n4 + 4 <= 16) {
                byte[] byArray2 = DNSNameService.textToIPv4Address(string.substring(n5));
                if (byArray2 == null) {
                    return null;
                }
                for (int i = 0; i < 4; ++i) {
                    byArray[n4++] = byArray2[i];
                }
                bl = false;
                break;
            }
            return null;
        }
        if (bl) {
            if (n4 + 2 > 16) {
                return null;
            }
            byArray[n4++] = (byte)(n6 >> 8 & 0xFF);
            byArray[n4++] = (byte)(n6 & 0xFF);
        }
        if (n2 != -1) {
            n = n4 - n2;
            if (n4 == 16) {
                return null;
            }
            for (n3 = 1; n3 <= n; ++n3) {
                byArray[16 - n3] = byArray[n2 + n - n3];
                byArray[n2 + n - n3] = 0;
            }
            n4 = 16;
        }
        if (n4 != 16) {
            return null;
        }
        return byArray;
    }

    static {
        $assertionsDisabled = !DNSNameService.class.desiredAssertionStatus();
        contextRef = new ThreadLocal();
    }

    private static class ThreadContext {
        private DirContext dirCtxt;
        private List nsList;

        public ThreadContext(DirContext dirContext, List list) {
            this.dirCtxt = dirContext;
            this.nsList = list;
        }

        public DirContext dirContext() {
            return this.dirCtxt;
        }

        public List nameservers() {
            return this.nsList;
        }
    }
}

