/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.SynthButtonUI;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingConstants;

class SynthArrowButton
extends JButton
implements SwingConstants {
    private int direction;

    public int getDirection() {
        return this.direction;
    }

    public void updateUI() {
        this.setUI(new SynthArrowButtonUI(null));
    }

    public SynthArrowButton(int n2) {
        this.setFocusable(false);
        this.setDirection(n2);
        this.setDefaultCapable(false);
    }

    public void setDirection(int n2) {
        this.direction = n2;
    }

    public Dimension getMaximumSize() {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension getMinimumSize() {
        return new Dimension(5, 5);
    }

    public String getUIClassID() {
        return "ArrowButtonUI";
    }

    static class 1 {
    }

    private static class SynthArrowButtonUI
    extends SynthButtonUI {
        private SynthArrowButtonUI() {
        }

        SynthArrowButtonUI(1 var1_1) {
            this();
        }

        protected void installDefaults(AbstractButton abstractButton) {
            super.installDefaults(abstractButton);
            this.fetchStyle(abstractButton);
        }

        public Dimension getPreferredSize(JComponent jComponent) {
            SynthContext synthContext = this.getContext(jComponent);
            int n2 = synthContext.getStyle().getInt(synthContext, "ArrowButton.size", 16);
            synthContext.dispose();
            return new Dimension(n2, n2);
        }

        protected void paint(SynthContext synthContext, Graphics graphics) {
            SynthLookAndFeel.paintForeground(synthContext, graphics, null);
        }
    }
}

