/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.filechooser.FileView;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.text.JTextComponent;

abstract class SynthFileChooserUI
extends FileChooserUI
implements SynthUI {
    private JFileChooser filechooser = null;
    private JButton approveButton;
    private JButton cancelButton;
    private SynthStyle style;
    private SynthFileView fileView = new SynthFileView(this);
    private BasicDirectoryModel model = null;
    private PropertyChangeListener propertyChangeListener = null;
    private String saveButtonText = null;
    private String openButtonText = null;
    private String cancelButtonText = null;
    private String openDialogTitleText = null;
    private String saveDialogTitleText = null;
    private String saveButtonToolTipText = null;
    private String openButtonToolTipText = null;
    private String cancelButtonToolTipText = null;
    private int saveButtonMnemonic = 0;
    private int openButtonMnemonic = 0;
    private int cancelButtonMnemonic = 0;
    private Action approveSelectionAction = new ApproveSelectionAction(this);
    private Action cancelSelectionAction = new CancelSelectionAction(this);
    private Action newFolderAction = new NewFolderAction(this);
    private Action goHomeAction = new GoHomeAction(this);
    private Action changeToParentDirectoryAction = new ChangeToParentDirectoryAction(this);
    private Action fileNameCompletionAction = new FileNameCompletionAction(this);
    private String newFolderErrorSeparator = null;
    private String newFolderErrorText = null;
    private String fileDescriptionText = null;
    private String directoryDescriptionText = null;
    private AcceptAllFileFilter acceptAllFileFilter = new AcceptAllFileFilter(this);
    private boolean directorySelected = false;
    private File directory = null;
    private FileFilter actualFileFilter = null;
    private GlobFilter globFilter = null;
    private String fileNameCompletionString;
    static Class class$com$sun$java$swing$plaf$gtk$SynthContext;

    SynthFileChooserUI() {
    }

    protected void createModel() {
        this.model = new BasicDirectoryModel(this.getFileChooser());
    }

    private void resetGlobFilter() {
        if (this.actualFileFilter != null) {
            JFileChooser jFileChooser = this.getFileChooser();
            FileFilter fileFilter = jFileChooser.getFileFilter();
            if (fileFilter != null && fileFilter.equals(this.globFilter)) {
                jFileChooser.setFileFilter(this.actualFileFilter);
                jFileChooser.removeChoosableFileFilter(this.globFilter);
            }
            this.actualFileFilter = null;
        }
    }

    private void updateFileNameCompletion() {
        if (this.fileNameCompletionString != null && this.fileNameCompletionString.equals(this.getFileName())) {
            File[] fileArray = (File[])this.getModel().getFiles().toArray(new File[0]);
            String string = this.getCommonStartString(fileArray);
            if (string != null && string.startsWith(this.fileNameCompletionString)) {
                this.setFileName(string);
            }
            this.fileNameCompletionString = null;
        }
    }

    protected boolean isDirectorySelected() {
        return this.directorySelected;
    }

    protected void setDirectorySelected(boolean bl2) {
        this.directorySelected = bl2;
    }

    static void access$000(SynthFileChooserUI synthFileChooserUI) {
        synthFileChooserUI.updateFileNameCompletion();
    }

    static void access$100(SynthFileChooserUI synthFileChooserUI) {
        synthFileChooserUI.resetGlobFilter();
    }

    protected void doAccessoryChanged(PropertyChangeEvent propertyChangeEvent) {
    }

    protected void doAncestorChanged(PropertyChangeEvent propertyChangeEvent) {
    }

    protected void doControlButtonsChanged(PropertyChangeEvent propertyChangeEvent) {
        if (this.filechooser.getControlButtonsAreShown()) {
            this.approveButton.setText(this.getApproveButtonText(this.getFileChooser()));
            this.approveButton.setToolTipText(this.getApproveButtonToolTipText(this.getFileChooser()));
        }
    }

    protected void doDirectoryChanged(PropertyChangeEvent propertyChangeEvent) {
        File file = this.getFileChooser().getCurrentDirectory();
        if (file != null) {
            this.getNewFolderAction().setEnabled(file.canWrite());
        }
    }

    protected void doFileSelectionModeChanged(PropertyChangeEvent propertyChangeEvent) {
    }

    protected void doMultiSelectionChanged(PropertyChangeEvent propertyChangeEvent) {
        if (!this.getFileChooser().isMultiSelectionEnabled()) {
            this.getFileChooser().setSelectedFiles(null);
        }
    }

    protected void doSelectedFileChanged(PropertyChangeEvent propertyChangeEvent) {
    }

    protected File getDirectory() {
        return this.directory;
    }

    protected void setDirectory(File file) {
        this.directory = file;
    }

    public abstract String getFileName();

    public abstract void setFileName(String var1);

    static boolean access$200(String string) {
        return SynthFileChooserUI.isGlobPattern(string);
    }

    private static boolean isGlobPattern(String string) {
        return File.separatorChar == '\\' && string.indexOf(42) >= 0 || File.separatorChar == '/' && (string.indexOf(42) >= 0 || string.indexOf(63) >= 0 || string.indexOf(91) >= 0);
    }

    public Action getApproveSelectionAction() {
        return this.approveSelectionAction;
    }

    public Action getCancelSelectionAction() {
        return this.cancelSelectionAction;
    }

    public Action getChangeToParentDirectoryAction() {
        return this.changeToParentDirectoryAction;
    }

    public Action getFileNameCompletionAction() {
        return this.fileNameCompletionAction;
    }

    public Action getGoHomeAction() {
        return this.goHomeAction;
    }

    public Action getNewFolderAction() {
        return this.newFolderAction;
    }

    ActionMap createActionMap() {
        AbstractAction abstractAction = new AbstractAction(this){
            private final SynthFileChooserUI this$0;

            public boolean isEnabled() {
                return this.this$0.getFileChooser().isEnabled();
            }
            {
                this.this$0 = synthFileChooserUI;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                this.this$0.getFileChooser().cancelSelection();
            }
        };
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("approveSelection", this.getApproveSelectionAction());
        actionMapUIResource.put("cancelSelection", abstractAction);
        actionMapUIResource.put("Go Up", this.getChangeToParentDirectoryAction());
        actionMapUIResource.put("fileNameCompletion", this.getFileNameCompletionAction());
        return actionMapUIResource;
    }

    ActionMap getActionMap() {
        return this.createActionMap();
    }

    InputMap getInputMap(int n2) {
        if (n2 == 1) {
            SynthContext synthContext = this.getContext(this.filechooser, 1);
            InputMap inputMap = (InputMap)synthContext.getStyle().get(synthContext, "FileChooser.ancestorInputMap");
            synthContext.dispose();
            return inputMap;
        }
        return null;
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    private void fetchStyle(JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent, 1);
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
    }

    public void installUI(JComponent jComponent) {
        this.filechooser = (JFileChooser)jComponent;
        this.createModel();
        this.installDefaults(this.filechooser);
        this.installComponents(this.filechooser);
        this.installListeners(this.filechooser);
        this.filechooser.applyComponentOrientation(this.filechooser.getComponentOrientation());
    }

    public void uninstallUI(JComponent jComponent) {
        this.getFileChooser().removeAll();
        this.uninstallListeners(this.filechooser);
        this.uninstallComponents(this.filechooser);
        this.uninstallDefaults(this.filechooser);
    }

    public JFileChooser getFileChooser() {
        return this.filechooser;
    }

    public int getApproveButtonMnemonic(JFileChooser jFileChooser) {
        int n2 = jFileChooser.getApproveButtonMnemonic();
        if (n2 > 0) {
            return n2;
        }
        if (jFileChooser.getDialogType() == 0) {
            return this.openButtonMnemonic;
        }
        if (jFileChooser.getDialogType() == 1) {
            return this.saveButtonMnemonic;
        }
        return n2;
    }

    public void installComponents(JFileChooser jFileChooser) {
        SynthContext synthContext = this.getContext(jFileChooser, 1);
        this.cancelButton = new JButton(this.cancelButtonText);
        this.cancelButton.setName("SynthFileChooser.cancelButton");
        this.cancelButton.setIcon(synthContext.getStyle().getIcon(synthContext, "FileChooser.cancelIcon"));
        this.cancelButton.setMnemonic(this.cancelButtonMnemonic);
        this.cancelButton.setToolTipText(this.cancelButtonToolTipText);
        this.cancelButton.addActionListener(this.getCancelSelectionAction());
        this.approveButton = new JButton(this.getApproveButtonText(jFileChooser));
        this.approveButton.setName("SynthFileChooser.approveButton");
        this.approveButton.setIcon(synthContext.getStyle().getIcon(synthContext, "FileChooser.okIcon"));
        this.approveButton.setMnemonic(this.getApproveButtonMnemonic(jFileChooser));
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText(jFileChooser));
        this.approveButton.addActionListener(this.getApproveSelectionAction());
    }

    protected void installDefaults(JFileChooser jFileChooser) {
        this.fetchStyle(jFileChooser);
        this.installIcons(jFileChooser);
        this.installStrings(jFileChooser);
    }

    protected void installIcons(JFileChooser jFileChooser) {
    }

    protected void installListeners(JFileChooser jFileChooser) {
        this.propertyChangeListener = this.createPropertyChangeListener(jFileChooser);
        if (this.propertyChangeListener != null) {
            jFileChooser.addPropertyChangeListener(this.propertyChangeListener);
        }
        jFileChooser.addPropertyChangeListener(this.getModel());
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(jFileChooser, 1, inputMap);
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(jFileChooser, actionMap);
        this.getModel().addListDataListener(new ListDataListener(this){
            private final SynthFileChooserUI this$0;
            {
                this.this$0 = synthFileChooserUI;
            }

            public void contentsChanged(ListDataEvent listDataEvent) {
                new DelayedSelectionUpdater(this.this$0);
            }

            public void intervalAdded(ListDataEvent listDataEvent) {
                new DelayedSelectionUpdater(this.this$0);
            }

            public void intervalRemoved(ListDataEvent listDataEvent) {
            }
        });
    }

    protected void installStrings(JFileChooser jFileChooser) {
        Locale locale = jFileChooser.getLocale();
        this.newFolderErrorText = UIManager.getString((Object)"FileChooser.newFolderErrorText", locale);
        this.newFolderErrorSeparator = UIManager.getString((Object)"FileChooser.newFolderErrorSeparator", locale);
        this.fileDescriptionText = UIManager.getString((Object)"FileChooser.fileDescriptionText", locale);
        this.directoryDescriptionText = UIManager.getString((Object)"FileChooser.directoryDescriptionText", locale);
        this.saveButtonText = UIManager.getString((Object)"FileChooser.saveButtonText", locale);
        this.openButtonText = UIManager.getString((Object)"FileChooser.openButtonText", locale);
        this.saveDialogTitleText = UIManager.getString((Object)"FileChooser.saveDialogTitleText", locale);
        this.openDialogTitleText = UIManager.getString((Object)"FileChooser.openDialogTitleText", locale);
        this.cancelButtonText = UIManager.getString((Object)"FileChooser.cancelButtonText", locale);
        this.saveButtonMnemonic = UIManager.getInt("FileChooser.saveButtonMnemonic");
        this.openButtonMnemonic = UIManager.getInt("FileChooser.openButtonMnemonic");
        this.cancelButtonMnemonic = UIManager.getInt("FileChooser.cancelButtonMnemonic");
        this.saveButtonToolTipText = UIManager.getString((Object)"FileChooser.saveButtonToolTipText", locale);
        this.openButtonToolTipText = UIManager.getString((Object)"FileChooser.openButtonToolTipText", locale);
        this.cancelButtonToolTipText = UIManager.getString((Object)"FileChooser.cancelButtonToolTipText", locale);
    }

    public void uninstallComponents(JFileChooser jFileChooser) {
        jFileChooser.removeAll();
    }

    protected void uninstallDefaults(JFileChooser jFileChooser) {
        this.uninstallIcons(jFileChooser);
        this.uninstallStrings(jFileChooser);
        SynthContext synthContext = this.getContext(this.filechooser, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    protected void uninstallIcons(JFileChooser jFileChooser) {
    }

    protected void uninstallListeners(JFileChooser jFileChooser) {
        if (this.propertyChangeListener != null) {
            jFileChooser.removePropertyChangeListener(this.propertyChangeListener);
        }
        jFileChooser.removePropertyChangeListener(this.getModel());
        SwingUtilities.replaceUIInputMap(jFileChooser, 1, null);
        SwingUtilities.replaceUIActionMap(jFileChooser, null);
    }

    protected void uninstallStrings(JFileChooser jFileChooser) {
        this.saveButtonText = null;
        this.openButtonText = null;
        this.cancelButtonText = null;
        this.saveButtonToolTipText = null;
        this.openButtonToolTipText = null;
        this.cancelButtonToolTipText = null;
    }

    public BasicDirectoryModel getModel() {
        return this.model;
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, SynthLookAndFeel.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n2) {
        Region region = SynthLookAndFeel.getRegion(jComponent);
        return SynthContext.getContext(class$com$sun$java$swing$plaf$gtk$SynthContext == null ? (class$com$sun$java$swing$plaf$gtk$SynthContext = SynthFileChooserUI.class$("com.sun.java.swing.plaf.gtk.SynthContext")) : class$com$sun$java$swing$plaf$gtk$SynthContext, jComponent, region, this.style, n2);
    }

    static GlobFilter access$300(SynthFileChooserUI synthFileChooserUI) {
        return synthFileChooserUI.globFilter;
    }

    public PropertyChangeListener createPropertyChangeListener(JFileChooser jFileChooser) {
        return new SynthFCPropertyChangeListener(this);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static String access$600(SynthFileChooserUI synthFileChooserUI) {
        return synthFileChooserUI.newFolderErrorText;
    }

    static String access$700(SynthFileChooserUI synthFileChooserUI) {
        return synthFileChooserUI.newFolderErrorSeparator;
    }

    static String access$800(SynthFileChooserUI synthFileChooserUI) {
        return synthFileChooserUI.directoryDescriptionText;
    }

    static String access$900(SynthFileChooserUI synthFileChooserUI) {
        return synthFileChooserUI.fileDescriptionText;
    }

    private String getCommonStartString(File[] fileArray) {
        String string = null;
        String string2 = null;
        int n2 = 0;
        if (fileArray.length == 0) {
            return null;
        }
        while (true) {
            for (int i2 = 0; i2 < fileArray.length; ++i2) {
                String string3 = fileArray[i2].getName();
                if (i2 == 0) {
                    if (string3.length() == n2) {
                        return string;
                    }
                    string2 = string3.substring(0, n2 + 1);
                }
                if (string3.startsWith(string2)) continue;
                return string;
            }
            string = string2;
            ++n2;
        }
    }

    public String getApproveButtonText(JFileChooser jFileChooser) {
        String string = jFileChooser.getApproveButtonText();
        if (string != null) {
            return string;
        }
        if (jFileChooser.getDialogType() == 0) {
            return this.openButtonText;
        }
        if (jFileChooser.getDialogType() == 1) {
            return this.saveButtonText;
        }
        return null;
    }

    public String getApproveButtonToolTipText(JFileChooser jFileChooser) {
        String string = jFileChooser.getApproveButtonToolTipText();
        if (string != null) {
            return string;
        }
        if (jFileChooser.getDialogType() == 0) {
            return this.openButtonToolTipText;
        }
        if (jFileChooser.getDialogType() == 1) {
            return this.saveButtonToolTipText;
        }
        return null;
    }

    public String getDialogTitle(JFileChooser jFileChooser) {
        String string = jFileChooser.getDialogTitle();
        if (string != null) {
            return string;
        }
        if (jFileChooser.getDialogType() == 0) {
            return this.openDialogTitleText;
        }
        if (jFileChooser.getDialogType() == 1) {
            return this.saveDialogTitleText;
        }
        return this.getApproveButtonText(jFileChooser);
    }

    protected JButton getApproveButton(JFileChooser jFileChooser) {
        return this.approveButton;
    }

    protected JButton getCancelButton(JFileChooser jFileChooser) {
        return this.cancelButton;
    }

    public FileFilter getAcceptAllFileFilter(JFileChooser jFileChooser) {
        return this.acceptAllFileFilter;
    }

    public FileView getFileView(JFileChooser jFileChooser) {
        return this.fileView;
    }

    static GlobFilter access$302(SynthFileChooserUI synthFileChooserUI, GlobFilter globFilter) {
        synthFileChooserUI.globFilter = globFilter;
        return synthFileChooserUI.globFilter;
    }

    static String access$502(SynthFileChooserUI synthFileChooserUI, String string) {
        synthFileChooserUI.fileNameCompletionString = string;
        return synthFileChooserUI.fileNameCompletionString;
    }

    static FileFilter access$402(SynthFileChooserUI synthFileChooserUI, FileFilter fileFilter) {
        synthFileChooserUI.actualFileFilter = fileFilter;
        return synthFileChooserUI.actualFileFilter;
    }

    protected class AcceptAllFileFilter
    extends FileFilter {
        private final SynthFileChooserUI this$0;

        public AcceptAllFileFilter(SynthFileChooserUI synthFileChooserUI) {
            this.this$0 = synthFileChooserUI;
        }

        public boolean accept(File file) {
            return true;
        }

        public String getDescription() {
            return UIManager.getString((Object)"FileChooser.acceptAllFileFilterText", this.this$0.getFileChooser().getLocale());
        }
    }

    protected class ApproveSelectionAction
    extends AbstractAction {
        private final SynthFileChooserUI this$0;

        protected ApproveSelectionAction(SynthFileChooserUI synthFileChooserUI) {
            this.this$0 = synthFileChooserUI;
            super("approveSelection");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Serializable serializable;
            if (this.this$0.isDirectorySelected() && (serializable = this.this$0.getDirectory()) != null) {
                try {
                    serializable = ((File)serializable).getCanonicalFile();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.this$0.getFileChooser().setCurrentDirectory((File)serializable);
                return;
            }
            serializable = this.this$0.getFileChooser();
            String string = this.this$0.getFileName();
            FileSystemView fileSystemView = ((JFileChooser)serializable).getFileSystemView();
            File file = ((JFileChooser)serializable).getCurrentDirectory();
            if (string != null) {
                string = string.trim();
            }
            if (string == null || string.equals("")) {
                SynthFileChooserUI.access$100(this.this$0);
                return;
            }
            File file2 = null;
            File[] fileArray = null;
            if (string != null && !string.equals("")) {
                if (File.separatorChar == '/') {
                    if (string.startsWith("~/")) {
                        string = System.getProperty("user.home") + string.substring(1);
                    } else if (string.equals("~")) {
                        string = System.getProperty("user.home");
                    }
                }
                if (((JFileChooser)serializable).isMultiSelectionEnabled() && string.startsWith("\"")) {
                    ArrayList arrayList = new ArrayList();
                    if ((string = string.substring(1)).endsWith("\"")) {
                        string = string.substring(0, string.length() - 1);
                    }
                    Object[] objectArray = null;
                    int n2 = 0;
                    do {
                        String string2;
                        int n3;
                        if ((n3 = string.indexOf("\" \"")) > 0) {
                            string2 = string.substring(0, n3);
                            string = string.substring(n3 + 3);
                        } else {
                            string2 = string;
                            string = "";
                        }
                        Object object = fileSystemView.createFileObject(string2);
                        if (!((File)object).isAbsolute()) {
                            if (objectArray == null) {
                                objectArray = fileSystemView.getFiles(file, false);
                                Arrays.sort(objectArray);
                            }
                            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                                int n4 = (n2 + i2) % objectArray.length;
                                if (!((File)objectArray[n4]).getName().equals(string2)) continue;
                                object = objectArray[n4];
                                n2 = n4 + 1;
                                break;
                            }
                        }
                        arrayList.add(object);
                    } while (string.length() > 0);
                    if (arrayList.size() > 0) {
                        fileArray = (File[])arrayList.toArray(new File[arrayList.size()]);
                    }
                    SynthFileChooserUI.access$100(this.this$0);
                } else {
                    file2 = fileSystemView.createFileObject(string);
                    if (!file2.isAbsolute()) {
                        file2 = fileSystemView.getChild(file, string);
                    }
                    FileFilter fileFilter = ((JFileChooser)serializable).getFileFilter();
                    if (!file2.exists() && SynthFileChooserUI.access$200(string)) {
                        if (SynthFileChooserUI.access$300(this.this$0) == null) {
                            SynthFileChooserUI.access$302(this.this$0, new GlobFilter(this.this$0));
                        }
                        SynthFileChooserUI.access$300(this.this$0).setPattern(string);
                        if (!(fileFilter instanceof GlobFilter)) {
                            SynthFileChooserUI.access$402(this.this$0, fileFilter);
                        }
                        ((JFileChooser)serializable).setFileFilter(null);
                        ((JFileChooser)serializable).setFileFilter(SynthFileChooserUI.access$300(this.this$0));
                        return;
                    }
                    SynthFileChooserUI.access$100(this.this$0);
                    boolean bl2 = file2 != null && file2.isDirectory();
                    boolean bl3 = file2 != null && ((JFileChooser)serializable).isTraversable(file2);
                    boolean bl4 = ((JFileChooser)serializable).isDirectorySelectionEnabled();
                    boolean bl5 = ((JFileChooser)serializable).isFileSelectionEnabled();
                    if (bl2 && bl3 && !bl4) {
                        ((JFileChooser)serializable).setCurrentDirectory(file2);
                        return;
                    }
                    if (!(!bl2 && bl5 || bl2 && bl4 || bl4 && !file2.exists())) {
                        file2 = null;
                    }
                }
            }
            if (fileArray != null || file2 != null) {
                if (fileArray != null) {
                    ((JFileChooser)serializable).setSelectedFiles(fileArray);
                } else if (((JFileChooser)serializable).isMultiSelectionEnabled()) {
                    ((JFileChooser)serializable).setSelectedFiles(new File[]{file2});
                } else {
                    ((JFileChooser)serializable).setSelectedFile(file2);
                }
                ((JFileChooser)serializable).approveSelection();
            } else {
                if (((JFileChooser)serializable).isMultiSelectionEnabled()) {
                    ((JFileChooser)serializable).setSelectedFiles(null);
                } else {
                    ((JFileChooser)serializable).setSelectedFile(null);
                }
                ((JFileChooser)serializable).cancelSelection();
            }
        }
    }

    protected class CancelSelectionAction
    extends AbstractAction {
        private final SynthFileChooserUI this$0;

        protected CancelSelectionAction(SynthFileChooserUI synthFileChooserUI) {
            this.this$0 = synthFileChooserUI;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.this$0.getFileChooser().cancelSelection();
        }
    }

    protected class ChangeToParentDirectoryAction
    extends AbstractAction {
        private final SynthFileChooserUI this$0;

        protected ChangeToParentDirectoryAction(SynthFileChooserUI synthFileChooserUI) {
            this.this$0 = synthFileChooserUI;
            super("Go Up");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (component == null || !(component instanceof JTextComponent)) {
                this.this$0.getFileChooser().changeToParentDirectory();
            }
        }
    }

    private class DelayedSelectionUpdater
    implements Runnable {
        private final SynthFileChooserUI this$0;

        public void run() {
            SynthFileChooserUI.access$000(this.this$0);
        }

        DelayedSelectionUpdater(SynthFileChooserUI synthFileChooserUI) {
            this.this$0 = synthFileChooserUI;
            SwingUtilities.invokeLater(this);
        }
    }

    protected class FileNameCompletionAction
    extends AbstractAction {
        private final SynthFileChooserUI this$0;

        protected FileNameCompletionAction(SynthFileChooserUI synthFileChooserUI) {
            this.this$0 = synthFileChooserUI;
            super("fileNameCompletion");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = this.this$0.getFileChooser();
            String string = this.this$0.getFileName();
            if (string != null) {
                string = string.trim();
            }
            SynthFileChooserUI.access$100(this.this$0);
            if (string == null || string.equals("") || jFileChooser.isMultiSelectionEnabled() && string.startsWith("\"")) {
                return;
            }
            FileFilter fileFilter = jFileChooser.getFileFilter();
            if (SynthFileChooserUI.access$300(this.this$0) == null) {
                SynthFileChooserUI.access$302(this.this$0, new GlobFilter(this.this$0));
            }
            SynthFileChooserUI.access$300(this.this$0).setPattern(string + "*");
            if (!(fileFilter instanceof GlobFilter)) {
                SynthFileChooserUI.access$402(this.this$0, fileFilter);
            }
            jFileChooser.setFileFilter(null);
            jFileChooser.setFileFilter(SynthFileChooserUI.access$300(this.this$0));
            SynthFileChooserUI.access$502(this.this$0, string);
        }
    }

    class GlobFilter
    extends FileFilter {
        Pattern pattern;
        String globPattern;
        private final SynthFileChooserUI this$0;

        GlobFilter(SynthFileChooserUI synthFileChooserUI) {
            this.this$0 = synthFileChooserUI;
        }

        public boolean accept(File file) {
            if (file == null) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            return this.pattern.matcher(file.getName()).matches();
        }

        public String getDescription() {
            return this.globPattern;
        }

        public void setPattern(String string) {
            char[] cArray = string.toCharArray();
            char[] cArray2 = new char[cArray.length * 2];
            boolean bl2 = File.separatorChar == '\\';
            boolean bl3 = false;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            this.globPattern = string;
            if (bl2) {
                int n3 = cArray.length;
                if (string.endsWith("*.*")) {
                    n3 -= 2;
                }
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (cArray[i2] == '*') {
                        cArray2[n2++] = 46;
                    }
                    cArray2[n2++] = cArray[i2];
                }
            } else {
                block12: for (int i3 = 0; i3 < cArray.length; ++i3) {
                    switch (cArray[i3]) {
                        case '*': {
                            if (!bl3) {
                                cArray2[n2++] = 46;
                            }
                            cArray2[n2++] = 42;
                            continue block12;
                        }
                        case '?': {
                            cArray2[n2++] = bl3 ? 63 : 46;
                            continue block12;
                        }
                        case '[': {
                            bl3 = true;
                            cArray2[n2++] = cArray[i3];
                            if (i3 >= cArray.length - 1) continue block12;
                            switch (cArray[i3 + 1]) {
                                case '!': 
                                case '^': {
                                    cArray2[n2++] = 94;
                                    ++i3;
                                    break;
                                }
                                case ']': {
                                    cArray2[n2++] = cArray[++i3];
                                }
                            }
                            continue block12;
                        }
                        case ']': {
                            cArray2[n2++] = cArray[i3];
                            bl3 = false;
                            continue block12;
                        }
                        case '\\': {
                            if (i3 == 0 && cArray.length > 1 && cArray[1] == '~') {
                                cArray2[n2++] = cArray[++i3];
                                continue block12;
                            }
                            cArray2[n2++] = 92;
                            if (i3 < cArray.length - 1 && "*?[]".indexOf(cArray[i3 + 1]) >= 0) {
                                cArray2[n2++] = cArray[++i3];
                                continue block12;
                            }
                            cArray2[n2++] = 92;
                            continue block12;
                        }
                        default: {
                            if (!Character.isLetterOrDigit(cArray[i3])) {
                                cArray2[n2++] = 92;
                            }
                            cArray2[n2++] = cArray[i3];
                        }
                    }
                }
            }
            this.pattern = Pattern.compile(new String(cArray2, 0, n2), 2);
        }
    }

    protected class GoHomeAction
    extends AbstractAction {
        private final SynthFileChooserUI this$0;

        protected GoHomeAction(SynthFileChooserUI synthFileChooserUI) {
            this.this$0 = synthFileChooserUI;
            super("Go Home");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = this.this$0.getFileChooser();
            jFileChooser.setCurrentDirectory(jFileChooser.getFileSystemView().getHomeDirectory());
        }
    }

    protected class NewFolderAction
    extends AbstractAction {
        private final SynthFileChooserUI this$0;

        protected NewFolderAction(SynthFileChooserUI synthFileChooserUI) {
            this.this$0 = synthFileChooserUI;
            super("New Folder");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = this.this$0.getFileChooser();
            File file = jFileChooser.getCurrentDirectory();
            File file2 = null;
            try {
                file2 = jFileChooser.getFileSystemView().createNewFolder(file);
                if (jFileChooser.isMultiSelectionEnabled()) {
                    jFileChooser.setSelectedFiles(new File[]{file2});
                } else {
                    jFileChooser.setSelectedFile(file2);
                }
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(jFileChooser, SynthFileChooserUI.access$600(this.this$0) + SynthFileChooserUI.access$700(this.this$0) + iOException, SynthFileChooserUI.access$600(this.this$0), 0);
                return;
            }
            jFileChooser.rescanCurrentDirectory();
        }
    }

    protected class SynthFCPropertyChangeListener
    implements PropertyChangeListener {
        private final SynthFileChooserUI this$0;

        protected SynthFCPropertyChangeListener(SynthFileChooserUI synthFileChooserUI) {
            this.this$0 = synthFileChooserUI;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("fileSelectionChanged")) {
                this.this$0.doFileSelectionModeChanged(propertyChangeEvent);
            } else if (string.equals("SelectedFileChangedProperty")) {
                this.this$0.doSelectedFileChanged(propertyChangeEvent);
            } else if (string.equals("directoryChanged")) {
                this.this$0.doDirectoryChanged(propertyChangeEvent);
            } else if (string == "MultiSelectionEnabledChangedProperty") {
                this.this$0.doMultiSelectionChanged(propertyChangeEvent);
            } else if (string == "AccessoryChangedProperty") {
                this.this$0.doAccessoryChanged(propertyChangeEvent);
            } else if (string == "ApproveButtonTextChangedProperty" || string == "ApproveButtonToolTipTextChangedProperty" || string == "DialogTypeChangedProperty" || string == "ControlButtonsAreShownChangedProperty") {
                this.this$0.doControlButtonsChanged(propertyChangeEvent);
            } else if (string.equals("componentOrientation")) {
                ComponentOrientation componentOrientation = (ComponentOrientation)propertyChangeEvent.getNewValue();
                JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
                if (componentOrientation != (ComponentOrientation)propertyChangeEvent.getOldValue()) {
                    jFileChooser.applyComponentOrientation(componentOrientation);
                }
            } else if (string.equals("ancestor")) {
                this.this$0.doAncestorChanged(propertyChangeEvent);
            }
        }
    }

    protected class SynthFileView
    extends FileView {
        private final SynthFileChooserUI this$0;

        protected SynthFileView(SynthFileChooserUI synthFileChooserUI) {
            this.this$0 = synthFileChooserUI;
        }

        public Boolean isHidden(File file) {
            String string = file.getName();
            if (string != null && string.charAt(0) == '.') {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public String getDescription(File file) {
            return file.getName();
        }

        public String getName(File file) {
            String string = null;
            if (file != null) {
                string = this.this$0.getFileChooser().getFileSystemView().getSystemDisplayName(file);
            }
            return string;
        }

        public String getTypeDescription(File file) {
            String string = this.this$0.getFileChooser().getFileSystemView().getSystemTypeDescription(file);
            if (string == null) {
                string = file.isDirectory() ? SynthFileChooserUI.access$800(this.this$0) : SynthFileChooserUI.access$900(this.this$0);
            }
            return string;
        }

        public Icon getIcon(File file) {
            return null;
        }
    }
}

