/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.LazyActionMap;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthGraphics;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BoundedRangeModel;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.SliderUI;

class SynthSliderUI
extends SliderUI
implements SynthUI {
    public static final int POSITIVE_SCROLL = 1;
    public static final int NEGATIVE_SCROLL = -1;
    public static final int MIN_SCROLL = -2;
    public static final int MAX_SCROLL = 2;
    protected Insets insetCache = null;
    protected boolean leftToRightCache = true;
    protected Dimension contentDim = null;
    protected Rectangle labelRect = null;
    protected Rectangle tickRect = null;
    protected Rectangle trackRect = null;
    protected Rectangle thumbRect = null;
    protected Rectangle valueRect = null;
    protected boolean paintValue;
    protected int trackBuffer = 0;
    private static final Dimension PREFERRED_HORIZONTAL_SIZE = new Dimension(200, 21);
    private static final Dimension PREFERRED_VERTICAL_SIZE = new Dimension(21, 200);
    private static final Dimension MINIMUM_HORIZONTAL_SIZE = new Dimension(36, 21);
    private static final Dimension MINIMUM_VERTICAL_SIZE = new Dimension(21, 36);
    private transient boolean isDragging;
    protected TrackListener trackListener;
    protected ChangeListener changeListener;
    protected ComponentListener componentListener;
    protected FocusListener focusListener;
    protected ScrollListener scrollListener;
    protected PropertyChangeListener propertyChangeListener;
    private Color shadowColor;
    private Color highlightColor;
    private static int trackHeight;
    private static int trackBorder;
    private static int thumbWidth;
    private static int thumbHeight;
    private SynthStyle style;
    private SynthStyle sliderTrackStyle;
    private SynthStyle sliderThumbStyle;
    private transient boolean thumbActive;
    protected Timer scrollTimer;
    protected JSlider slider;
    private static Rectangle unionRect;
    static Class class$com$sun$java$swing$plaf$gtk$SynthSliderUI;
    static Class class$com$sun$java$swing$plaf$gtk$SynthContext;

    static int access$200() {
        return trackBorder;
    }

    protected int getHeightOfHighValueLabel() {
        Component component = this.getHighestValueLabel();
        int n2 = 0;
        if (component != null) {
            n2 = component.getPreferredSize().height;
        }
        return n2;
    }

    protected int getHeightOfLowValueLabel() {
        Component component = this.getLowestValueLabel();
        int n2 = 0;
        if (component != null) {
            n2 = component.getPreferredSize().height;
        }
        return n2;
    }

    protected int getHeightOfTallestLabel() {
        Dictionary dictionary = this.slider.getLabelTable();
        int n2 = 0;
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                Component component = (Component)dictionary.get(enumeration.nextElement());
                n2 = Math.max(component.getPreferredSize().height, n2);
            }
        }
        return n2;
    }

    protected int getTickLength() {
        return 8;
    }

    protected int getWidthOfHighValueLabel() {
        Component component = this.getHighestValueLabel();
        int n2 = 0;
        if (component != null) {
            n2 = component.getPreferredSize().width;
        }
        return n2;
    }

    protected int getWidthOfLowValueLabel() {
        Component component = this.getLowestValueLabel();
        int n2 = 0;
        if (component != null) {
            n2 = component.getPreferredSize().width;
        }
        return n2;
    }

    protected int getWidthOfWidestLabel() {
        Dictionary dictionary = this.slider.getLabelTable();
        int n2 = 0;
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                Component component = (Component)dictionary.get(enumeration.nextElement());
                n2 = Math.max(component.getPreferredSize().width, n2);
            }
        }
        return n2;
    }

    static {
        unionRect = new Rectangle();
    }

    SynthSliderUI() {
    }

    protected void calculateGeometry() {
        this.layout();
        this.calculateThumbLocation();
    }

    protected void calculateThumbLocation() {
        int n2;
        if (this.slider.getSnapToTicks()) {
            int n3 = n2 = this.slider.getValue();
            int n4 = this.slider.getMajorTickSpacing();
            int n5 = this.slider.getMinorTickSpacing();
            int n6 = 0;
            if (n5 > 0) {
                n6 = n5;
            } else if (n4 > 0) {
                n6 = n4;
            }
            if (n6 != 0) {
                if ((n2 - this.slider.getMinimum()) % n6 != 0) {
                    float f2 = (float)(n2 - this.slider.getMinimum()) / (float)n6;
                    int n7 = Math.round(f2);
                    n3 = this.slider.getMinimum() + n7 * n6;
                }
                if (n3 != n2) {
                    this.slider.setValue(n3);
                }
            }
        }
        if (this.slider.getOrientation() == 0) {
            n2 = this.xPositionForValue(this.slider.getValue());
            this.thumbRect.x = n2 - this.thumbRect.width / 2;
            this.thumbRect.y = this.trackRect.y + trackBorder;
        } else {
            n2 = this.yPositionForValue(this.slider.getValue());
            this.thumbRect.x = this.trackRect.x + trackBorder;
            this.thumbRect.y = n2 - this.thumbRect.height / 2;
        }
    }

    protected void calculateThumbSize() {
        Dimension dimension = this.getThumbSize();
        this.thumbRect.setSize(dimension.width, dimension.height);
    }

    protected void calculateTickRect() {
        if (this.slider.getOrientation() == 0) {
            this.tickRect.x = this.trackRect.x;
            this.tickRect.y = this.trackRect.y + this.trackRect.height + 2 + this.getTickLength();
            this.tickRect.width = this.trackRect.width;
            this.tickRect.height = this.getTickLength();
            if (!this.slider.getPaintTicks()) {
                --this.tickRect.y;
                this.tickRect.height = 0;
            }
        } else {
            if (SynthLookAndFeel.isLeftToRight(this.slider)) {
                this.tickRect.x = this.trackRect.x + this.trackRect.width;
                this.tickRect.width = this.getTickLength();
            } else {
                this.tickRect.width = this.getTickLength();
                this.tickRect.x = this.trackRect.x - this.tickRect.width;
            }
            this.tickRect.y = this.trackRect.y;
            this.tickRect.height = this.trackRect.height;
            if (!this.slider.getPaintTicks()) {
                --this.tickRect.x;
                this.tickRect.width = 0;
            }
        }
    }

    protected void installDefaults() {
        this.fetchStyle(this.slider);
        SynthContext synthContext = this.getContext((JComponent)this.slider, 1);
        this.highlightColor = UIManager.getColor("Slider.highlight");
        this.shadowColor = UIManager.getColor("Slider.shadow");
        synthContext.dispose();
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(0);
        SwingUtilities.replaceUIInputMap(this.slider, 0, inputMap);
        LazyActionMap.installLazyActionMap(this.slider, class$com$sun$java$swing$plaf$gtk$SynthSliderUI == null ? (class$com$sun$java$swing$plaf$gtk$SynthSliderUI = SynthSliderUI.class$("com.sun.java.swing.plaf.gtk.SynthSliderUI")) : class$com$sun$java$swing$plaf$gtk$SynthSliderUI, "Slider.actionMap");
    }

    protected void installListeners() {
        this.trackListener = this.createTrackListener();
        if (this.trackListener != null) {
            this.slider.addMouseListener(this.trackListener);
            this.slider.addMouseMotionListener(this.trackListener);
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.slider.addFocusListener(this.focusListener);
        }
        if ((this.componentListener = this.createComponentListener()) != null) {
            this.slider.addComponentListener(this.componentListener);
        }
        if ((this.propertyChangeListener = this.createPropertyChangeListener()) != null) {
            this.slider.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.changeListener = this.createChangeListener()) != null) {
            this.slider.getModel().addChangeListener(this.changeListener);
        }
        if ((this.scrollListener = this.createScrollListener()) != null) {
            this.scrollTimer = new Timer(100, this.scrollListener);
            this.scrollTimer.setInitialDelay(300);
        }
    }

    protected void layout() {
        SynthContext synthContext = this.getContext(this.slider);
        SynthGraphics synthGraphics = this.style.getSynthGraphics(synthContext);
        Dimension dimension = this.getThumbSize();
        this.thumbRect.setSize(dimension.width, dimension.height);
        Insets insets = new Insets(0, 0, 0, 0);
        this.style.getInsets(this.getContext((JComponent)this.slider, Region.SLIDER_TRACK), insets);
        if (this.slider.getOrientation() == 0) {
            this.valueRect.height = 0;
            if (this.paintValue) {
                this.valueRect.height = synthGraphics.getMaximumCharHeight(this.slider);
            }
            this.trackRect.height = trackHeight;
            this.tickRect.height = 0;
            if (this.slider.getPaintTicks()) {
                this.tickRect.height = this.getTickLength();
            }
            this.labelRect.height = 0;
            if (this.slider.getPaintLabels()) {
                this.labelRect.height = this.getHeightOfTallestLabel();
            }
            this.contentDim.height = this.valueRect.height + this.trackRect.height + insets.top + insets.bottom + this.tickRect.height + this.labelRect.height + 4;
            this.contentDim.width = this.slider.getWidth() - this.insetCache.left - this.insetCache.right;
            int n2 = this.slider.getHeight() / 2 - this.contentDim.height / 2;
            this.tickRect.x = this.labelRect.x = this.insetCache.left;
            this.trackRect.x = this.labelRect.x;
            this.valueRect.x = this.labelRect.x;
            this.tickRect.width = this.labelRect.width = this.contentDim.width;
            this.trackRect.width = this.labelRect.width;
            this.valueRect.width = this.labelRect.width;
            this.valueRect.y = n2;
            this.trackRect.y = (n2 += this.valueRect.height + 2) + insets.top;
            this.tickRect.y = n2 += this.trackRect.height + insets.top + insets.bottom;
            this.labelRect.y = n2 += this.tickRect.height + 2;
            n2 += this.labelRect.height;
        } else {
            this.trackRect.width = trackHeight;
            this.tickRect.width = 0;
            if (this.slider.getPaintTicks()) {
                this.tickRect.width = this.getTickLength();
            }
            this.labelRect.width = 0;
            if (this.slider.getPaintLabels()) {
                this.labelRect.width = this.getWidthOfWidestLabel();
            }
            this.valueRect.y = this.insetCache.top;
            this.valueRect.height = 0;
            if (this.paintValue) {
                this.valueRect.height = synthGraphics.getMaximumCharHeight(this.slider);
            }
            this.contentDim.width = this.trackRect.width + insets.left + insets.right + this.tickRect.width + this.labelRect.width + 2 + this.insetCache.left + this.insetCache.right;
            this.contentDim.height = this.slider.getHeight() - this.insetCache.top - this.insetCache.bottom;
            int n3 = this.slider.getWidth() / 2 - this.contentDim.width / 2;
            this.valueRect.width = Math.max(synthGraphics.computeStringWidth(synthContext, this.slider.getFont(), this.slider.getToolkit().getFontMetrics(this.slider.getFont()), "" + this.slider.getMaximum()), synthGraphics.computeStringWidth(synthContext, this.slider.getFont(), this.slider.getToolkit().getFontMetrics(this.slider.getFont()), "" + this.slider.getMinimum()));
            if (this.valueRect.width > this.trackRect.width + insets.left + insets.right) {
                int n4 = (this.valueRect.width - (this.trackRect.width + insets.left + insets.right)) / 2;
                this.contentDim.width += n4;
                n3 += n4;
            }
            this.tickRect.y = this.labelRect.y = this.valueRect.y + this.valueRect.height;
            this.trackRect.y = this.labelRect.y;
            this.tickRect.height = this.labelRect.height = this.contentDim.height - this.valueRect.height;
            this.trackRect.height = this.labelRect.height;
            this.trackRect.x = n3 + insets.left;
            this.tickRect.x = n3 += this.trackRect.width + insets.right + insets.left;
            this.labelRect.x = n3 += this.tickRect.width + 2;
            n3 += this.labelRect.width;
        }
    }

    protected void recalculateIfInsetsChanged() {
        Insets insets = this.style.getInsets(this.getContext(this.slider), null);
        if (!insets.equals(this.insetCache)) {
            this.insetCache = insets;
            this.calculateGeometry();
        }
    }

    protected void recalculateIfOrientationChanged() {
        boolean bl2 = SynthLookAndFeel.isLeftToRight(this.slider);
        if (bl2 != this.leftToRightCache) {
            this.leftToRightCache = bl2;
            this.calculateGeometry();
        }
    }

    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext((JComponent)this.slider, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        synthContext = this.getContext(this.slider, Region.SLIDER_TRACK, 1);
        this.sliderTrackStyle.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.sliderTrackStyle = null;
        synthContext = this.getContext(this.slider, Region.SLIDER_THUMB, 1);
        this.sliderThumbStyle.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.sliderThumbStyle = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.slider, null);
        SwingUtilities.replaceUIInputMap(this.slider, 0, null);
    }

    protected void uninstallListeners() {
        if (this.trackListener != null) {
            this.slider.removeMouseListener(this.trackListener);
            this.slider.removeMouseMotionListener(this.trackListener);
        }
        if (this.focusListener != null) {
            this.slider.removeFocusListener(this.focusListener);
        }
        if (this.componentListener != null) {
            this.slider.removeComponentListener(this.componentListener);
        }
        if (this.propertyChangeListener != null) {
            this.slider.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.changeListener != null) {
            this.slider.getModel().removeChangeListener(this.changeListener);
        }
        this.scrollTimer = null;
    }

    protected boolean drawInverted() {
        if (this.slider.getOrientation() == 0) {
            if (SynthLookAndFeel.isLeftToRight(this.slider)) {
                return this.slider.getInverted();
            }
            return !this.slider.getInverted();
        }
        return this.slider.getInverted();
    }

    public int valueForXPosition(int n2) {
        int n3;
        int n4 = this.slider.getMinimum();
        int n5 = this.slider.getMaximum();
        int n6 = this.trackRect.x + this.thumbRect.width / 2 + trackBorder;
        int n7 = this.trackRect.x + this.trackRect.width - this.thumbRect.width / 2 - trackBorder;
        int n8 = n7 - n6;
        if (n2 <= n6) {
            n3 = this.drawInverted() ? n5 : n4;
        } else if (n2 >= n7) {
            n3 = this.drawInverted() ? n4 : n5;
        } else {
            int n9 = n2 - n6;
            double d2 = (double)n5 - (double)n4;
            double d3 = d2 / (double)n8;
            int n10 = (int)Math.round((double)n9 * d3);
            n3 = this.drawInverted() ? n5 - n10 : n4 + n10;
        }
        return n3;
    }

    public int valueForYPosition(int n2) {
        int n3;
        int n4 = this.slider.getMinimum();
        int n5 = this.slider.getMaximum();
        int n6 = this.trackRect.y + this.thumbRect.height / 2 + trackBorder;
        int n7 = this.trackRect.y + this.trackRect.height - this.thumbRect.height / 2 - trackBorder;
        int n8 = n7 - n6;
        if (n2 <= n6) {
            n3 = this.drawInverted() ? n4 : n5;
        } else if (n2 >= n7) {
            n3 = this.drawInverted() ? n5 : n4;
        } else {
            int n9 = n2 - n6;
            double d2 = (double)n5 - (double)n4;
            double d3 = d2 / (double)n8;
            int n10 = (int)Math.round((double)n9 * d3);
            n3 = this.drawInverted() ? n4 + n10 : n5 - n10;
        }
        return n3;
    }

    protected int xPositionForValue(int n2) {
        int n3;
        int n4 = this.slider.getMinimum();
        int n5 = this.slider.getMaximum();
        int n6 = this.trackRect.x + this.thumbRect.width / 2 + trackBorder;
        int n7 = this.trackRect.x + this.trackRect.width - this.thumbRect.width / 2 - trackBorder;
        int n8 = n7 - n6;
        double d2 = (double)n5 - (double)n4;
        double d3 = (double)n8 / d2;
        if (!this.drawInverted()) {
            n3 = n6;
            n3 = (int)((long)n3 + Math.round(d3 * ((double)n2 - (double)n4)));
        } else {
            n3 = n7;
            n3 = (int)((long)n3 - Math.round(d3 * ((double)n2 - (double)n4)));
        }
        n3 = Math.max(n6, n3);
        n3 = Math.min(n7, n3);
        return n3;
    }

    protected int yPositionForValue(int n2) {
        int n3;
        int n4 = this.slider.getMinimum();
        int n5 = this.slider.getMaximum();
        int n6 = this.trackRect.y + this.thumbRect.height / 2 + trackBorder;
        int n7 = this.trackRect.y + this.trackRect.height - this.thumbRect.height / 2 - trackBorder;
        int n8 = n7 - n6;
        double d2 = (double)n5 - (double)n4;
        double d3 = (double)n8 / d2;
        if (!this.drawInverted()) {
            n3 = n6;
            n3 = (int)((long)n3 + Math.round(d3 * ((double)n5 - (double)n2)));
        } else {
            n3 = n6;
            n3 = (int)((long)n3 + Math.round(d3 * ((double)n2 - (double)n4)));
        }
        n3 = Math.max(n6, n3);
        n3 = Math.min(n7, n3);
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollByBlock(int n2) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int n3 = this.slider.getValue();
            int n4 = (this.slider.getMaximum() - this.slider.getMinimum()) / 10;
            if (n4 <= 0 && this.slider.getMaximum() > this.slider.getMinimum()) {
                n4 = 1;
            }
            int n5 = n4 * (n2 > 0 ? 1 : -1);
            this.slider.setValue(n3 + n5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollByUnit(int n2) {
        JSlider jSlider = this.slider;
        synchronized (jSlider) {
            int n3 = this.slider.getValue();
            int n4 = 1 * (n2 > 0 ? 1 : -1);
            this.slider.setValue(n3 + n4);
        }
    }

    protected void scrollDueToClickInTrack(int n2) {
        this.scrollByBlock(n2);
    }

    public void setThumbLocation(int n2, int n3) {
        unionRect.setBounds(this.thumbRect);
        this.thumbRect.setLocation(n2, n3);
        SwingUtilities.computeUnion(this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height, unionRect);
        this.slider.repaint(SynthSliderUI.unionRect.x, SynthSliderUI.unionRect.y, SynthSliderUI.unionRect.width, SynthSliderUI.unionRect.height);
        this.slider.repaint(this.valueRect.x, this.valueRect.y, this.valueRect.width, this.valueRect.height);
        this.setThumbActive(false);
    }

    private void updateThumbState(int n2, int n3) {
        this.setThumbActive(this.thumbRect.contains(n2, n3));
    }

    private void setThumbActive(boolean bl2) {
        if (this.thumbActive != bl2) {
            this.thumbActive = bl2;
            this.slider.repaint(this.thumbRect);
        }
    }

    static boolean access$100(SynthSliderUI synthSliderUI) {
        return synthSliderUI.isDragging;
    }

    static void access$400(SynthSliderUI synthSliderUI, int n2, int n3) {
        synthSliderUI.updateThumbState(n2, n3);
    }

    static void access$300(SynthSliderUI synthSliderUI, boolean bl2) {
        synthSliderUI.setThumbActive(bl2);
    }

    static boolean access$102(SynthSliderUI synthSliderUI, boolean bl2) {
        synthSliderUI.isDragging = bl2;
        return synthSliderUI.isDragging;
    }

    protected ScrollListener createScrollListener() {
        return new ScrollListener(this);
    }

    protected TrackListener createTrackListener() {
        return new TrackListener(this);
    }

    protected Color getHighlightColor() {
        return this.highlightColor;
    }

    protected Color getShadowColor() {
        return this.shadowColor;
    }

    protected Component getHighestValueLabel() {
        Enumeration enumeration;
        Dictionary dictionary = this.slider.getLabelTable();
        Component component = null;
        if (dictionary != null && (enumeration = dictionary.keys()).hasMoreElements()) {
            int n2 = (Integer)enumeration.nextElement();
            while (enumeration.hasMoreElements()) {
                int n3 = (Integer)enumeration.nextElement();
                n2 = Math.max(n3, n2);
            }
            component = (Component)dictionary.get(new Integer(n2));
        }
        return component;
    }

    protected Component getLowestValueLabel() {
        Enumeration enumeration;
        Dictionary dictionary = this.slider.getLabelTable();
        Component component = null;
        if (dictionary != null && (enumeration = dictionary.keys()).hasMoreElements()) {
            int n2 = (Integer)enumeration.nextElement();
            while (enumeration.hasMoreElements()) {
                int n3 = (Integer)enumeration.nextElement();
                n2 = Math.min(n3, n2);
            }
            component = (Component)dictionary.get(new Integer(n2));
        }
        return component;
    }

    protected Dimension getThumbSize() {
        Dimension dimension = new Dimension();
        if (this.slider.getOrientation() == 1) {
            dimension.width = thumbHeight;
            dimension.height = thumbWidth;
        } else {
            dimension.width = thumbWidth;
            dimension.height = thumbHeight;
        }
        return dimension;
    }

    public void paintLabels(Graphics graphics) {
        Rectangle rectangle = this.labelRect;
        Dictionary dictionary = this.slider.getLabelTable();
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            int n2 = this.slider.getMinimum();
            int n3 = this.slider.getMaximum();
            while (enumeration.hasMoreElements()) {
                Integer n4 = (Integer)enumeration.nextElement();
                int n5 = n4;
                if (n5 < n2 || n5 > n3) continue;
                Component component = (Component)dictionary.get(n4);
                if (this.slider.getOrientation() == 0) {
                    graphics.translate(0, rectangle.y);
                    this.paintHorizontalLabel(graphics, n5, component);
                    graphics.translate(0, -rectangle.y);
                    continue;
                }
                int n6 = 0;
                if (!SynthLookAndFeel.isLeftToRight(this.slider)) {
                    n6 = rectangle.width - component.getPreferredSize().width;
                }
                graphics.translate(rectangle.x + n6, 0);
                this.paintVerticalLabel(graphics, n5, component);
                graphics.translate(-rectangle.x - n6, 0);
            }
        }
    }

    public void paintTicks(Graphics graphics) {
        Rectangle rectangle = this.tickRect;
        int n2 = rectangle.width;
        int n3 = rectangle.height;
        graphics.setColor(this.slider.getBackground());
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setColor(Color.black);
        int n4 = this.slider.getMajorTickSpacing();
        int n5 = this.slider.getMinorTickSpacing();
        if (this.slider.getOrientation() == 0) {
            int n6;
            graphics.translate(0, rectangle.y);
            int n7 = 0;
            if (this.slider.getMinorTickSpacing() > 0) {
                for (n6 = this.slider.getMinimum(); n6 <= this.slider.getMaximum(); n6 += this.slider.getMinorTickSpacing()) {
                    n7 = this.xPositionForValue(n6);
                    this.paintMinorTickForHorizSlider(graphics, rectangle, n7);
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                for (n6 = this.slider.getMinimum(); n6 <= this.slider.getMaximum(); n6 += this.slider.getMajorTickSpacing()) {
                    n7 = this.xPositionForValue(n6);
                    this.paintMajorTickForHorizSlider(graphics, rectangle, n7);
                }
            }
            graphics.translate(0, -rectangle.y);
        } else {
            graphics.translate(rectangle.x, 0);
            int n8 = this.slider.getMinimum();
            int n9 = 0;
            if (this.slider.getMinorTickSpacing() > 0) {
                int n10 = 0;
                if (!SynthLookAndFeel.isLeftToRight(this.slider)) {
                    n10 = rectangle.width - rectangle.width / 2;
                    graphics.translate(n10, 0);
                }
                while (n8 <= this.slider.getMaximum()) {
                    n9 = this.yPositionForValue(n8);
                    this.paintMinorTickForVertSlider(graphics, rectangle, n9);
                    n8 += this.slider.getMinorTickSpacing();
                }
                if (!SynthLookAndFeel.isLeftToRight(this.slider)) {
                    graphics.translate(-n10, 0);
                }
            }
            if (this.slider.getMajorTickSpacing() > 0) {
                n8 = this.slider.getMinimum();
                if (!SynthLookAndFeel.isLeftToRight(this.slider)) {
                    graphics.translate(2, 0);
                }
                while (n8 <= this.slider.getMaximum()) {
                    n9 = this.yPositionForValue(n8);
                    this.paintMajorTickForVertSlider(graphics, rectangle, n9);
                    n8 += this.slider.getMajorTickSpacing();
                }
                if (!SynthLookAndFeel.isLeftToRight(this.slider)) {
                    graphics.translate(-2, 0);
                }
            }
            graphics.translate(-rectangle.x, 0);
        }
    }

    protected ComponentListener createComponentListener() {
        return new ComponentHandler(this);
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler(this);
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler(this);
    }

    protected String getPropertyPrefix() {
        return "Slider.";
    }

    public static void loadActionMap(ActionMap actionMap) {
        actionMap.put("positiveUnitIncrement", new SharedActionScroller(1, false));
        actionMap.put("positiveBlockIncrement", new SharedActionScroller(1, true));
        actionMap.put("negativeUnitIncrement", new SharedActionScroller(-1, false));
        actionMap.put("negativeBlockIncrement", new SharedActionScroller(-1, true));
        actionMap.put("minScroll", new SharedActionScroller(-2, true));
        actionMap.put("maxScroll", new SharedActionScroller(2, true));
    }

    InputMap getInputMap(int n2) {
        if (n2 == 0) {
            InputMap inputMap;
            SynthContext synthContext = this.getContext((JComponent)this.slider, 1);
            InputMap inputMap2 = (InputMap)this.style.get(synthContext, "Slider.focusInputMap");
            if (this.slider.getComponentOrientation().isLeftToRight() || (inputMap = (InputMap)this.style.get(synthContext, "Slider.focusInputMap.RightToLeft")) == null) {
                synthContext.dispose();
                return inputMap2;
            }
            inputMap.setParent(inputMap2);
            synthContext.dispose();
            return inputMap;
        }
        return null;
    }

    public int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.slider = (JSlider)jComponent;
        this.slider.setEnabled(this.slider.isEnabled());
        this.slider.setOpaque(true);
        this.isDragging = false;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
        this.insetCache = this.slider.getInsets();
        this.leftToRightCache = SynthLookAndFeel.isLeftToRight(this.slider);
        this.contentDim = new Dimension();
        this.labelRect = new Rectangle();
        this.tickRect = new Rectangle();
        this.trackRect = new Rectangle();
        this.thumbRect = new Rectangle();
        this.valueRect = new Rectangle();
        this.calculateGeometry();
    }

    public void uninstallUI(JComponent jComponent) {
    }

    private void fetchStyle(JSlider jSlider) {
        SynthContext synthContext = this.getContext((JComponent)jSlider, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            thumbWidth = this.style.getInt(synthContext, this.getPropertyPrefix() + "thumbWidth", 30);
            thumbHeight = this.style.getInt(synthContext, this.getPropertyPrefix() + "thumbHeight", 14);
            trackBorder = this.style.getInt(synthContext, this.getPropertyPrefix() + "trackBorder", 1);
            trackHeight = thumbHeight + trackBorder * 2;
            this.paintValue = this.style.getBoolean(synthContext, this.getPropertyPrefix() + "paintValue", true);
        }
        synthContext.dispose();
        synthContext = this.getContext(jSlider, Region.SLIDER_TRACK, 1);
        this.sliderTrackStyle = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
        synthContext = this.getContext(jSlider, Region.SLIDER_THUMB, 1);
        this.sliderThumbStyle = SynthLookAndFeel.updateStyle(synthContext, this);
        synthContext.dispose();
    }

    protected ChangeListener createChangeListener() {
        return new ChangeHandler(this);
    }

    public Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    private int getComponentState(JComponent jComponent, Region region) {
        if (region == Region.SLIDER_THUMB && this.thumbActive && jComponent.isEnabled()) {
            return 2;
        }
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    public SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(class$com$sun$java$swing$plaf$gtk$SynthContext == null ? (class$com$sun$java$swing$plaf$gtk$SynthContext = SynthSliderUI.class$("com.sun.java.swing.plaf.gtk.SynthContext")) : class$com$sun$java$swing$plaf$gtk$SynthContext, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    protected TrackListener createTrackListener(JSlider jSlider) {
        return new TrackListener(this);
    }

    protected void paintHorizontalLabel(Graphics graphics, int n2, Component component) {
        int n3 = this.xPositionForValue(n2);
        int n4 = n3 - component.getPreferredSize().width / 2;
        graphics.translate(n4, 0);
        component.paint(graphics);
        graphics.translate(-n4, 0);
    }

    protected void paintVerticalLabel(Graphics graphics, int n2, Component component) {
        int n3 = this.yPositionForValue(n2);
        int n4 = n3 - component.getPreferredSize().height / 2;
        graphics.translate(0, n4);
        component.paint(graphics);
        graphics.translate(0, -n4);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        if (this.slider.getOrientation() == 1) {
            dimension.height = Short.MAX_VALUE;
        } else {
            dimension.width = Short.MAX_VALUE;
        }
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        this.recalculateIfInsetsChanged();
        Dimension dimension = new Dimension(this.contentDim);
        if (this.slider.getOrientation() == 1) {
            dimension.height = this.thumbRect.height + this.insetCache.top + this.insetCache.bottom;
        } else {
            dimension.width = this.thumbRect.width + this.insetCache.left + this.insetCache.right;
        }
        return dimension;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        this.recalculateIfInsetsChanged();
        Dimension dimension = new Dimension(this.contentDim);
        if (this.slider.getOrientation() == 1) {
            dimension.height = 200;
        } else {
            dimension.width = 200;
        }
        return dimension;
    }

    public void paint(SynthContext synthContext, Graphics graphics) {
        this.recalculateIfInsetsChanged();
        this.recalculateIfOrientationChanged();
        Rectangle rectangle = graphics.getClipBounds();
        this.valueRect.x = this.thumbRect.x + this.thumbRect.width / 2 - graphics.getFontMetrics().stringWidth("" + this.slider.getValue()) / 2;
        synthContext.getStyle().getSynthGraphics(synthContext).paintText(synthContext, graphics, "" + this.slider.getValue(), this.valueRect.x, this.valueRect.y, -1);
        SynthContext synthContext2 = this.getContext((JComponent)this.slider, Region.SLIDER_TRACK);
        this.paintTrack(synthContext2, graphics, this.trackRect);
        synthContext2.dispose();
        synthContext2 = this.getContext((JComponent)this.slider, Region.SLIDER_THUMB);
        this.paintThumb(synthContext2, graphics, this.thumbRect);
        synthContext2.dispose();
        if (this.slider.getPaintTicks() && rectangle.intersects(this.tickRect)) {
            this.paintTicks(graphics);
        }
        if (this.slider.getPaintLabels() && rectangle.intersects(this.labelRect)) {
            this.paintLabels(graphics);
        }
    }

    protected void paintMajorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n2) {
        graphics.drawLine(n2, 0, n2, rectangle.height - 2);
    }

    protected void paintMajorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n2) {
        graphics.drawLine(0, n2, rectangle.width - 2, n2);
    }

    protected void paintMinorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n2) {
        graphics.drawLine(n2, 0, n2, rectangle.height / 2 - 1);
    }

    protected void paintMinorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n2) {
        graphics.drawLine(0, n2, rectangle.width / 2 - 1, n2);
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    static void access$000(SynthSliderUI synthSliderUI, JSlider jSlider) {
        synthSliderUI.fetchStyle(jSlider);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthSliderUI();
    }

    public SynthContext getContext(JComponent jComponent, Region region) {
        return this.getContext(jComponent, region, this.getComponentState(jComponent, region));
    }

    private SynthContext getContext(JComponent jComponent, Region region, int n2) {
        Class clazz;
        SynthStyle synthStyle = null;
        Class clazz2 = clazz = class$com$sun$java$swing$plaf$gtk$SynthContext == null ? (class$com$sun$java$swing$plaf$gtk$SynthContext = SynthSliderUI.class$("com.sun.java.swing.plaf.gtk.SynthContext")) : class$com$sun$java$swing$plaf$gtk$SynthContext;
        if (region == Region.SLIDER_TRACK) {
            synthStyle = this.sliderTrackStyle;
        } else if (region == Region.SLIDER_THUMB) {
            synthStyle = this.sliderThumbStyle;
        }
        return SynthContext.getContext(clazz, jComponent, region, synthStyle, n2);
    }

    public void paintThumb(SynthContext synthContext, Graphics graphics, Rectangle rectangle) {
        SynthLookAndFeel.updateSubregion(synthContext, graphics, rectangle);
    }

    public void paintTrack(SynthContext synthContext, Graphics graphics, Rectangle rectangle) {
        SynthLookAndFeel.updateSubregion(synthContext, graphics, rectangle);
    }

    class ChangeHandler
    implements ChangeListener {
        private final SynthSliderUI this$0;

        ChangeHandler(SynthSliderUI synthSliderUI) {
            this.this$0 = synthSliderUI;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            if (!SynthSliderUI.access$100(this.this$0)) {
                this.this$0.calculateThumbLocation();
                this.this$0.slider.repaint();
            }
        }
    }

    class ComponentHandler
    extends ComponentAdapter {
        private final SynthSliderUI this$0;

        ComponentHandler(SynthSliderUI synthSliderUI) {
            this.this$0 = synthSliderUI;
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.this$0.calculateGeometry();
            this.this$0.slider.repaint();
        }
    }

    class FocusHandler
    implements FocusListener {
        private final SynthSliderUI this$0;

        FocusHandler(SynthSliderUI synthSliderUI) {
            this.this$0 = synthSliderUI;
        }

        public void focusGained(FocusEvent focusEvent) {
            this.this$0.slider.repaint();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.this$0.slider.repaint();
        }
    }

    class PropertyChangeHandler
    implements PropertyChangeListener {
        private final SynthSliderUI this$0;

        PropertyChangeHandler(SynthSliderUI synthSliderUI) {
            this.this$0 = synthSliderUI;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("orientation") || string.equals("inverted") || string.equals("labelTable") || string.equals("majorTickSpacing") || string.equals("minorTickSpacing") || string.equals("paintTicks") || string.equals("paintTrack") || string.equals("paintLabels")) {
                this.this$0.calculateGeometry();
                this.this$0.slider.repaint();
            } else if (string.equals("componentOrientation")) {
                this.this$0.calculateGeometry();
                this.this$0.slider.repaint();
                InputMap inputMap = this.this$0.getInputMap(0);
                SwingUtilities.replaceUIInputMap(this.this$0.slider, 0, inputMap);
            } else if (string.equals("model")) {
                ((BoundedRangeModel)propertyChangeEvent.getOldValue()).removeChangeListener(this.this$0.changeListener);
                ((BoundedRangeModel)propertyChangeEvent.getNewValue()).addChangeListener(this.this$0.changeListener);
                this.this$0.calculateThumbLocation();
                this.this$0.slider.repaint();
            }
            if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
                SynthSliderUI.access$000(this.this$0, (JSlider)propertyChangeEvent.getSource());
            }
        }
    }

    class ScrollListener
    implements ActionListener {
        int direction;
        boolean useBlockIncrement;
        private final SynthSliderUI this$0;

        public void setDirection(int n2) {
            this.direction = n2;
        }

        public void setScrollByBlock(boolean bl2) {
            this.useBlockIncrement = bl2;
        }

        public ScrollListener(SynthSliderUI synthSliderUI) {
            this.this$0 = synthSliderUI;
            this.direction = 1;
            this.direction = 1;
            this.useBlockIncrement = true;
        }

        public ScrollListener(SynthSliderUI synthSliderUI, int n2, boolean bl2) {
            this.this$0 = synthSliderUI;
            this.direction = 1;
            this.direction = n2;
            this.useBlockIncrement = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.useBlockIncrement) {
                this.this$0.scrollByBlock(this.direction);
            } else {
                this.this$0.scrollByUnit(this.direction);
            }
            if (!this.this$0.trackListener.shouldScroll(this.direction)) {
                ((Timer)actionEvent.getSource()).stop();
            }
        }
    }

    static class SharedActionScroller
    extends AbstractAction {
        int dir;
        boolean block;

        public SharedActionScroller(int n2, boolean bl2) {
            this.dir = n2;
            this.block = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JSlider jSlider = (JSlider)actionEvent.getSource();
            if (this.dir == -1 || this.dir == 1) {
                int n2 = this.dir;
                SynthSliderUI synthSliderUI = (SynthSliderUI)jSlider.getUI();
                if (jSlider.getInverted()) {
                    int n3 = n2 = this.dir == -1 ? 1 : -1;
                }
                if (this.block) {
                    synthSliderUI.scrollByBlock(n2);
                } else {
                    synthSliderUI.scrollByUnit(n2);
                }
            } else if (jSlider.getInverted()) {
                if (this.dir == -2) {
                    jSlider.setValue(jSlider.getMaximum());
                } else if (this.dir == 2) {
                    jSlider.setValue(jSlider.getMinimum());
                }
            } else if (this.dir == -2) {
                jSlider.setValue(jSlider.getMinimum());
            } else if (this.dir == 2) {
                jSlider.setValue(jSlider.getMaximum());
            }
        }
    }

    protected class TrackListener
    extends MouseInputAdapter {
        protected transient int offset;
        protected transient int currentMouseX;
        protected transient int currentMouseY;
        private final SynthSliderUI this$0;

        public boolean shouldScroll(int n2) {
            Rectangle rectangle = this.this$0.thumbRect;
            if (this.this$0.slider.getOrientation() == 1 ? ((this.this$0.drawInverted() ? n2 < 0 : n2 > 0) ? rectangle.y + rectangle.height <= this.currentMouseY : rectangle.y >= this.currentMouseY) : ((this.this$0.drawInverted() ? n2 < 0 : n2 > 0) ? rectangle.x + rectangle.width >= this.currentMouseX : rectangle.x <= this.currentMouseX)) {
                return false;
            }
            if (n2 > 0 && this.this$0.slider.getValue() + this.this$0.slider.getExtent() >= this.this$0.slider.getMaximum()) {
                return false;
            }
            return n2 >= 0 || this.this$0.slider.getValue() > this.this$0.slider.getMinimum();
        }

        protected TrackListener(SynthSliderUI synthSliderUI) {
            this.this$0 = synthSliderUI;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n2 = 0;
            if (!this.this$0.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (!SynthSliderUI.access$100(this.this$0)) {
                return;
            }
            this.this$0.slider.setValueIsAdjusting(true);
            switch (this.this$0.slider.getOrientation()) {
                case 1: {
                    int n3 = this.this$0.thumbRect.height / 2;
                    int n4 = mouseEvent.getY() - this.offset;
                    int n5 = this.this$0.trackRect.y;
                    int n6 = this.this$0.trackRect.y + this.this$0.trackRect.height - n3 - SynthSliderUI.access$200();
                    int n7 = this.this$0.yPositionForValue(this.this$0.slider.getMaximum() - this.this$0.slider.getExtent());
                    if (this.this$0.drawInverted()) {
                        n6 = n7;
                    } else {
                        n5 = n7;
                    }
                    n4 = Math.max(n4, n5 - n3);
                    n4 = Math.min(n4, n6 - n3);
                    this.this$0.setThumbLocation(this.this$0.thumbRect.x, n4);
                    n2 = n4 + n3;
                    this.this$0.slider.setValue(this.this$0.valueForYPosition(n2));
                    break;
                }
                case 0: {
                    int n8 = this.this$0.thumbRect.width / 2;
                    int n9 = mouseEvent.getX() - this.offset;
                    int n10 = this.this$0.trackRect.x + n8 + SynthSliderUI.access$200();
                    int n11 = this.this$0.trackRect.x + this.this$0.trackRect.width - n8 - SynthSliderUI.access$200();
                    int n12 = this.this$0.xPositionForValue(this.this$0.slider.getMaximum() - this.this$0.slider.getExtent());
                    if (this.this$0.drawInverted()) {
                        n10 = n12;
                    } else {
                        n11 = n12;
                    }
                    n9 = Math.max(n9, n10 - n8);
                    n9 = Math.min(n9, n11 - n8);
                    this.this$0.setThumbLocation(n9, this.this$0.thumbRect.y);
                    n2 = n9 + n8;
                    this.this$0.slider.setValue(this.this$0.valueForXPosition(n2));
                    break;
                }
                default: {
                    return;
                }
            }
            if (this.this$0.slider.getValueIsAdjusting()) {
                SynthSliderUI.access$300(this.this$0, true);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            SynthSliderUI.access$400(this.this$0, mouseEvent.getX(), mouseEvent.getY());
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!this.this$0.slider.isEnabled()) {
                return;
            }
            this.currentMouseX = mouseEvent.getX();
            this.currentMouseY = mouseEvent.getY();
            if (this.this$0.slider.isRequestFocusEnabled()) {
                this.this$0.slider.requestFocus();
            }
            if (this.this$0.thumbRect.contains(this.currentMouseX, this.currentMouseY)) {
                switch (this.this$0.slider.getOrientation()) {
                    case 1: {
                        this.offset = this.currentMouseY - this.this$0.thumbRect.y;
                        break;
                    }
                    case 0: {
                        this.offset = this.currentMouseX - this.this$0.thumbRect.x;
                    }
                }
                SynthSliderUI.access$102(this.this$0, true);
                return;
            }
            SynthSliderUI.access$102(this.this$0, false);
            this.this$0.slider.setValueIsAdjusting(true);
            Dimension dimension = this.this$0.slider.getSize();
            int n2 = 1;
            switch (this.this$0.slider.getOrientation()) {
                case 1: {
                    int n3;
                    if (this.this$0.thumbRect.isEmpty()) {
                        n3 = dimension.height / 2;
                        if (!this.this$0.drawInverted()) {
                            n2 = this.currentMouseY < n3 ? 1 : -1;
                            break;
                        }
                        n2 = this.currentMouseY < n3 ? -1 : 1;
                        break;
                    }
                    n3 = this.this$0.thumbRect.y;
                    if (!this.this$0.drawInverted()) {
                        n2 = this.currentMouseY < n3 ? 1 : -1;
                        break;
                    }
                    n2 = this.currentMouseY < n3 ? -1 : 1;
                    break;
                }
                case 0: {
                    int n3;
                    if (this.this$0.thumbRect.isEmpty()) {
                        n3 = dimension.width / 2;
                        if (!this.this$0.drawInverted()) {
                            n2 = this.currentMouseX < n3 ? -1 : 1;
                            break;
                        }
                        n2 = this.currentMouseX < n3 ? 1 : -1;
                        break;
                    }
                    n3 = this.this$0.thumbRect.x;
                    n2 = !this.this$0.drawInverted() ? (this.currentMouseX < n3 ? -1 : 1) : (this.currentMouseX < n3 ? 1 : -1);
                }
            }
            this.this$0.scrollDueToClickInTrack(n2);
            Rectangle rectangle = this.this$0.thumbRect;
            if (!rectangle.contains(this.currentMouseX, this.currentMouseY) && this.shouldScroll(n2)) {
                this.this$0.scrollTimer.stop();
                this.this$0.scrollListener.setDirection(n2);
                this.this$0.scrollTimer.start();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!this.this$0.slider.isEnabled()) {
                return;
            }
            this.offset = 0;
            this.this$0.scrollTimer.stop();
            if (this.this$0.slider.getSnapToTicks()) {
                SynthSliderUI.access$102(this.this$0, false);
                this.this$0.slider.setValueIsAdjusting(false);
            } else {
                this.this$0.slider.setValueIsAdjusting(false);
                SynthSliderUI.access$102(this.this$0, false);
            }
            SynthSliderUI.access$400(this.this$0, mouseEvent.getX(), mouseEvent.getY());
            this.this$0.slider.repaint();
        }
    }
}

