/*
 * Decompiled with CFR 0.152.
 */
package java.text;

final class DigitList
implements Cloneable {
    public static final int MAX_COUNT = 19;
    public static final int DBL_DIG = 17;
    public int decimalAt = 0;
    public int count = 0;
    public char[] digits = new char[19];
    private static final char[] LONG_MIN_REP = "9223372036854775808".toCharArray();
    private StringBuffer tempBuffer;

    public final double getDouble() {
        if (this.count == 0) {
            return 0.0;
        }
        StringBuffer stringBuffer = this.getStringBuffer();
        stringBuffer.append('.').append(this.digits, 0, this.count);
        stringBuffer.append('E');
        stringBuffer.append(this.decimalAt);
        return Double.parseDouble(stringBuffer.toString());
    }

    public int hashCode() {
        int n2 = this.decimalAt;
        for (int i2 = 0; i2 < this.count; ++i2) {
            n2 = n2 * 37 + this.digits[i2];
        }
        return n2;
    }

    public final long getLong() {
        if (this.count == 0) {
            return 0L;
        }
        if (this.isLongMIN_VALUE()) {
            return Long.MIN_VALUE;
        }
        StringBuffer stringBuffer = this.getStringBuffer();
        stringBuffer.append(this.digits, 0, this.count);
        for (int i2 = this.count; i2 < this.decimalAt; ++i2) {
            stringBuffer.append('0');
        }
        return Long.parseLong(stringBuffer.toString());
    }

    DigitList() {
    }

    public void clear() {
        this.decimalAt = 0;
        this.count = 0;
    }

    private boolean isLongMIN_VALUE() {
        if (this.decimalAt != this.count || this.count != 19) {
            return false;
        }
        for (int i2 = 0; i2 < this.count; ++i2) {
            if (this.digits[i2] == LONG_MIN_REP[i2]) continue;
            return false;
        }
        return true;
    }

    boolean isZero() {
        for (int i2 = 0; i2 < this.count; ++i2) {
            if (this.digits[i2] == '0') continue;
            return false;
        }
        return true;
    }

    public void append(char c2) {
        if (this.count < 19) {
            this.digits[this.count++] = c2;
        }
    }

    public final void set(double d2, int n2) {
        this.set(d2, n2, true);
    }

    final void set(double d2, int n2, boolean bl2) {
        if (d2 == 0.0) {
            d2 = 0.0;
        }
        char[] cArray = Double.toString(d2).toCharArray();
        this.decimalAt = -1;
        this.count = 0;
        int n3 = 0;
        int n4 = 0;
        boolean bl3 = false;
        int n5 = 0;
        while (n5 < cArray.length) {
            char c2;
            if ((c2 = cArray[n5++]) == '.') {
                this.decimalAt = this.count;
                continue;
            }
            if (c2 == 'e' || c2 == 'E') {
                n3 = DigitList.parseInt(cArray, n5);
                break;
            }
            if (this.count >= 19) continue;
            if (!bl3) {
                boolean bl4 = bl3 = c2 != '0';
                if (!bl3 && this.decimalAt != -1) {
                    ++n4;
                }
            }
            if (!bl3) continue;
            this.digits[this.count++] = c2;
        }
        if (this.decimalAt == -1) {
            this.decimalAt = this.count;
        }
        if (bl3) {
            this.decimalAt += n3 - n4;
        }
        if (bl2) {
            if (-this.decimalAt > n2) {
                this.count = 0;
                return;
            }
            if (-this.decimalAt == n2) {
                if (this.shouldRoundUp(0)) {
                    this.count = 1;
                    ++this.decimalAt;
                    this.digits[0] = 49;
                } else {
                    this.count = 0;
                }
                return;
            }
        }
        while (this.count > 1 && this.digits[this.count - 1] == '0') {
            --this.count;
        }
        this.round(bl2 ? n2 + this.decimalAt : n2);
    }

    private final void round(int n2) {
        if (n2 >= 0 && n2 < this.count) {
            if (this.shouldRoundUp(n2)) {
                do {
                    if (--n2 < 0) {
                        this.digits[0] = 49;
                        ++this.decimalAt;
                        n2 = 0;
                        break;
                    }
                    int n3 = n2;
                    this.digits[n3] = (char)(this.digits[n3] + '\u0001');
                } while (this.digits[n2] > '9');
                ++n2;
            }
            this.count = n2;
            while (this.count > 1 && this.digits[this.count - 1] == '0') {
                --this.count;
            }
        }
    }

    private boolean shouldRoundUp(int n2) {
        boolean bl2 = false;
        if (n2 < this.count) {
            if (this.digits[n2] > '5') {
                return true;
            }
            if (this.digits[n2] == '5') {
                for (int i2 = n2 + 1; i2 < this.count; ++i2) {
                    if (this.digits[i2] == '0') continue;
                    return true;
                }
                return n2 > 0 && this.digits[n2 - 1] % 2 != 0;
            }
        }
        return false;
    }

    public final void set(long l2) {
        this.set(l2, 0);
    }

    public final void set(long l2, int n2) {
        if (l2 <= 0L) {
            if (l2 == Long.MIN_VALUE) {
                this.count = 19;
                this.decimalAt = 19;
                System.arraycopy(LONG_MIN_REP, 0, this.digits, 0, this.count);
            } else {
                this.count = 0;
                this.decimalAt = 0;
            }
        } else {
            int n3 = 19;
            while (l2 > 0L) {
                this.digits[--n3] = (char)(48L + l2 % 10L);
                l2 /= 10L;
            }
            this.decimalAt = 19 - n3;
            int n4 = 18;
            while (this.digits[n4] == '0') {
                --n4;
            }
            this.count = n4 - n3 + 1;
            System.arraycopy(this.digits, n3, this.digits, 0, this.count);
        }
        if (n2 > 0) {
            this.round(n2);
        }
    }

    boolean fitsIntoLong(boolean bl2, boolean bl3) {
        while (this.count > 0 && this.digits[this.count - 1] == '0') {
            --this.count;
        }
        if (this.count == 0) {
            return bl2 || bl3;
        }
        if (this.decimalAt < this.count || this.decimalAt > 19) {
            return false;
        }
        if (this.decimalAt < 19) {
            return true;
        }
        for (int i2 = 0; i2 < this.count; ++i2) {
            char c2 = this.digits[i2];
            char c3 = LONG_MIN_REP[i2];
            if (c2 > c3) {
                return false;
            }
            if (c2 >= c3) continue;
            return true;
        }
        if (this.count < this.decimalAt) {
            return true;
        }
        return !bl2;
    }

    private static final int parseInt(char[] cArray, int n2) {
        boolean bl2 = true;
        char c2 = cArray[n2];
        if (c2 == '-') {
            bl2 = false;
            ++n2;
        } else if (c2 == '+') {
            ++n2;
        }
        int n3 = 0;
        while (n2 < cArray.length && (c2 = cArray[n2++]) >= '0' && c2 <= '9') {
            n3 = n3 * 10 + (c2 - 48);
        }
        return bl2 ? n3 : -n3;
    }

    public Object clone() {
        try {
            DigitList digitList = (DigitList)super.clone();
            char[] cArray = new char[this.digits.length];
            System.arraycopy(this.digits, 0, cArray, 0, this.digits.length);
            digitList.digits = cArray;
            return digitList;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DigitList)) {
            return false;
        }
        DigitList digitList = (DigitList)object;
        if (this.count != digitList.count || this.decimalAt != digitList.decimalAt) {
            return false;
        }
        for (int i2 = 0; i2 < this.count; ++i2) {
            if (this.digits[i2] == digitList.digits[i2]) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.isZero()) {
            return "0";
        }
        StringBuffer stringBuffer = this.getStringBuffer();
        stringBuffer.append("0.").append(this.digits, 0, this.count);
        stringBuffer.append("x10^");
        stringBuffer.append(this.decimalAt);
        return stringBuffer.toString();
    }

    private StringBuffer getStringBuffer() {
        if (this.tempBuffer == null) {
            this.tempBuffer = new StringBuffer(19);
        } else {
            this.tempBuffer.setLength(0);
        }
        return this.tempBuffer;
    }
}

