/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import sun.awt.X11GraphicsConfig;
import sun.awt.X11SurfaceData;
import sun.awt.image.BufImgSurfaceData;
import sun.awt.image.DataBufferNative;
import sun.awt.image.WritableRasterNative;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.X11OffScreenImage;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.java2d.loops.CompositeType;
import sun.java2d.pipe.DrawImage;

public class X11RemoteOffScreenImage
extends X11OffScreenImage {
    int bufImageTypeSw = this.getType();
    SurfaceData bisd;

    static {
        X11RemoteOffScreenImage.initIDs();
    }

    protected void copyBackupToAccelerated() {
        if (this.surfaceDataSw != null && this.surfaceDataHw != null && this.surfaceDataSw != this.surfaceDataHw) {
            Object object;
            Object object2;
            Font font = new Font("Dialog", 0, 12);
            if (this.bisd == null) {
                if (this.bufImageTypeSw > 0) {
                    object2 = new BufferedImage(this.getWidth(), this.getHeight(), this.bufImageTypeSw);
                } else {
                    object = this.getColorModel();
                    WritableRaster writableRaster = ((ColorModel)object).createCompatibleWritableRaster(this.getWidth(), this.getHeight());
                    object2 = new BufferedImage((ColorModel)object, writableRaster, ((ColorModel)object).isAlphaPremultiplied(), null);
                }
                this.bisd = BufImgSurfaceData.createData((BufferedImage)object2);
            }
            object2 = new SunGraphics2D(this.bisd, Color.black, Color.white, font);
            DrawImage.renderSurfaceData((SunGraphics2D)object2, this.surfaceDataSw, null, 0, 0, 0, 0, this.getWidth(), this.getHeight());
            ((SunGraphics2D)object2).dispose();
            object = new SunGraphics2D(this.surfaceDataHw, Color.black, Color.white, font);
            DrawImage.renderSurfaceData((SunGraphics2D)object, this.bisd, null, 0, 0, 0, 0, this.getWidth(), this.getHeight());
            ((SunGraphics2D)object).dispose();
        }
    }

    private void createNativeRaster() {
        Object object;
        ColorModel colorModel = this.getColorModel();
        SampleModel sampleModel = null;
        int n2 = 0;
        int n3 = this.getWidth();
        switch (colorModel.getPixelSize()) {
            case 8: 
            case 12: {
                n2 = colorModel.getPixelSize() == 8 ? 0 : 1;
                object = new int[]{0};
                sampleModel = new PixelInterleavedSampleModel(n2, this.getWidth(), this.getHeight(), 1, n3, (int[])object);
                break;
            }
            case 15: 
            case 16: {
                n2 = 1;
                int[] nArray = new int[3];
                DirectColorModel directColorModel = (DirectColorModel)colorModel;
                nArray[0] = directColorModel.getRedMask();
                nArray[1] = directColorModel.getGreenMask();
                nArray[2] = directColorModel.getBlueMask();
                sampleModel = new SinglePixelPackedSampleModel(n2, this.getWidth(), this.getHeight(), n3, nArray);
                break;
            }
            case 24: 
            case 32: {
                n2 = 3;
                int[] nArray = new int[3];
                DirectColorModel directColorModel = (DirectColorModel)colorModel;
                nArray[0] = directColorModel.getRedMask();
                nArray[1] = directColorModel.getGreenMask();
                nArray[2] = directColorModel.getBlueMask();
                sampleModel = new SinglePixelPackedSampleModel(n2, this.getWidth(), this.getHeight(), n3, nArray);
                break;
            }
            default: {
                throw new InternalError("Unsupported depth " + colorModel.getPixelSize());
            }
        }
        object = new DataBufferNative(this.surfaceDataHw, n2, this.getWidth(), this.getHeight());
        this.setRasterNative(WritableRasterNative.createNativeRaster(sampleModel, (DataBuffer)object));
    }

    public void initContents() {
        Graphics2D graphics2D = this.createGraphics();
        graphics2D.clearRect(0, 0, this.getWidth(), this.getHeight());
        graphics2D.dispose();
    }

    private static native void initIDs();

    public BufferedImage getSnapshot() {
        Object object;
        BufferedImage bufferedImage;
        if (this.bufImageTypeSw > 0) {
            bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), this.bufImageTypeSw);
        } else {
            object = this.getColorModel();
            WritableRaster writableRaster = ((ColorModel)object).createCompatibleWritableRaster(this.getWidth(), this.getHeight());
            bufferedImage = new BufferedImage((ColorModel)object, writableRaster, ((ColorModel)object).isAlphaPremultiplied(), null);
        }
        object = bufferedImage.createGraphics();
        ((Graphics)object).drawImage(this, 0, 0, null);
        ((Graphics)object).dispose();
        return bufferedImage;
    }

    private native void setRasterNative(WritableRaster var1);

    private void setCurrentSurfaceData(SurfaceData surfaceData) {
        if (surfaceData != this.surfaceData) {
            this.surfaceData = surfaceData;
            this.setSurfaceDataNative(surfaceData);
        }
    }

    private native void setSurfaceDataNative(SurfaceData var1);

    public X11RemoteOffScreenImage(Component component, ColorModel colorModel, WritableRaster writableRaster, boolean bl2) {
        super(component, colorModel, writableRaster, bl2, false);
        if (!accelerationEnabled) {
            return;
        }
        X11GraphicsConfig x11GraphicsConfig = X11SurfaceData.getGC(component == null ? null : (MComponentPeer)component.getPeer());
        this.initAcceleratedBackground(x11GraphicsConfig, this.getWidth(), this.getHeight());
        if (this.surfaceDataHw != null) {
            this.setCurrentSurfaceData(this.surfaceDataHw);
            this.surfaceDataSw = this.surfaceDataHw;
            this.initContents();
            this.createNativeRaster();
        }
    }

    public SurfaceData getSourceSurfaceData(SurfaceData surfaceData, CompositeType compositeType, Color color) {
        if (accelerationEnabled && surfaceData != this.surfaceDataHw && this.destSurfaceAccelerated(surfaceData)) {
            this.validate(surfaceData.getDeviceConfiguration());
            if (this.surfaceDataHw != null) {
                return this.surfaceDataHw;
            }
        }
        return this.surfaceDataSw;
    }
}

