/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Enumeration;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertAttrSet;
import sun.security.x509.Extension;
import sun.security.x509.GeneralNames;
import sun.security.x509.KeyIdentifier;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.SerialNumber;

public class AuthorityKeyIdentifierExtension
extends Extension
implements CertAttrSet {
    public static final String IDENT = "x509.info.extensions.AuthorityKeyIdentifier";
    public static final String NAME = "AuthorityKeyIdentifier";
    public static final String KEY_ID = "key_id";
    public static final String AUTH_NAME = "auth_name";
    public static final String SERIAL_NUMBER = "serial_number";
    private static final byte TAG_ID = 0;
    private static final byte TAG_NAMES = 1;
    private static final byte TAG_SERIAL_NUM = 2;
    private KeyIdentifier id = null;
    private GeneralNames names = null;
    private SerialNumber serialNum = null;

    private void encodeThis() throws IOException {
        DerOutputStream derOutputStream;
        if (this.id == null && this.names == null && this.serialNum == null) {
            this.extensionValue = null;
            return;
        }
        DerOutputStream derOutputStream2 = new DerOutputStream();
        DerOutputStream derOutputStream3 = new DerOutputStream();
        if (this.id != null) {
            derOutputStream = new DerOutputStream();
            this.id.encode(derOutputStream);
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, false, (byte)0), derOutputStream);
        }
        try {
            if (this.names != null) {
                derOutputStream = new DerOutputStream();
                this.names.encode(derOutputStream);
                derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, true, (byte)1), derOutputStream);
            }
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
        if (this.serialNum != null) {
            derOutputStream = new DerOutputStream();
            this.serialNum.encode(derOutputStream);
            derOutputStream3.writeImplicit(DerValue.createTag((byte)-128, false, (byte)2), derOutputStream);
        }
        derOutputStream2.write((byte)48, derOutputStream3);
        this.extensionValue = derOutputStream2.toByteArray();
    }

    public void decode(InputStream inputStream) throws IOException {
        throw new IOException("Method not to be called directly.");
    }

    public void encode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        if (this.extensionValue == null) {
            this.extensionId = PKIXExtensions.AuthorityKey_Id;
            this.critical = false;
            this.encodeThis();
        }
        super.encode(derOutputStream);
        outputStream.write(derOutputStream.toByteArray());
    }

    public String getName() {
        return NAME;
    }

    public String toString() {
        String string = super.toString() + "AuthorityKeyIdentifier [\n";
        if (this.id != null) {
            string = string + this.id.toString() + "\n";
        }
        if (this.names != null) {
            string = string + this.names.toString() + "\n";
        }
        if (this.serialNum != null) {
            string = string + this.serialNum.toString() + "\n";
        }
        return string + "]\n";
    }

    public void delete(String string) throws IOException {
        if (string.equalsIgnoreCase(KEY_ID)) {
            this.id = null;
        } else if (string.equalsIgnoreCase(AUTH_NAME)) {
            this.names = null;
        } else if (string.equalsIgnoreCase(SERIAL_NUMBER)) {
            this.serialNum = null;
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:AuthorityKeyIdentifier.");
        }
        this.encodeThis();
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(KEY_ID);
        attributeNameEnumeration.addElement(AUTH_NAME);
        attributeNameEnumeration.addElement(SERIAL_NUMBER);
        return attributeNameEnumeration.elements();
    }

    public AuthorityKeyIdentifierExtension(Boolean bl2, Object object) throws IOException {
        this.extensionId = PKIXExtensions.AuthorityKey_Id;
        this.critical = bl2;
        if (!(object instanceof byte[])) {
            throw new IOException("Illegal argument type");
        }
        int n2 = Array.getLength(object);
        byte[] byArray = new byte[n2];
        System.arraycopy(object, 0, byArray, 0, n2);
        this.extensionValue = byArray;
        DerValue derValue = new DerValue(byArray);
        if (derValue.tag != 48) {
            throw new IOException("Invalid encoding for AuthorityKeyIdentifierExtension.");
        }
        while (derValue.data != null && derValue.data.available() != 0) {
            DerValue derValue2 = derValue.data.getDerValue();
            if (derValue2.isContextSpecific((byte)0) && !derValue2.isConstructed()) {
                if (this.id != null) {
                    throw new IOException("Duplicate KeyIdentifier in AuthorityKeyIdentifier.");
                }
                derValue2.resetTag((byte)4);
                this.id = new KeyIdentifier(derValue2);
                continue;
            }
            if (derValue2.isContextSpecific((byte)1) && derValue2.isConstructed()) {
                if (this.names != null) {
                    throw new IOException("Duplicate GeneralNames in AuthorityKeyIdentifier.");
                }
                derValue2.resetTag((byte)48);
                this.names = new GeneralNames(derValue2);
                continue;
            }
            if (derValue2.isContextSpecific((byte)2) && !derValue2.isConstructed()) {
                if (this.serialNum != null) {
                    throw new IOException("Duplicate SerialNumber in AuthorityKeyIdentifier.");
                }
                derValue2.resetTag((byte)2);
                this.serialNum = new SerialNumber(derValue2);
                continue;
            }
            throw new IOException("Invalid encoding of AuthorityKeyIdentifierExtension.");
        }
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(KEY_ID)) {
            return this.id;
        }
        if (string.equalsIgnoreCase(AUTH_NAME)) {
            return this.names;
        }
        if (string.equalsIgnoreCase(SERIAL_NUMBER)) {
            return this.serialNum;
        }
        throw new IOException("Attribute name not recognized by CertAttrSet:AuthorityKeyIdentifier.");
    }

    public void set(String string, Object object) throws IOException {
        if (string.equalsIgnoreCase(KEY_ID)) {
            if (!(object instanceof KeyIdentifier)) {
                throw new IOException("Attribute value should be of type KeyIdentifier.");
            }
            this.id = (KeyIdentifier)object;
        } else if (string.equalsIgnoreCase(AUTH_NAME)) {
            if (!(object instanceof GeneralNames)) {
                throw new IOException("Attribute value should be of type GeneralNames.");
            }
            this.names = (GeneralNames)object;
        } else if (string.equalsIgnoreCase(SERIAL_NUMBER)) {
            if (!(object instanceof SerialNumber)) {
                throw new IOException("Attribute value should be of type SerialNumber.");
            }
            this.serialNum = (SerialNumber)object;
        } else {
            throw new IOException("Attribute name not recognized by CertAttrSet:AuthorityKeyIdentifier.");
        }
        this.encodeThis();
    }

    public AuthorityKeyIdentifierExtension(KeyIdentifier keyIdentifier, GeneralNames generalNames, SerialNumber serialNumber) throws IOException {
        this.id = keyIdentifier;
        this.names = generalNames;
        this.serialNum = serialNumber;
        this.extensionId = PKIXExtensions.AuthorityKey_Id;
        this.critical = false;
        this.encodeThis();
    }
}

