/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws.cache;

import com.sun.javaws.JavawsFactory;
import com.sun.javaws.cache.DiskCache;
import com.sun.javaws.cache.DiskCacheEntry;
import com.sun.javaws.cache.DownloadProtocol;
import com.sun.javaws.cache.InstallCache;
import com.sun.javaws.cache.Patcher;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.exceptions.BadJARFileException;
import com.sun.javaws.exceptions.BadMimeTypeResponseException;
import com.sun.javaws.exceptions.BadVersionResponseException;
import com.sun.javaws.exceptions.ErrorCodeResponseException;
import com.sun.javaws.exceptions.FailedDownloadingResourceException;
import com.sun.javaws.exceptions.InvalidJarDiffException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.exceptions.MissingVersionResponseException;
import com.sun.javaws.jardiff.JarDiffPatcher;
import com.sun.javaws.net.CanceledDownloadException;
import com.sun.javaws.net.HttpDownloadListener;
import com.sun.javaws.net.HttpResponse;
import com.sun.javaws.security.SigningInfo;
import com.sun.javaws.util.URLUtil;
import com.sun.javaws.util.VersionID;
import com.sun.javaws.util.VersionString;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.jar.JarFile;
import java.util.zip.ZipException;

public class DownloadProtocol {
    private static DiskCache _diskCache = null;
    public static final int JAR_DOWNLOAD = 0;
    public static final int NATIVE_DOWNLOAD = 1;
    public static final int IMAGE_DOWNLOAD = 2;
    public static final int APPLICATION_JNLP_DOWNLOAD = 3;
    public static final int EXTENSION_JNLP_DOWNLOAD = 4;
    private static final String JNLP_MIME_TYPE = "application/x-java-jnlp-file";
    private static final String ERROR_MIME_TYPE = "application/x-java-jnlp-error";
    private static final String JAR_MIME_TYPE = "application/x-java-archive";
    private static final String JARDIFF_MIME_TYPE = "application/x-java-archive-diff";
    private static final String GIF_MIME_TYPE = "image/gif";
    private static final String JPEG_MIME_TYPE = "image/jpeg";
    private static final String ARG_ARCH = "arch";
    private static final String ARG_OS = "os";
    private static final String ARG_LOCALE = "locale";
    private static final String ARG_VERSION_ID = "version-id";
    private static final String ARG_CURRENT_VERSION_ID = "current-version-id";
    private static final String ARG_PLATFORM_VERSION_ID = "platform-version-id";
    private static final String ARG_KNOWN_PLATFORMS = "known-platforms";
    private static final String REPLY_JNLP_VERSION = "x-java-jnlp-version-id";

    public static boolean isJarHeaderValid(byte[] byArray) {
        return DownloadProtocol.get32(byArray, 0) == 67324752L;
    }

    private static final int get16(byte[] byArray, int n) {
        return byArray[n] & 0xFF | (byArray[n + 1] & 0xFF) << 8;
    }

    private static final long get32(byte[] byArray, int n) {
        return (long)DownloadProtocol.get16(byArray, n) | (long)DownloadProtocol.get16(byArray, n + 2) << 16;
    }

    static DiskCache access$100() {
        return _diskCache;
    }

    static DiskCache access$300() {
        return DownloadProtocol.getDiskCache();
    }

    private static synchronized DiskCache getDiskCache() {
        if (_diskCache == null) {
            InstallCache.getCache();
            _diskCache = InstallCache.getDiskCache();
        }
        return _diskCache;
    }

    private static void updateWithCertificate(DiskCacheEntry diskCacheEntry, int n) throws JNLPException {
        if (diskCacheEntry == null) {
            return;
        }
        URL uRL = diskCacheEntry.getLocation();
        String string = diskCacheEntry.getVersionId();
        try {
            boolean bl;
            if (diskCacheEntry.getCertificateChain() != null) {
                return;
            }
            boolean bl2 = bl = n == 0 || n == 1;
            if (bl) {
                Certificate[] certificateArray = null;
                File file = diskCacheEntry.getCertificateFile();
                if (!file.exists()) {
                    JarFile jarFile = new JarFile(diskCacheEntry.getFile());
                    certificateArray = SigningInfo.checkSigning(uRL, string, jarFile, null, null);
                    jarFile.close();
                    jarFile = null;
                    _diskCache.putCertificateChain('R', uRL, string, certificateArray);
                } else if (file.length() != 0L) {
                    certificateArray = _diskCache.getCertificateChain('R', diskCacheEntry.getLocation(), diskCacheEntry.getVersionId());
                }
                diskCacheEntry.setCertificateChain(certificateArray);
            }
        }
        catch (IOException iOException) {
            throw new FailedDownloadingResourceException(diskCacheEntry.getLocation(), diskCacheEntry.getVersionId(), iOException);
        }
    }

    public static boolean isLaunchFileUpdateAvailable(URL uRL) throws JNLPException {
        if (Globals.isOffline()) {
            return false;
        }
        DownloadInfo downloadInfo = new DownloadInfo(uRL, null, 3, false);
        UpdateAvailableAction updateAvailableAction = new UpdateAvailableAction(null);
        DownloadProtocol.doDownload(downloadInfo, updateAvailableAction);
        return updateAvailableAction.getResult();
    }

    public static DiskCacheEntry getCachedLaunchedFile(URL uRL) throws JNLPException {
        DownloadInfo downloadInfo = new DownloadInfo(uRL, null, 3, true);
        IsInCacheAction isInCacheAction = new IsInCacheAction(null);
        DownloadProtocol.doDownload(downloadInfo, isInCacheAction);
        DiskCacheEntry diskCacheEntry = isInCacheAction.getResult();
        return diskCacheEntry;
    }

    public static DiskCacheEntry getLaunchFile(URL uRL, boolean bl) throws JNLPException {
        DownloadInfo downloadInfo = new DownloadInfo(uRL, null, 3, false);
        RetrieveAction retrieveAction = new RetrieveAction(null);
        DownloadProtocol.doDownload(downloadInfo, retrieveAction);
        DiskCacheEntry diskCacheEntry = retrieveAction.getResult();
        if (diskCacheEntry == null) {
            throw new FailedDownloadingResourceException(uRL, null, null);
        }
        DownloadProtocol.updateWithCertificate(diskCacheEntry, 3);
        return diskCacheEntry;
    }

    private static void doDownload(DownloadInfo downloadInfo, DownloadAction downloadAction) throws JNLPException {
        try {
            HttpResponse httpResponse;
            Object object;
            boolean[] blArray = new boolean[1];
            DiskCacheEntry diskCacheEntry = DownloadProtocol.findBestDiskCacheEntry(downloadInfo.getDiskCacheType(), downloadInfo.getLocation(), downloadInfo.getVersion(), blArray);
            boolean bl = blArray[0];
            if (diskCacheEntry != null && downloadInfo.isCacheOk(diskCacheEntry, bl)) {
                boolean bl2 = true;
                object = diskCacheEntry.getCodebaseIP();
                bl2 = URLUtil.isCachedHostIPValid(diskCacheEntry.getLocation().getHost(), (String)object, null);
                if (bl2) {
                    if (Globals.TraceDownload) {
                        Debug.println("Found in cache: " + diskCacheEntry);
                    }
                    downloadAction.actionInCache(diskCacheEntry);
                    return;
                }
                _diskCache.removeEntry(diskCacheEntry);
            }
            if (Globals.isOffline()) {
                if (Globals.TraceDownload) {
                    Debug.println("Offline mode. No Web check. Cache lookup: " + diskCacheEntry);
                }
                downloadAction.actionOffline(diskCacheEntry, bl);
                return;
            }
            if (downloadAction.skipDownloadStep()) {
                if (Globals.TraceDownload) {
                    Debug.println("Skipping download step");
                }
                return;
            }
            URL uRL = downloadInfo.getRequestURL(diskCacheEntry);
            if (Globals.TraceDownload) {
                Debug.println("Connection to: " + uRL);
            }
            object = JavawsFactory.getHttpRequestImpl();
            HttpResponse httpResponse2 = httpResponse = downloadAction.useHeadRequest() ? object.doHeadRequest(uRL) : object.doGetRequest(uRL);
            if (httpResponse.getStatusCode() == 404) {
                throw new FailedDownloadingResourceException(downloadInfo.getLocation(), downloadInfo.getVersion(), new IOException("HTTP response 404"));
            }
            int n = httpResponse.getContentLength();
            long l = httpResponse.getLastModified();
            String string = httpResponse.getResponseHeader(REPLY_JNLP_VERSION);
            String string2 = httpResponse.getContentType();
            if (Globals.TraceDownload) {
                Debug.println("Sever response: (length: " + n + ", lastModified: " + new Date(l) + ", downloadVersion " + string + ", mimeType: " + string2 + ")");
            }
            if (string2 != null && string2.equalsIgnoreCase(ERROR_MIME_TYPE)) {
                BufferedInputStream bufferedInputStream = httpResponse.getInputStream();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(bufferedInputStream));
                String string3 = bufferedReader.readLine();
                throw new ErrorCodeResponseException(downloadInfo.getLocation(), downloadInfo.getVersion(), string3);
            }
            if (!downloadInfo.isValidMimeType(string2, diskCacheEntry)) {
                throw new BadMimeTypeResponseException(downloadInfo.getLocation(), downloadInfo.getVersion(), string2);
            }
            if (downloadInfo.needsReplyVersion(diskCacheEntry)) {
                if (string == null) {
                    throw new MissingVersionResponseException(downloadInfo.getLocation(), downloadInfo.getVersion());
                }
                if (!downloadInfo.isPlatformRequest()) {
                    if (!new VersionString(downloadInfo.getVersion()).contains(string)) {
                        throw new BadVersionResponseException(downloadInfo.getLocation(), downloadInfo.getVersion(), string);
                    }
                    VersionID versionID = new VersionID(string);
                    if (versionID.usePrefixMatch() || versionID.useGreaterThanMatch()) {
                        throw new BadVersionResponseException(downloadInfo.getLocation(), downloadInfo.getVersion(), string);
                    }
                }
            }
            if (diskCacheEntry != null && !downloadInfo.isWebNewer(diskCacheEntry, n, l, string)) {
                downloadAction.actionInCache(diskCacheEntry);
                httpResponse.disconnect();
                return;
            }
            downloadAction.actionDownload(diskCacheEntry, downloadInfo, l, n, string, string2, httpResponse);
            httpResponse.disconnect();
        }
        catch (ZipException zipException) {
            throw new BadJARFileException(downloadInfo.getLocation(), downloadInfo.getVersion(), zipException);
        }
        catch (JNLPException jNLPException) {
            throw jNLPException;
        }
        catch (Exception exception) {
            throw new FailedDownloadingResourceException(downloadInfo.getLocation(), downloadInfo.getVersion(), exception);
        }
    }

    public static long getCachedSize(URL uRL, String string, int n) {
        DiskCacheEntry diskCacheEntry = DownloadProtocol.getCachedVersion(uRL, string, n);
        return diskCacheEntry != null ? diskCacheEntry.getSize() : 0L;
    }

    public static long getDownloadSize(URL uRL, String string, int n) throws JNLPException {
        DownloadInfo downloadInfo = new DownloadInfo(uRL, string, n, false);
        DownloadSizeAction downloadSizeAction = new DownloadSizeAction(null);
        DownloadProtocol.doDownload(downloadInfo, downloadSizeAction);
        return downloadSizeAction.getResult();
    }

    public static boolean isInCache(URL uRL, String string, int n) {
        return DownloadProtocol.getCachedVersion(uRL, string, n) != null;
    }

    public static boolean isUpdateAvailable(URL uRL, String string, int n) throws JNLPException {
        if (Globals.isOffline()) {
            return false;
        }
        DownloadInfo downloadInfo = new DownloadInfo(uRL, string, n, false);
        UpdateAvailableAction updateAvailableAction = new UpdateAvailableAction(null);
        DownloadProtocol.doDownload(downloadInfo, updateAvailableAction);
        return updateAvailableAction.getResult();
    }

    private static DiskCacheEntry findBestDiskCacheEntry(char c, URL uRL, String string, boolean[] blArray) throws IOException {
        DiskCache diskCache = DownloadProtocol.getDiskCache();
        DiskCacheEntry diskCacheEntry = diskCache.getFastCacheEntry(c, uRL, string, true);
        if (diskCacheEntry != null) {
            blArray[0] = true;
            if (Globals.TraceDownload) {
                Debug.println("Returning direct match: " + diskCacheEntry);
            }
            return diskCacheEntry;
        }
        DiskCacheEntry[] diskCacheEntryArray = diskCache.getCacheEntries(c, uRL, string, false);
        if (diskCacheEntryArray.length == 0) {
            blArray[0] = false;
            return null;
        }
        DiskCacheEntry diskCacheEntry2 = diskCacheEntryArray[0];
        if (string == null) {
            blArray[0] = true;
        } else {
            VersionString versionString = new VersionString(string);
            blArray[0] = versionString.contains(diskCacheEntry2.getVersionId());
        }
        return diskCacheEntry2;
    }

    public static DiskCacheEntry getCachedVersion(URL uRL, String string, int n) {
        try {
            DownloadInfo downloadInfo = new DownloadInfo(uRL, string, n, true);
            IsInCacheAction isInCacheAction = new IsInCacheAction(null);
            DownloadProtocol.doDownload(downloadInfo, isInCacheAction);
            DiskCacheEntry diskCacheEntry = isInCacheAction.getResult();
            DownloadProtocol.updateWithCertificate(diskCacheEntry, n);
            return diskCacheEntry;
        }
        catch (JNLPException jNLPException) {
            Debug.ignoredException(jNLPException);
            return null;
        }
    }

    public static boolean isExtensionUpdateAvailable(URL uRL, String string, String string2) throws JNLPException {
        if (Globals.isOffline()) {
            return false;
        }
        DownloadInfo downloadInfo = new DownloadInfo(uRL, string, false, string2, false);
        UpdateAvailableAction updateAvailableAction = new UpdateAvailableAction(null);
        DownloadProtocol.doDownload(downloadInfo, updateAvailableAction);
        return updateAvailableAction.getResult();
    }

    public static DiskCacheEntry getResource(URL uRL, String string, int n, boolean bl, DownloadDelegate downloadDelegate) throws JNLPException {
        DownloadInfo downloadInfo = new DownloadInfo(uRL, string, n, bl);
        RetrieveAction retrieveAction = new RetrieveAction(downloadDelegate);
        DownloadProtocol.doDownload(downloadInfo, retrieveAction);
        DiskCacheEntry diskCacheEntry = retrieveAction.getResult();
        if (diskCacheEntry == null) {
            throw new FailedDownloadingResourceException(uRL, string, null);
        }
        DownloadProtocol.updateWithCertificate(diskCacheEntry, n);
        return diskCacheEntry;
    }

    public static DiskCacheEntry getCachedExtension(URL uRL, String string, String string2) throws JNLPException {
        DownloadInfo downloadInfo = new DownloadInfo(uRL, string, true, string2, false);
        IsInCacheAction isInCacheAction = new IsInCacheAction(null);
        DownloadProtocol.doDownload(downloadInfo, isInCacheAction);
        DiskCacheEntry diskCacheEntry = isInCacheAction.getResult();
        DownloadProtocol.updateWithCertificate(diskCacheEntry, 4);
        return diskCacheEntry;
    }

    public static DiskCacheEntry getExtension(URL uRL, String string, String string2, boolean bl) throws JNLPException {
        DownloadInfo downloadInfo = new DownloadInfo(uRL, string, bl, string2, false);
        RetrieveAction retrieveAction = new RetrieveAction(null);
        DownloadProtocol.doDownload(downloadInfo, retrieveAction);
        DiskCacheEntry diskCacheEntry = retrieveAction.getResult();
        if (diskCacheEntry == null) {
            throw new FailedDownloadingResourceException(uRL, string, null);
        }
        DownloadProtocol.updateWithCertificate(diskCacheEntry, 4);
        return diskCacheEntry;
    }

    public static DiskCacheEntry getJRE(URL uRL, String string, boolean bl, String string2) throws JNLPException {
        DownloadInfo downloadInfo = new DownloadInfo(uRL, string, false, string2, bl);
        RetrieveAction retrieveAction = new RetrieveAction(null);
        DownloadProtocol.doDownload(downloadInfo, retrieveAction);
        DiskCacheEntry diskCacheEntry = retrieveAction.getResult();
        if (diskCacheEntry == null) {
            throw new FailedDownloadingResourceException(uRL, string, null);
        }
        DownloadProtocol.updateWithCertificate(diskCacheEntry, 4);
        return diskCacheEntry;
    }

    static File access$200(File file, File file2, URL uRL, String string, DownloadDelegate downloadDelegate) throws JNLPException {
        return DownloadProtocol.applyPatch(file, file2, uRL, string, downloadDelegate);
    }

    /*
     * Loose catch block
     */
    private static File applyPatch(File file, File file2, URL uRL, String string, DownloadDelegate downloadDelegate) throws JNLPException {
        File file3;
        block18: {
            JarDiffPatcher jarDiffPatcher = new JarDiffPatcher();
            file3 = null;
            OutputStream outputStream = null;
            boolean bl = false;
            file3 = _diskCache.getTempCacheFile(uRL, string);
            outputStream = new FileOutputStream(file3);
            Patcher.PatchDelegate patchDelegate = null;
            if (downloadDelegate != null) {
                downloadDelegate.patching(uRL, string, 0);
                patchDelegate = new Patcher.PatchDelegate(downloadDelegate, uRL, string){
                    private final DownloadDelegate val$delegate;
                    private final URL val$location;
                    private final String val$newVersionId;

                    public void patching(int n) {
                        this.val$delegate.patching(this.val$location, this.val$newVersionId, n);
                    }
                    {
                        this.val$delegate = downloadDelegate;
                        this.val$location = uRL;
                        this.val$newVersionId = string;
                    }
                };
            }
            try {
                jarDiffPatcher.applyPatch(patchDelegate, file.getPath(), file2.getPath(), outputStream);
            }
            catch (IOException iOException) {
                throw new InvalidJarDiffException(uRL, string, iOException);
            }
            bl = true;
            Object var12_12 = null;
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException iOException) {
                Debug.ignoredException(iOException);
            }
            if (!bl) {
                file3.delete();
            }
            file2.delete();
            if (downloadDelegate != null && !bl) {
                downloadDelegate.downloadFailed(uRL, string);
            }
            break block18;
            {
                catch (IOException iOException) {
                    if (Globals.TraceDownload) {
                        Debug.println("Got exception while patching: " + iOException);
                    }
                    throw new FailedDownloadingResourceException(uRL, string, iOException);
                }
            }
            catch (Throwable throwable) {
                Object var12_13 = null;
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException iOException) {
                    Debug.ignoredException(iOException);
                }
                if (!bl) {
                    file3.delete();
                }
                file2.delete();
                if (downloadDelegate != null && !bl) {
                    downloadDelegate.downloadFailed(uRL, string);
                }
                throw throwable;
            }
        }
        return file3;
    }

    private static interface DownloadAction {
        public boolean skipDownloadStep();

        public boolean useHeadRequest();

        public void actionInCache(DiskCacheEntry var1) throws IOException, JNLPException;

        public void actionOffline(DiskCacheEntry var1, boolean var2) throws IOException, JNLPException;

        public void actionDownload(DiskCacheEntry var1, DownloadInfo var2, long var3, int var5, String var6, String var7, HttpResponse var8) throws IOException, JNLPException;
    }

    public static interface DownloadDelegate {
        public void validating(URL var1, int var2, int var3);

        public void downloadFailed(URL var1, String var2);

        public void patching(URL var1, String var2, int var3);

        public void downloading(URL var1, String var2, int var3, int var4, boolean var5);
    }

    static class DownloadInfo {
        private URL _location;
        private String _version;
        private int _kind;
        private boolean _isCacheOk;
        private String _knownPlatforms = null;
        private boolean _isPlatformVersion = false;

        char getDiskCacheType() {
            switch (this._kind) {
                case 0: {
                    return 'R';
                }
                case 2: {
                    return 'R';
                }
                case 1: {
                    return 'R';
                }
                case 3: {
                    return 'A';
                }
                case 4: {
                    return 'E';
                }
            }
            Debug.shouldNotReachHere();
            return 'a';
        }

        int getKind() {
            return this._kind;
        }

        boolean isPlatformRequest() {
            return this._isPlatformVersion;
        }

        boolean needsReplyVersion(DiskCacheEntry diskCacheEntry) {
            return this._version != null;
        }

        boolean isCacheOk(DiskCacheEntry diskCacheEntry, boolean bl) {
            return bl && (this._version != null || this._isCacheOk) && diskCacheEntry.getTimeStamp() != 0L;
        }

        String getVersion() {
            return this._version;
        }

        URL getLocation() {
            return this._location;
        }

        boolean isValidMimeType(String string, DiskCacheEntry diskCacheEntry) {
            if (string == null) {
                return false;
            }
            if (this._kind == 0 || this._kind == 1) {
                if (string.equalsIgnoreCase(DownloadProtocol.JARDIFF_MIME_TYPE)) {
                    return diskCacheEntry != null && diskCacheEntry.getVersionId() != null;
                }
                return true;
            }
            if (this._kind == 2) {
                return string.equalsIgnoreCase(DownloadProtocol.JPEG_MIME_TYPE) || string.equalsIgnoreCase(DownloadProtocol.GIF_MIME_TYPE);
            }
            return true;
        }

        boolean isWebNewer(DiskCacheEntry diskCacheEntry, long l, long l2, String string) {
            if (this._version == null) {
                return l2 == 0L && l > 0L || l2 > diskCacheEntry.getTimeStamp();
            }
            return true;
        }

        public DownloadInfo(URL uRL, String string, int n, boolean bl) {
            this._location = uRL;
            this._version = string;
            this._kind = n;
            this._isCacheOk = bl;
        }

        URL getRequestURL(DiskCacheEntry diskCacheEntry) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this._version != null && this._kind != 4) {
                this.addURLArgument(stringBuffer, DownloadProtocol.ARG_VERSION_ID, this._version);
                if ((this._kind == 0 || this._kind == 1) && diskCacheEntry != null && diskCacheEntry.getVersionId() != null) {
                    this.addURLArgument(stringBuffer, DownloadProtocol.ARG_CURRENT_VERSION_ID, diskCacheEntry.getVersionId());
                }
            }
            if (this._kind == 4 && this._version != null) {
                if (this._isPlatformVersion) {
                    this.addURLArgument(stringBuffer, DownloadProtocol.ARG_PLATFORM_VERSION_ID, this._version);
                } else {
                    this.addURLArgument(stringBuffer, DownloadProtocol.ARG_VERSION_ID, this._version);
                }
                this.addURLArgument(stringBuffer, DownloadProtocol.ARG_ARCH, Globals.getArchitectureID());
                this.addURLArgument(stringBuffer, DownloadProtocol.ARG_OS, Globals.getOperatingSystemID());
                this.addURLArgument(stringBuffer, DownloadProtocol.ARG_LOCALE, Globals.getLocale().toString());
                if (this._knownPlatforms != null) {
                    this.addURLArgument(stringBuffer, DownloadProtocol.ARG_KNOWN_PLATFORMS, this._knownPlatforms);
                }
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.setLength(stringBuffer.length() - 1);
            }
            if (stringBuffer.length() > 0) {
                stringBuffer.insert(0, '?');
            }
            try {
                return new URL(this._location.getProtocol(), this._location.getHost(), this._location.getPort(), this._location.getFile() + stringBuffer);
            }
            catch (MalformedURLException malformedURLException) {
                Debug.shouldNotReachHere();
                return null;
            }
        }

        private void addURLArgument(StringBuffer stringBuffer, String string, String string2) {
            stringBuffer.append(URLEncoder.encode(string));
            stringBuffer.append('=');
            stringBuffer.append(URLEncoder.encode(string2));
            stringBuffer.append('&');
        }

        public DownloadInfo(URL uRL, String string, boolean bl, String string2, boolean bl2) {
            this._location = uRL;
            this._version = string;
            this._kind = 4;
            this._isCacheOk = bl;
            this._knownPlatforms = string2;
            this._isPlatformVersion = bl2;
        }
    }

    private static class DownloadSizeAction
    implements DownloadAction {
        private long _result = -1L;

        public long getResult() {
            return this._result;
        }

        private DownloadSizeAction() {
        }

        public boolean skipDownloadStep() {
            return false;
        }

        public boolean useHeadRequest() {
            return true;
        }

        public void actionInCache(DiskCacheEntry diskCacheEntry) throws IOException, JNLPException {
            this._result = 0L;
        }

        public void actionOffline(DiskCacheEntry diskCacheEntry, boolean bl) throws IOException, JNLPException {
            this._result = bl ? 0L : -1L;
        }

        DownloadSizeAction(1 var1_1) {
            this();
        }

        public void actionDownload(DiskCacheEntry diskCacheEntry, DownloadInfo downloadInfo, long l, int n, String string, String string2, HttpResponse httpResponse) throws IOException, JNLPException {
            this._result = n;
        }
    }

    private static class IsInCacheAction
    implements DownloadAction {
        private DiskCacheEntry _dce = null;

        private IsInCacheAction() {
        }

        public boolean skipDownloadStep() {
            return true;
        }

        public boolean useHeadRequest() {
            return false;
        }

        public DiskCacheEntry getResult() {
            return this._dce;
        }

        public void actionInCache(DiskCacheEntry diskCacheEntry) throws IOException, JNLPException {
            this._dce = diskCacheEntry;
        }

        public void actionOffline(DiskCacheEntry diskCacheEntry, boolean bl) throws IOException, JNLPException {
            this._dce = bl ? diskCacheEntry : null;
        }

        IsInCacheAction(1 var1_1) {
            this();
        }

        public void actionDownload(DiskCacheEntry diskCacheEntry, DownloadInfo downloadInfo, long l, int n, String string, String string2, HttpResponse httpResponse) throws IOException, JNLPException {
            Debug.shouldNotReachHere();
        }
    }

    private static class RetrieveAction
    implements DownloadAction {
        private DiskCacheEntry _result = null;
        private DownloadDelegate _delegate = null;

        public boolean skipDownloadStep() {
            return false;
        }

        public boolean useHeadRequest() {
            return false;
        }

        public DiskCacheEntry getResult() {
            return this._result;
        }

        public void actionInCache(DiskCacheEntry diskCacheEntry) throws IOException, JNLPException {
            this._result = diskCacheEntry;
        }

        public void actionOffline(DiskCacheEntry diskCacheEntry, boolean bl) throws IOException, JNLPException {
            this._result = bl ? diskCacheEntry : null;
        }

        public RetrieveAction(DownloadDelegate downloadDelegate) {
            this._delegate = downloadDelegate;
        }

        static DownloadDelegate access$000(RetrieveAction retrieveAction) {
            return retrieveAction._delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionDownload(DiskCacheEntry diskCacheEntry, DownloadInfo downloadInfo, long l, int n, String string, String string2, HttpResponse httpResponse) throws IOException, JNLPException {
            String string3;
            URL uRL;
            block15: {
                File file;
                block14: {
                    uRL = downloadInfo.getLocation();
                    boolean bl = string2.equalsIgnoreCase(DownloadProtocol.JARDIFF_MIME_TYPE);
                    String string4 = downloadInfo.getVersion();
                    String string5 = string3 = string4 != null ? string : null;
                    if (Globals.TraceDownload) {
                        Debug.println("Doing download");
                    }
                    HttpDownloadListener httpDownloadListener = this._delegate == null ? null : new HttpDownloadListener(this, uRL, string, bl){
                        private final URL val$location;
                        private final String val$responseVersion;
                        private final boolean val$willPatch;
                        private final RetrieveAction this$0;

                        public boolean downloadProgress(int n, int n2) {
                            RetrieveAction.access$000(this.this$0).downloading(this.val$location, this.val$responseVersion, n, n2, this.val$willPatch);
                            return true;
                        }
                        {
                            this.this$0 = retrieveAction;
                            this.val$location = uRL;
                            this.val$responseVersion = string;
                            this.val$willPatch = bl;
                        }
                    };
                    file = null;
                    try {
                        file = DownloadProtocol.access$100().getTempCacheFile(uRL, string3);
                        JavawsFactory.getHttpDownloadImpl().download(httpResponse, file, httpDownloadListener, downloadInfo.getKind());
                    }
                    catch (IOException iOException) {
                        if (Globals.TraceDownload) {
                            Debug.println("Got exception while downloading resource: " + iOException);
                        }
                        if (this._delegate != null) {
                            this._delegate.downloadFailed(uRL, string);
                        }
                        throw new FailedDownloadingResourceException(uRL, string, iOException);
                    }
                    catch (CanceledDownloadException canceledDownloadException) {
                        Debug.shouldNotReachHere();
                    }
                    if (bl) {
                        file = DownloadProtocol.access$200(diskCacheEntry.getFile(), file, uRL, string, this._delegate);
                    }
                    if (downloadInfo.getKind() != 3 && downloadInfo.getKind() != 4 && downloadInfo.getKind() != 2) break block14;
                    DownloadProtocol.access$100().insertEntry(downloadInfo.getDiskCacheType(), uRL, string3, file, l);
                    file = null;
                    break block15;
                }
                if (downloadInfo.getKind() == 0 || downloadInfo.getKind() == 1) {
                    block13: {
                        File file2 = downloadInfo.getKind() == 1 ? DownloadProtocol.access$300().createNativeLibDir(uRL, string3) : null;
                        JarFile jarFile = new JarFile(file);
                        try {
                            Certificate[] certificateArray = SigningInfo.checkSigning(uRL, string3, jarFile, this._delegate, file2);
                            jarFile.close();
                            jarFile = null;
                            DownloadProtocol.access$100().insertEntry(downloadInfo.getDiskCacheType(), uRL, string3, file, l);
                            file = null;
                            DownloadProtocol.access$100().putCertificateChain('R', uRL, string3, certificateArray);
                            Object var19_19 = null;
                            if (jarFile == null) break block13;
                        }
                        catch (Throwable throwable) {
                            Object var19_20 = null;
                            if (jarFile != null) {
                                jarFile.close();
                            }
                            if (file != null) {
                                file.delete();
                            }
                            throw throwable;
                        }
                        jarFile.close();
                    }
                    if (file != null) {
                        file.delete();
                    }
                }
            }
            this._result = DownloadProtocol.access$300().getCacheEntry(downloadInfo.getDiskCacheType(), uRL, string3);
        }
    }

    private static class UpdateAvailableAction
    implements DownloadAction {
        private boolean _result = false;

        private UpdateAvailableAction() {
        }

        public boolean getResult() {
            return this._result;
        }

        public boolean skipDownloadStep() {
            return false;
        }

        public boolean useHeadRequest() {
            return true;
        }

        public void actionInCache(DiskCacheEntry diskCacheEntry) throws IOException, JNLPException {
            this._result = false;
        }

        public void actionOffline(DiskCacheEntry diskCacheEntry, boolean bl) throws IOException, JNLPException {
            this._result = false;
        }

        UpdateAvailableAction(1 var1_1) {
            this();
        }

        public void actionDownload(DiskCacheEntry diskCacheEntry, DownloadInfo downloadInfo, long l, int n, String string, String string2, HttpResponse httpResponse) throws IOException, JNLPException {
            this._result = true;
        }
    }
}

