/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.javaws.Resources;
import com.sun.javaws.debug.Debug;
import com.sun.jnlp.CheckServicePermission;
import com.sun.jnlp.SmartSecurityDialog;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jnlp.PrintService;

public final class PrintServiceImpl
implements PrintService {
    private static PrintServiceImpl _sharedInstance = null;
    private PrinterJob _sysPrinterJob;
    private SmartSecurityDialog _securityDialog = new SmartSecurityDialog(Resources.getString("APIImpl.print.message"));
    private PageFormat _pageFormat = null;

    private PrintServiceImpl() {
        this._sysPrinterJob = PrinterJob.getPrinterJob();
    }

    private synchronized boolean askUser() {
        if (CheckServicePermission.hasPrintAccessPermissions()) {
            return true;
        }
        return this._securityDialog.showDialog();
    }

    public static synchronized PrintServiceImpl getInstance() {
        if (_sharedInstance == null) {
            _sharedInstance = new PrintServiceImpl();
        }
        return _sharedInstance;
    }

    public PageFormat getDefaultPage() {
        if (this._sysPrinterJob != null) {
            return (PageFormat)AccessController.doPrivileged(new PrivilegedAction(this){
                private final PrintServiceImpl this$0;
                {
                    this.this$0 = printServiceImpl;
                }

                public Object run() {
                    return PrintServiceImpl.access$000(this.this$0).defaultPage();
                }
            });
        }
        return null;
    }

    public synchronized boolean print(Pageable pageable) {
        return this.doPrinting(null, pageable);
    }

    public synchronized boolean print(Printable printable) {
        return this.doPrinting(printable, null);
    }

    static PageFormat access$100(PrintServiceImpl printServiceImpl) {
        return printServiceImpl._pageFormat;
    }

    public PageFormat showPageFormatDialog(PageFormat pageFormat) {
        if (this._sysPrinterJob != null) {
            return (PageFormat)AccessController.doPrivileged(new PrivilegedAction(this, pageFormat){
                private final PageFormat val$page;
                private final PrintServiceImpl this$0;

                public Object run() {
                    PrintServiceImpl.access$102(this.this$0, PrintServiceImpl.access$000(this.this$0).pageDialog(this.val$page));
                    return PrintServiceImpl.access$100(this.this$0);
                }
                {
                    this.this$0 = printServiceImpl;
                    this.val$page = pageFormat;
                }
            });
        }
        return null;
    }

    private boolean doPrinting(Printable printable, Pageable pageable) {
        if (!this.askUser()) {
            return false;
        }
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(this, pageable, printable){
            private final Pageable val$document;
            private final Printable val$painter;
            private final PrintServiceImpl this$0;

            public Object run() {
                if (this.val$document != null) {
                    PrintServiceImpl.access$000(this.this$0).setPageable(this.val$document);
                } else if (PrintServiceImpl.access$100(this.this$0) == null) {
                    PrintServiceImpl.access$000(this.this$0).setPrintable(this.val$painter);
                } else {
                    PrintServiceImpl.access$000(this.this$0).setPrintable(this.val$painter, PrintServiceImpl.access$100(this.this$0));
                }
                if (PrintServiceImpl.access$000(this.this$0).printDialog()) {
                    Thread thread = new Thread(new Runnable(this){
                        private final 3 this$1;

                        public void run() {
                            try {
                                PrintServiceImpl.access$000(3.access$200(this.this$1)).print();
                            }
                            catch (PrinterException printerException) {
                                Debug.ignoredException(printerException);
                            }
                        }
                        {
                            this.this$1 = var1_1;
                        }
                    });
                    thread.start();
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }

            static PrintServiceImpl access$200(3 var0) {
                return var0.this$0;
            }
            {
                this.this$0 = printServiceImpl;
                this.val$document = pageable;
                this.val$painter = printable;
            }
        });
        return bl;
    }

    static PrinterJob access$000(PrintServiceImpl printServiceImpl) {
        return printServiceImpl._sysPrinterJob;
    }

    static PageFormat access$102(PrintServiceImpl printServiceImpl, PageFormat pageFormat) {
        printServiceImpl._pageFormat = pageFormat;
        return printServiceImpl._pageFormat;
    }
}

