/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.dns.DnsClient;
import com.sun.jndi.dns.DnsName;
import com.sun.jndi.dns.ResourceRecord;
import com.sun.jndi.dns.ResourceRecords;
import javax.naming.CommunicationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

class Resolver {
    private DnsClient dnsClient;
    private int timeout;
    private int retries;

    public void close() {
        this.dnsClient.close();
        this.dnsClient = null;
    }

    Resolver(String[] stringArray, int n2, int n3) throws NamingException {
        this.timeout = n2;
        this.retries = n3;
        this.dnsClient = new DnsClient(stringArray, n2, n3);
    }

    DnsName findZoneName(DnsName dnsName, int n2, boolean bl2) throws NamingException {
        dnsName = (DnsName)dnsName.clone();
        while (dnsName.size() > 1) {
            ResourceRecords resourceRecords = null;
            try {
                resourceRecords = this.query(dnsName, n2, 6, bl2, false);
            }
            catch (NameNotFoundException nameNotFoundException) {
                throw nameNotFoundException;
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            if (resourceRecords != null) {
                if (resourceRecords.answer.size() > 0) {
                    return dnsName;
                }
                for (int i2 = 0; i2 < resourceRecords.authority.size(); ++i2) {
                    DnsName dnsName2;
                    ResourceRecord resourceRecord = (ResourceRecord)resourceRecords.authority.elementAt(i2);
                    if (resourceRecord.getType() != 6 || !dnsName.endsWith(dnsName2 = resourceRecord.getName())) continue;
                    return dnsName2;
                }
            }
            dnsName.remove(dnsName.size() - 1);
        }
        return dnsName;
    }

    ResourceRecord findSoa(DnsName dnsName, int n2, boolean bl2) throws NamingException {
        ResourceRecords resourceRecords = this.query(dnsName, n2, 6, bl2, false);
        for (int i2 = 0; i2 < resourceRecords.answer.size(); ++i2) {
            ResourceRecord resourceRecord = (ResourceRecord)resourceRecords.answer.elementAt(i2);
            if (resourceRecord.getType() != 6) continue;
            return resourceRecord;
        }
        return null;
    }

    ResourceRecords query(DnsName dnsName, int n2, int n3, boolean bl2, boolean bl3) throws NamingException {
        return this.dnsClient.query(dnsName, n2, n3, bl2, bl3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResourceRecords queryZone(DnsName dnsName, int n2, boolean bl2) throws NamingException {
        DnsClient dnsClient = new DnsClient(this.findNameServers(dnsName, bl2), this.timeout, this.retries);
        try {
            ResourceRecords resourceRecords = dnsClient.queryZone(dnsName, n2, bl2);
            return resourceRecords;
        }
        finally {
            dnsClient.close();
        }
    }

    private String[] findNameServers(DnsName dnsName, boolean bl2) throws NamingException {
        ResourceRecords resourceRecords = this.query(dnsName, 1, 2, bl2, false);
        String[] stringArray = new String[resourceRecords.answer.size()];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            ResourceRecord resourceRecord = (ResourceRecord)resourceRecords.answer.elementAt(i2);
            if (resourceRecord.getType() != 2) {
                throw new CommunicationException("Corrupted DNS message");
            }
            stringArray[i2] = (String)resourceRecord.getRdata();
            stringArray[i2] = stringArray[i2].substring(0, stringArray[i2].length() - 1);
        }
        return stringArray;
    }
}

