/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import java.util.PropertyPermission;
import sun.misc.VM;
import sun.misc.Version;
import sun.net.InetAddressCachePolicy;
import sun.reflect.Reflection;
import sun.security.util.SecurityConstants;

public final class System {
    public static final InputStream in;
    public static final PrintStream out;
    public static final PrintStream err;
    private static SecurityManager security;
    private static Properties props;

    public static native long currentTimeMillis();

    static {
        System.registerNatives();
        in = System.nullInputStream();
        out = System.nullPrintStream();
        err = System.nullPrintStream();
        security = null;
    }

    private System() {
    }

    private static void checkIO() {
        if (security != null) {
            security.checkPermission(new RuntimePermission("setIO"));
        }
    }

    public static void gc() {
        Runtime.getRuntime().gc();
    }

    private static void initializeSystemClass() {
        props = new Properties();
        System.initProperties(props);
        Version.init();
        FileInputStream fileInputStream = new FileInputStream(FileDescriptor.in);
        FileOutputStream fileOutputStream = new FileOutputStream(FileDescriptor.out);
        FileOutputStream fileOutputStream2 = new FileOutputStream(FileDescriptor.err);
        System.setIn0(new BufferedInputStream(fileInputStream));
        System.setOut0(new PrintStream(new BufferedOutputStream(fileOutputStream, 128), true));
        System.setErr0(new PrintStream(new BufferedOutputStream(fileOutputStream2, 128), true));
        System.loadLibrary("zip");
        Terminator.setup();
        VM.maxDirectMemory();
        VM.booted();
    }

    private static native void registerNatives();

    public static void runFinalization() {
        Runtime.getRuntime().runFinalization();
    }

    public static void exit(int n2) {
        Runtime.getRuntime().exit(n2);
    }

    public static void runFinalizersOnExit(boolean bl2) {
        Runtime.getRuntime();
        Runtime.runFinalizersOnExit(bl2);
    }

    private static InputStream nullInputStream() throws NullPointerException {
        if (System.currentTimeMillis() > 0L) {
            return null;
        }
        throw new NullPointerException();
    }

    public static void setIn(InputStream inputStream) {
        System.checkIO();
        System.setIn0(inputStream);
    }

    private static native void setIn0(InputStream var0);

    private static PrintStream nullPrintStream() throws NullPointerException {
        if (System.currentTimeMillis() > 0L) {
            return null;
        }
        throw new NullPointerException();
    }

    public static void setErr(PrintStream printStream) {
        System.checkIO();
        System.setErr0(printStream);
    }

    private static native void setErr0(PrintStream var0);

    public static void setOut(PrintStream printStream) {
        System.checkIO();
        System.setOut0(printStream);
    }

    private static native void setOut0(PrintStream var0);

    static Class getCallerClass() {
        return Reflection.getCallerClass(3);
    }

    public static native int identityHashCode(Object var0);

    public static SecurityManager getSecurityManager() {
        return security;
    }

    public static void setSecurityManager(SecurityManager securityManager) {
        try {
            securityManager.checkPackageAccess("java.lang");
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.setSecurityManager0(securityManager);
    }

    private static synchronized void setSecurityManager0(SecurityManager securityManager) {
        if (security != null) {
            security.checkPermission(new RuntimePermission("setSecurityManager"));
        }
        if (securityManager != null && securityManager.getClass().getClassLoader() != null) {
            AccessController.doPrivileged(new PrivilegedAction(securityManager){
                private final SecurityManager val$s;

                public Object run() {
                    this.val$s.getClass().getProtectionDomain().implies(SecurityConstants.ALL_PERMISSION);
                    return null;
                }
                {
                    this.val$s = securityManager;
                }
            });
        }
        security = securityManager;
        InetAddressCachePolicy.setIfNotSet(-1);
    }

    public static void load(String string) {
        Runtime.getRuntime().load0(System.getCallerClass(), string);
    }

    public static void loadLibrary(String string) {
        Runtime.getRuntime().loadLibrary0(System.getCallerClass(), string);
    }

    public static Properties getProperties() {
        if (security != null) {
            security.checkPropertiesAccess();
        }
        return props;
    }

    public static void setProperties(Properties properties) {
        if (security != null) {
            security.checkPropertiesAccess();
        }
        if (properties == null) {
            properties = new Properties();
            System.initProperties(properties);
        }
        props = properties;
    }

    public static native void arraycopy(Object var0, int var1, Object var2, int var3, int var4);

    public static String getProperty(String string) {
        if (string == null) {
            throw new NullPointerException("key can't be null");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("key can't be empty");
        }
        if (security != null) {
            security.checkPropertyAccess(string);
        }
        return props.getProperty(string);
    }

    public static String getenv(String string) {
        throw new Error("getenv no longer supported, use properties and -D instead: " + string);
    }

    public static native String mapLibraryName(String var0);

    private static native Properties initProperties(Properties var0);

    public static String getProperty(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("key can't be null");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("key can't be empty");
        }
        if (security != null) {
            security.checkPropertyAccess(string);
        }
        return props.getProperty(string, string2);
    }

    public static String setProperty(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("key can't be null");
        }
        if (string.equals("")) {
            throw new IllegalArgumentException("key can't be empty");
        }
        if (security != null) {
            security.checkPermission(new PropertyPermission(string, "write"));
        }
        return (String)props.setProperty(string, string2);
    }
}

