/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels.spi;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.Channel;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.InterruptibleChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.nio.ch.Interruptible;

public abstract class AbstractInterruptibleChannel
implements Channel,
InterruptibleChannel {
    private Object closeLock = new Object();
    private volatile boolean open = true;
    private Interruptible interruptor;
    private volatile boolean interrupted = false;
    private static Method blockedOnMethod = null;
    static Class class$sun$nio$ch$Interruptible;

    static {
        FooChannel fooChannel = new FooChannel(null);
        fooChannel.begin();
        try {
            fooChannel.end(true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected AbstractInterruptibleChannel() {
    }

    protected final void begin() {
        if (this.interruptor == null) {
            this.interruptor = new Interruptible(this){
                private final AbstractInterruptibleChannel this$0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void interrupt() {
                    Object object = AbstractInterruptibleChannel.access$000(this.this$0);
                    synchronized (object) {
                        if (!AbstractInterruptibleChannel.access$100(this.this$0)) {
                            return;
                        }
                        AbstractInterruptibleChannel.access$202(this.this$0, true);
                        AbstractInterruptibleChannel.access$102(this.this$0, false);
                        try {
                            this.this$0.implCloseChannel();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                {
                    this.this$0 = abstractInterruptibleChannel;
                }
            };
        }
        AbstractInterruptibleChannel.blockedOn(this.interruptor);
        if (Thread.currentThread().isInterrupted()) {
            this.interruptor.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (!this.open) {
                return;
            }
            this.open = false;
            this.implCloseChannel();
        }
    }

    protected abstract void implCloseChannel() throws IOException;

    private static void initBlockedOn() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    Class clazz = Class.forName("java.lang.Thread");
                    AbstractInterruptibleChannel.access$302(clazz.getDeclaredMethod("blockedOn", new Class[]{class$sun$nio$ch$Interruptible == null ? (class$sun$nio$ch$Interruptible = AbstractInterruptibleChannel.class$("sun.nio.ch.Interruptible")) : class$sun$nio$ch$Interruptible}));
                    AbstractInterruptibleChannel.access$300().setAccessible(true);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new Error(classNotFoundException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new Error(noSuchMethodException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new Error(illegalArgumentException);
                }
                catch (ClassCastException classCastException) {
                    throw new Error(classCastException);
                }
                return null;
            }
        });
    }

    public final boolean isOpen() {
        return this.open;
    }

    protected final void end(boolean bl2) throws AsynchronousCloseException {
        AbstractInterruptibleChannel.blockedOn(null);
        if (bl2) {
            this.interrupted = false;
            return;
        }
        if (this.interrupted) {
            throw new ClosedByInterruptException();
        }
        if (!this.open) {
            throw new AsynchronousCloseException();
        }
    }

    static Method access$300() {
        return blockedOnMethod;
    }

    static boolean access$100(AbstractInterruptibleChannel abstractInterruptibleChannel) {
        return abstractInterruptibleChannel.open;
    }

    static boolean access$102(AbstractInterruptibleChannel abstractInterruptibleChannel, boolean bl2) {
        abstractInterruptibleChannel.open = bl2;
        return abstractInterruptibleChannel.open;
    }

    static boolean access$202(AbstractInterruptibleChannel abstractInterruptibleChannel, boolean bl2) {
        abstractInterruptibleChannel.interrupted = bl2;
        return abstractInterruptibleChannel.interrupted;
    }

    static void blockedOn(Interruptible interruptible) {
        if (blockedOnMethod == null) {
            AbstractInterruptibleChannel.initBlockedOn();
        }
        try {
            blockedOnMethod.invoke(Thread.currentThread(), new Object[]{interruptible});
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error(illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new Error(illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new Error(invocationTargetException);
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static Object access$000(AbstractInterruptibleChannel abstractInterruptibleChannel) {
        return abstractInterruptibleChannel.closeLock;
    }

    static Method access$302(Method method) {
        blockedOnMethod = method;
        return blockedOnMethod;
    }

    private static class FooChannel
    extends AbstractInterruptibleChannel {
        private FooChannel() {
        }

        protected void implCloseChannel() {
        }

        FooChannel(1 var1_1) {
            this();
        }
    }
}

