/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.beans.PropertyVetoException;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultDesktopManager;
import javax.swing.DesktopManager;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SortingFocusTraversalPolicy;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.DesktopPaneUI;
import javax.swing.plaf.UIResource;
import sun.awt.AppContext;

public class BasicDesktopPaneUI
extends DesktopPaneUI {
    private static final Object FRAMES_CACHE_KEY = new StringBuffer("BASIC_DESKTOP_PANE_UI.FRAMES_CACHE");
    private static Dimension minSize = new Dimension(0, 0);
    private static Dimension maxSize = new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected JDesktopPane desktop;
    protected DesktopManager desktopManager;
    protected KeyStroke minimizeKey;
    protected KeyStroke maximizeKey;
    protected KeyStroke closeKey;
    protected KeyStroke navigateKey;
    protected KeyStroke navigateKey2;
    private NavigateAction nextAction;
    private boolean moving = false;
    private boolean resizing = false;
    private final int MOVE_RESIZE_INCREMENT = 10;
    static Class class$javax$swing$plaf$basic$BasicDesktopPaneUI;

    protected void installDefaults() {
        if (this.desktop.getBackground() == null || this.desktop.getBackground() instanceof UIResource) {
            this.desktop.setBackground(UIManager.getColor("Desktop.background"));
        }
    }

    protected void installDesktopManager() {
        if (this.desktop.getDesktopManager() == null) {
            this.desktopManager = new DefaultDesktopManager();
            this.desktop.setDesktopManager(this.desktopManager);
        }
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(2);
        if (inputMap != null) {
            SwingUtilities.replaceUIInputMap(this.desktop, 2, inputMap);
        }
        if ((inputMap = this.getInputMap(1)) != null) {
            SwingUtilities.replaceUIInputMap(this.desktop, 1, inputMap);
        }
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this.desktop, actionMap);
        this.registerKeyboardActions();
    }

    protected void registerKeyboardActions() {
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallDesktopManager() {
        if (this.desktop.getDesktopManager() == this.desktopManager) {
            this.desktop.setDesktopManager(null);
        }
        this.desktopManager = null;
    }

    protected void uninstallKeyboardActions() {
        this.unregisterKeyboardActions();
        SwingUtilities.replaceUIInputMap(this.desktop, 2, null);
        SwingUtilities.replaceUIInputMap(this.desktop, 1, null);
        SwingUtilities.replaceUIActionMap(this.desktop, null);
    }

    protected void unregisterKeyboardActions() {
    }

    private void verifyFramesCache() {
        Vector vector = BasicDesktopPaneUI.getCurrentFramesCache();
        boolean bl2 = false;
        int n2 = vector.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            JInternalFrame jInternalFrame;
            JComponent jComponent;
            JComponent jComponent2 = (JComponent)vector.elementAt(i2);
            if (jComponent2 instanceof JInternalFrame) {
                jComponent = (JInternalFrame)jComponent2;
                if (!((JInternalFrame)jComponent).isClosed()) continue;
                bl2 = true;
                break;
            }
            if (!(jComponent2 instanceof JInternalFrame.JDesktopIcon) || !(jInternalFrame = ((JInternalFrame.JDesktopIcon)(jComponent = (JInternalFrame.JDesktopIcon)jComponent2)).getInternalFrame()).isClosed()) continue;
            bl2 = true;
            break;
        }
        JInternalFrame[] jInternalFrameArray = this.desktop.getAllFrames();
        if (bl2 || jInternalFrameArray.length != vector.size()) {
            int n3;
            vector.clear();
            int n4 = this.desktop.lowestLayer();
            for (int i3 = n3 = this.desktop.highestLayer(); i3 >= n4; --i3) {
                Component[] componentArray = this.desktop.getComponentsInLayer(i3);
                if (componentArray.length <= 0) continue;
                for (int i4 = 0; i4 < componentArray.length; ++i4) {
                    vector.addElement(componentArray[i4]);
                }
            }
        }
    }

    static Vector access$300() {
        return BasicDesktopPaneUI.getCurrentFramesCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vector getCurrentFramesCache() {
        Class clazz = class$javax$swing$plaf$basic$BasicDesktopPaneUI == null ? (class$javax$swing$plaf$basic$BasicDesktopPaneUI = BasicDesktopPaneUI.class$("javax.swing.plaf.basic.BasicDesktopPaneUI")) : class$javax$swing$plaf$basic$BasicDesktopPaneUI;
        synchronized (clazz) {
            AppContext appContext = AppContext.getAppContext();
            Vector vector = (Vector)appContext.get(FRAMES_CACHE_KEY);
            if (vector == null) {
                vector = new Vector();
                appContext.put(FRAMES_CACHE_KEY, vector);
            }
            return vector;
        }
    }

    ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        actionMapUIResource.put("restore", new OpenAction(this));
        actionMapUIResource.put("close", new CloseAction(this));
        actionMapUIResource.put("move", new MoveResizeAction(this, "move"));
        actionMapUIResource.put("resize", new MoveResizeAction(this, "resize"));
        actionMapUIResource.put("left", new MoveResizeAction(this, "left"));
        actionMapUIResource.put("shrinkLeft", new MoveResizeAction(this, "shrinkLeft"));
        actionMapUIResource.put("right", new MoveResizeAction(this, "right"));
        actionMapUIResource.put("shrinkRight", new MoveResizeAction(this, "shrinkRight"));
        actionMapUIResource.put("up", new MoveResizeAction(this, "up"));
        actionMapUIResource.put("shrinkUp", new MoveResizeAction(this, "shrinkUp"));
        actionMapUIResource.put("down", new MoveResizeAction(this, "down"));
        actionMapUIResource.put("shrinkDown", new MoveResizeAction(this, "shrinkDown"));
        actionMapUIResource.put("escape", new MoveResizeAction(this, "escape"));
        actionMapUIResource.put("minimize", new MinimizeAction(this));
        actionMapUIResource.put("maximize", new MaximizeAction(this));
        this.nextAction = new NavigateAction(this);
        actionMapUIResource.put("selectNextFrame", this.nextAction);
        actionMapUIResource.put("selectPreviousFrame", new PreviousAction(this, null));
        actionMapUIResource.put("navigateNext", new NavigateOutAction(this, true));
        actionMapUIResource.put("navigatePrevious", new NavigateOutAction(this, false));
        return actionMapUIResource;
    }

    ActionMap getActionMap() {
        return this.createActionMap();
    }

    InputMap createInputMap(int n2) {
        Object[] objectArray;
        if (n2 == 2 && (objectArray = (Object[])UIManager.get("Desktop.windowBindings")) != null) {
            return LookAndFeel.makeComponentInputMap(this.desktop, objectArray);
        }
        return null;
    }

    InputMap getInputMap(int n2) {
        if (n2 == 2) {
            return this.createInputMap(n2);
        }
        if (n2 == 1) {
            return (InputMap)UIManager.get("Desktop.ancestorInputMap");
        }
        return null;
    }

    public void installUI(JComponent jComponent) {
        this.desktop = (JDesktopPane)jComponent;
        this.installDefaults();
        this.installDesktopManager();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallKeyboardActions();
        this.uninstallDesktopManager();
        this.uninstallDefaults();
        this.desktop = null;
    }

    static void access$400(BasicDesktopPaneUI basicDesktopPaneUI) {
        basicDesktopPaneUI.verifyFramesCache();
    }

    static boolean access$100(BasicDesktopPaneUI basicDesktopPaneUI) {
        return basicDesktopPaneUI.moving;
    }

    static boolean access$200(BasicDesktopPaneUI basicDesktopPaneUI) {
        return basicDesktopPaneUI.resizing;
    }

    static boolean access$102(BasicDesktopPaneUI basicDesktopPaneUI, boolean bl2) {
        basicDesktopPaneUI.moving = bl2;
        return basicDesktopPaneUI.moving;
    }

    static boolean access$202(BasicDesktopPaneUI basicDesktopPaneUI, boolean bl2) {
        basicDesktopPaneUI.resizing = bl2;
        return basicDesktopPaneUI.resizing;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return maxSize;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return minSize;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicDesktopPaneUI();
    }

    static class 1 {
    }

    protected class CloseAction
    extends AbstractAction {
        private final BasicDesktopPaneUI this$0;

        public boolean isEnabled() {
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = this.this$0.desktop.getSelectedFrame();
            if (jInternalFrame == null) {
                return;
            }
            if (jInternalFrame.isClosable()) {
                try {
                    jInternalFrame.setClosed(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        protected CloseAction(BasicDesktopPaneUI basicDesktopPaneUI) {
            this.this$0 = basicDesktopPaneUI;
        }
    }

    protected class MaximizeAction
    extends AbstractAction {
        private final BasicDesktopPaneUI this$0;

        public boolean isEnabled() {
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = this.this$0.desktop.getSelectedFrame();
            if (jInternalFrame == null) {
                return;
            }
            if (jInternalFrame.isMaximizable() && !jInternalFrame.isMaximum()) {
                if (jInternalFrame.isIcon()) {
                    try {
                        jInternalFrame.setIcon(false);
                        jInternalFrame.setMaximum(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else {
                    try {
                        jInternalFrame.setMaximum(true);
                    }
                    catch (PropertyVetoException propertyVetoException) {
                        // empty catch block
                    }
                }
            }
        }

        protected MaximizeAction(BasicDesktopPaneUI basicDesktopPaneUI) {
            this.this$0 = basicDesktopPaneUI;
        }
    }

    protected class MinimizeAction
    extends AbstractAction {
        private final BasicDesktopPaneUI this$0;

        public boolean isEnabled() {
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = this.this$0.desktop.getSelectedFrame();
            if (jInternalFrame == null) {
                return;
            }
            if (jInternalFrame.isIconifiable() && !jInternalFrame.isIcon()) {
                try {
                    jInternalFrame.setIcon(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        protected MinimizeAction(BasicDesktopPaneUI basicDesktopPaneUI) {
            this.this$0 = basicDesktopPaneUI;
        }
    }

    private class MoveResizeAction
    extends AbstractAction {
        private String command;
        private final BasicDesktopPaneUI this$0;

        public boolean isEnabled() {
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = this.this$0.desktop.getSelectedFrame();
            if (jInternalFrame == null) {
                return;
            }
            if ("move".equals(this.command)) {
                BasicDesktopPaneUI.access$102(this.this$0, true);
                BasicDesktopPaneUI.access$202(this.this$0, false);
                return;
            }
            if ("resize".equals(this.command)) {
                BasicDesktopPaneUI.access$102(this.this$0, false);
                BasicDesktopPaneUI.access$202(this.this$0, true);
                return;
            }
            if ("escape".equals(this.command)) {
                BasicDesktopPaneUI.access$102(this.this$0, BasicDesktopPaneUI.access$202(this.this$0, false));
                return;
            }
            if (!BasicDesktopPaneUI.access$100(this.this$0) && !BasicDesktopPaneUI.access$200(this.this$0)) {
                return;
            }
            Dimension dimension = jInternalFrame.getSize();
            Dimension dimension2 = jInternalFrame.getMinimumSize();
            Point point = jInternalFrame.getLocation();
            if ("left".equals(this.command)) {
                if (BasicDesktopPaneUI.access$100(this.this$0)) {
                    jInternalFrame.setLocation(point.x - 10, point.y);
                } else if (BasicDesktopPaneUI.access$200(this.this$0)) {
                    jInternalFrame.setLocation(point.x - 10, point.y);
                    jInternalFrame.setSize(dimension.width + 10, dimension.height);
                }
            } else if ("right".equals(this.command)) {
                if (BasicDesktopPaneUI.access$100(this.this$0)) {
                    jInternalFrame.setLocation(point.x + 10, point.y);
                } else if (BasicDesktopPaneUI.access$200(this.this$0)) {
                    jInternalFrame.setLocation(point.x, point.y);
                    jInternalFrame.setSize(dimension.width + 10, dimension.height);
                }
            } else if ("up".equals(this.command)) {
                if (BasicDesktopPaneUI.access$100(this.this$0)) {
                    jInternalFrame.setLocation(point.x, point.y - 10);
                } else if (BasicDesktopPaneUI.access$200(this.this$0)) {
                    jInternalFrame.setLocation(point.x, point.y - 10);
                    jInternalFrame.setSize(dimension.width, dimension.height + 10);
                }
            } else if ("down".equals(this.command)) {
                if (BasicDesktopPaneUI.access$100(this.this$0)) {
                    jInternalFrame.setLocation(point.x, point.y + 10);
                } else if (BasicDesktopPaneUI.access$200(this.this$0)) {
                    jInternalFrame.setLocation(point.x, point.y);
                    jInternalFrame.setSize(dimension.width, dimension.height + 10);
                }
            } else if ("shrinkLeft".equals(this.command) && BasicDesktopPaneUI.access$200(this.this$0)) {
                if (dimension2.width < dimension.width - 10) {
                    jInternalFrame.setLocation(point.x, point.y);
                    jInternalFrame.setSize(dimension.width - 10, dimension.height);
                } else {
                    jInternalFrame.setSize(dimension2.width, dimension.height);
                }
            } else if ("shrinkRight".equals(this.command) && BasicDesktopPaneUI.access$200(this.this$0)) {
                if (dimension2.width < dimension.width - 10) {
                    jInternalFrame.setLocation(point.x + 10, point.y);
                    jInternalFrame.setSize(dimension.width - 10, dimension.height);
                } else {
                    jInternalFrame.setLocation(point.x - dimension2.width + dimension.width, point.y);
                    jInternalFrame.setSize(dimension2.width, dimension.height);
                }
            } else if ("shrinkUp".equals(this.command) && BasicDesktopPaneUI.access$200(this.this$0)) {
                if (dimension2.height < dimension.height - 10) {
                    jInternalFrame.setLocation(point.x, point.y);
                    jInternalFrame.setSize(dimension.width, dimension.height - 10);
                } else {
                    jInternalFrame.setSize(dimension.width, dimension2.height);
                }
            } else if ("shrinkDown".equals(this.command) && BasicDesktopPaneUI.access$200(this.this$0)) {
                if (dimension2.height < dimension.height - 10) {
                    jInternalFrame.setLocation(point.x, point.y + 10);
                    jInternalFrame.setSize(dimension.width, dimension.height - 10);
                } else {
                    jInternalFrame.setLocation(point.x, point.y - dimension2.height + dimension.height);
                    jInternalFrame.setSize(dimension.width, dimension2.height);
                }
            }
        }

        public MoveResizeAction(BasicDesktopPaneUI basicDesktopPaneUI, String string) {
            this.this$0 = basicDesktopPaneUI;
            this.command = string;
        }
    }

    protected class NavigateAction
    extends AbstractAction {
        private final BasicDesktopPaneUI this$0;

        public boolean isEnabled() {
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent;
            int n2 = 0;
            Vector vector = BasicDesktopPaneUI.access$300();
            BasicDesktopPaneUI.access$400(this.this$0);
            if (vector.size() == 0) {
                return;
            }
            JInternalFrame jInternalFrame = this.this$0.desktop.getSelectedFrame();
            if (jInternalFrame != null) {
                n2 = vector.indexOf(jInternalFrame);
            }
            if (n2 == -1 && (n2 = vector.indexOf(jInternalFrame.getDesktopIcon())) == -1) {
                return;
            }
            if (++n2 == vector.size()) {
                n2 = 0;
            }
            if ((jComponent = (JComponent)vector.elementAt(n2)) instanceof JInternalFrame) {
                try {
                    ((JInternalFrame)jComponent).setSelected(true);
                    this.this$0.desktopManager.activateFrame((JInternalFrame)jComponent);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else {
                if (!(jComponent instanceof JInternalFrame.JDesktopIcon)) {
                    return;
                }
                try {
                    ((JInternalFrame.JDesktopIcon)jComponent).getInternalFrame().setSelected(true);
                    this.this$0.desktopManager.activateFrame(((JInternalFrame.JDesktopIcon)jComponent).getInternalFrame());
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        protected NavigateAction(BasicDesktopPaneUI basicDesktopPaneUI) {
            this.this$0 = basicDesktopPaneUI;
        }
    }

    private class NavigateOutAction
    extends AbstractAction {
        private boolean moveForward;
        private final BasicDesktopPaneUI this$0;

        public boolean isEnabled() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            FocusTraversalPolicy focusTraversalPolicy;
            Container container = this.this$0.desktop.getFocusCycleRootAncestor();
            if (container != null && (focusTraversalPolicy = container.getFocusTraversalPolicy()) != null && focusTraversalPolicy instanceof SortingFocusTraversalPolicy) {
                SortingFocusTraversalPolicy sortingFocusTraversalPolicy = (SortingFocusTraversalPolicy)focusTraversalPolicy;
                boolean bl2 = sortingFocusTraversalPolicy.getImplicitDownCycleTraversal();
                try {
                    sortingFocusTraversalPolicy.setImplicitDownCycleTraversal(false);
                    if (this.moveForward) {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(this.this$0.desktop);
                    } else {
                        KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent(this.this$0.desktop);
                    }
                }
                finally {
                    sortingFocusTraversalPolicy.setImplicitDownCycleTraversal(bl2);
                }
            }
        }

        public NavigateOutAction(BasicDesktopPaneUI basicDesktopPaneUI, boolean bl2) {
            this.this$0 = basicDesktopPaneUI;
            this.moveForward = bl2;
        }
    }

    protected class OpenAction
    extends AbstractAction {
        private final BasicDesktopPaneUI this$0;

        public boolean isEnabled() {
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JInternalFrame jInternalFrame = this.this$0.desktop.getSelectedFrame();
            if (jInternalFrame == null) {
                return;
            }
            try {
                if (jInternalFrame.isIcon()) {
                    jInternalFrame.setIcon(false);
                } else if (jInternalFrame.isMaximum()) {
                    jInternalFrame.setMaximum(false);
                }
                jInternalFrame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }

        protected OpenAction(BasicDesktopPaneUI basicDesktopPaneUI) {
            this.this$0 = basicDesktopPaneUI;
        }
    }

    private class PreviousAction
    extends AbstractAction {
        private final BasicDesktopPaneUI this$0;

        public boolean isEnabled() {
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent;
            int n2 = 0;
            Vector vector = BasicDesktopPaneUI.access$300();
            BasicDesktopPaneUI.access$400(this.this$0);
            if (vector.size() == 0) {
                return;
            }
            JInternalFrame jInternalFrame = this.this$0.desktop.getSelectedFrame();
            if (jInternalFrame != null) {
                n2 = vector.indexOf(jInternalFrame);
            }
            if (n2 == -1 && (n2 = vector.indexOf(jInternalFrame.getDesktopIcon())) == -1) {
                return;
            }
            if (--n2 == -1) {
                n2 = vector.size() - 1;
            }
            if ((jComponent = (JComponent)vector.elementAt(n2)) instanceof JInternalFrame) {
                try {
                    ((JInternalFrame)jComponent).setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            } else {
                if (!(jComponent instanceof JInternalFrame.JDesktopIcon)) {
                    return;
                }
                try {
                    ((JInternalFrame.JDesktopIcon)jComponent).getInternalFrame().setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }

        private PreviousAction(BasicDesktopPaneUI basicDesktopPaneUI) {
            this.this$0 = basicDesktopPaneUI;
        }

        PreviousAction(BasicDesktopPaneUI basicDesktopPaneUI, 1 var2_2) {
            this(basicDesktopPaneUI);
        }
    }
}

