/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.List;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.TextElementArray;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class Cell
extends Rectangle
implements TextElementArray {
    public static final Cell EMPTY_CELL = new Cell();
    private ArrayList arrayList;
    private int horizontalAlignment;
    private int verticalAlignment;
    private int colspan = 1;
    private int rowspan = 1;
    float leading = -1.0f;
    private boolean header;
    private boolean noWrap;

    public Cell() {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.setBorder(15);
        this.setBorderWidth(0.5f);
        this.arrayList = new ArrayList();
        try {
            this.addElement(new Paragraph(0.0f));
        }
        catch (BadElementException badElementException) {
            // empty catch block
        }
    }

    public Cell(String string) throws BadElementException {
        this(new Paragraph(string));
    }

    public Cell(Element element) throws BadElementException {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.setBorder(15);
        this.setBorderWidth(0.5f);
        this.arrayList = new ArrayList();
        this.addElement(element);
    }

    public final boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public final int type() {
        return 20;
    }

    public final ArrayList getChunks() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = ((AbstractList)this.arrayList).iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(((Element)iterator.next()).getChunks());
        }
        return arrayList;
    }

    public final void addElement(Element element) throws BadElementException {
        switch (element.type()) {
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 31: 
            case 32: 
            case 33: {
                throw new BadElementException("You can't add listitems, rows, tables, cells, jpgs, gifs or pngs to a cell.");
            }
            case 11: 
            case 12: {
                if (this.leading < 0.0f) {
                    this.leading = ((Phrase)element).leading();
                }
            }
            case 14: {
                if (!(this.leading < 0.0f)) break;
                this.leading = ((List)element).leading();
            }
        }
        this.arrayList.add(element);
    }

    public boolean add(Object object) {
        try {
            this.addElement((Element)object);
            return true;
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException("You can only add objects that implement the Element interface.");
        }
        catch (BadElementException badElementException) {
            throw new ClassCastException(badElementException.getMessage());
        }
    }

    public final void setLeading(float f) {
        this.leading = f;
    }

    public final void setHorizontalAlignment(int n) {
        this.horizontalAlignment = n;
    }

    public final void setVerticalAlignment(int n) {
        this.verticalAlignment = n;
    }

    public final void setColspan(int n) {
        this.colspan = n;
    }

    public final void setRowspan(int n) {
        this.rowspan = n;
    }

    public final void setHeader(boolean bl) {
        this.header = bl;
    }

    public final void setNoWrap(boolean bl) {
        this.noWrap = bl;
    }

    public final int size() {
        return this.arrayList.size();
    }

    public final boolean isEmpty() {
        switch (this.size()) {
            case 0: {
                return true;
            }
            case 1: {
                Element element = (Element)this.arrayList.get(0);
                switch (element.type()) {
                    case 10: {
                        return ((Chunk)element).isEmpty();
                    }
                    case 11: 
                    case 12: {
                        return ((Phrase)element).isEmpty();
                    }
                }
                return false;
            }
        }
        return false;
    }

    public final Iterator getElements() {
        return ((AbstractList)this.arrayList).iterator();
    }

    public final int horizontalAlignment() {
        return this.horizontalAlignment;
    }

    public final int verticalAlignment() {
        return this.verticalAlignment;
    }

    public final int colspan() {
        return this.colspan;
    }

    public final int rowspan() {
        return this.rowspan;
    }

    public final float leading() {
        if (this.leading < 0.0f) {
            return 16.0f;
        }
        return this.leading;
    }

    public boolean header() {
        return this.header;
    }

    public boolean noWrap() {
        return this.noWrap;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("\t\t<CELL HEADER=\"");
        stringBuffer.append(this.header);
        stringBuffer.append("\" NOWRAP=\"");
        stringBuffer.append(this.noWrap);
        stringBuffer.append(">\n");
        stringBuffer.append("\n\t\t\t<COLSPAN>");
        stringBuffer.append(this.colspan);
        stringBuffer.append("</COLSPAN>\n");
        stringBuffer.append("\n\t\t\t<ROWSPAN>");
        stringBuffer.append(this.rowspan);
        stringBuffer.append("</ROWSPAN>\n");
        stringBuffer.append("\n\t\t\t<HORIZONTAL_ALIGNMENT>");
        switch (this.horizontalAlignment()) {
            case 0: {
                stringBuffer.append("Left");
                break;
            }
            case 1: {
                stringBuffer.append("Center");
                break;
            }
            case 2: {
                stringBuffer.append("Right");
                break;
            }
            case 3: {
                stringBuffer.append("Justify");
                break;
            }
            default: {
                stringBuffer.append("Default");
            }
        }
        stringBuffer.append("</HORIZONTAL_ALIGNMENT>\n");
        stringBuffer.append("\n\t\t\t<VERTICAL_ALIGNMENT>");
        switch (this.verticalAlignment()) {
            case 4: {
                stringBuffer.append("Top");
                break;
            }
            case 5: {
                stringBuffer.append("Middle");
                break;
            }
            case 6: {
                stringBuffer.append("Bottom");
                break;
            }
            case 7: {
                stringBuffer.append("Baseline");
                break;
            }
            default: {
                stringBuffer.append("Default");
            }
        }
        stringBuffer.append("</VERTICAL_ALIGNMENT>\n");
        if (this.borderWidth > 0.0f && this.border != 0) {
            stringBuffer.append("\t\t\t<BORDER WIDTH=\"");
            stringBuffer.append(this.borderWidth);
            stringBuffer.append("\">");
            if (this.hasBorder(1)) {
                stringBuffer.append("\t\t\t\t<SIDE>");
                stringBuffer.append("top");
                stringBuffer.append("</SIDE>\n");
            }
            if (this.hasBorder(2)) {
                stringBuffer.append("\t\t\t\t<SIDE>");
                stringBuffer.append("bottom");
                stringBuffer.append("</SIDE>\n");
            }
            if (this.hasBorder(4)) {
                stringBuffer.append("\t\t\t\t<SIDE>");
                stringBuffer.append("left");
                stringBuffer.append("</SIDE>\n");
            }
            if (this.hasBorder(8)) {
                stringBuffer.append("\t\t\t\t<SIDE>");
                stringBuffer.append("right");
                stringBuffer.append("</SIDE>\n");
            }
            if (this.color != null) {
                stringBuffer.append("\t\t\t\t<COLOR>\n");
                stringBuffer.append("\t\t\t\t\t<RED>");
                stringBuffer.append(this.color.getRed());
                stringBuffer.append("</RED>\n");
                stringBuffer.append("\t\t\t\t\t<GREEN>");
                stringBuffer.append(this.color.getGreen());
                stringBuffer.append("</GREEN>\n");
                stringBuffer.append("\t\t\t\t\t<BLUE>");
                stringBuffer.append(this.color.getBlue());
                stringBuffer.append("</BLUE>\n");
                stringBuffer.append("\t\t\t\t</COLOR>\n");
            }
            stringBuffer.append("\t\t\t</BORDER>\n");
        }
        Iterator iterator = ((AbstractList)this.arrayList).iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((Element)iterator.next()).toString());
        }
        stringBuffer.append("\n\t\t</CELL>\n");
        return stringBuffer.toString();
    }

    public final void clear() {
        this.arrayList.clear();
    }
}

