/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.PdfAction;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;

public class Chunk
implements Element {
    private StringBuffer content;
    private Font font;
    private HashMap attributes;
    public static final String LINK = "LINK";
    public static final String SUBSUPSCRIPT = "SUBSUPSCRIPT";
    public static final String UNDERLINE = "UNDERLINE";
    public static final String STRIKETHRU = "STRIKETHRU";
    public static final String COLOR = "COLOR";
    public static final String ENCODING = "ENCODING";
    public static final String REMOTEGOTO = "REMOTEGOTO";
    public static final String LOCALGOTO = "LOCALGOTO";
    public static final String LOCALDESTINATION = "LOCALDESTINATION";
    public static final String IMAGE = "IMAGE";
    public static final String GENERICTAG = "GENERICTAG";

    public Chunk(String string, Font font) {
        this.content = new StringBuffer(string);
        this.font = font;
    }

    public Chunk(String string) {
        this(string, new Font());
    }

    public Chunk(Image image, float f, float f2) {
        this("*", new Font());
        this.setAttribute(IMAGE, new Object[]{image, new Float(f), new Float(f2)});
    }

    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public int type() {
        return 10;
    }

    public ArrayList getChunks() {
        ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
        arrayList.add(this);
        return arrayList;
    }

    public StringBuffer append(String string) {
        return this.content.append(string);
    }

    public final Font font() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public final String content() {
        return this.content.toString();
    }

    public final boolean isEmpty() {
        String string = this.content.toString();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (string.charAt(n2) != ' ') {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<chunk");
        stringBuffer.append(this.font.toString());
        stringBuffer.append(">");
        stringBuffer.append("\t");
        stringBuffer.append(this.content());
        stringBuffer.append("\n</chunk>\n");
        return stringBuffer.toString();
    }

    public Chunk setTextRise(float f) {
        return this.setAttribute(SUBSUPSCRIPT, new Float(f));
    }

    public Chunk setAnchor(URL uRL) {
        return this.setAttribute(LINK, new PdfAction(uRL));
    }

    public Chunk setLocalGoto(String string) {
        return this.setAttribute(LOCALGOTO, string);
    }

    public Chunk setRemoteGoto(String string, String string2) {
        return this.setAttribute(REMOTEGOTO, new Object[]{string, string2});
    }

    public Chunk setRemoteGoto(String string, int n) {
        return this.setAttribute(REMOTEGOTO, new Object[]{string, new Integer(n)});
    }

    public Chunk setLocalDestination(String string) {
        return this.setAttribute(LOCALDESTINATION, string);
    }

    public Chunk setGenericTag(String string) {
        return this.setAttribute(GENERICTAG, string);
    }

    private Chunk setAttribute(String string, Object object) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(string, object);
        return this;
    }

    public HashMap getAttributes() {
        return this.attributes;
    }
}

