/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;

public class HeaderFooter
extends Rectangle {
    private boolean numbered;
    private Phrase before = null;
    private int pageN;
    private Phrase after = null;
    private int alignment;

    public HeaderFooter(Phrase phrase, Phrase phrase2) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.setBorder(3);
        this.setBorderWidth(1.0f);
        this.numbered = true;
        this.before = phrase;
        this.after = phrase2;
    }

    public HeaderFooter(Phrase phrase, boolean bl) {
        super(0.0f, 0.0f, 0.0f, 0.0f);
        this.setBorder(3);
        this.setBorderWidth(1.0f);
        this.numbered = bl;
        this.before = phrase;
    }

    public final void setPageNumber(int n) {
        this.pageN = n;
    }

    public final void setAlignment(int n) {
        this.alignment = n;
    }

    public final Paragraph paragraph() {
        Paragraph paragraph = new Paragraph(this.before);
        if (this.numbered) {
            paragraph.add(String.valueOf(this.pageN));
        }
        if (this.after != null) {
            paragraph.add(this.after);
        }
        paragraph.setAlignment(this.alignment);
        return paragraph;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<HEADERFOOTER NUMBERED=\"");
        stringBuffer.append(this.numbered);
        stringBuffer.append("\" ALIGNMENT=\"");
        stringBuffer.append(this.alignment);
        stringBuffer.append("\">\n");
        stringBuffer.append(super.toString());
        stringBuffer.append("\t<BEFORE>\n");
        stringBuffer.append(this.before.toString());
        stringBuffer.append("\t</BEFORE>");
        stringBuffer.append("\t<AFTER>\n");
        if (this.after != null) {
            stringBuffer.append(this.after.toString());
        }
        stringBuffer.append("\t</AFTER>");
        return stringBuffer.toString();
    }
}

