/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.BadElementException;
import com.lowagie.text.Element;
import com.lowagie.text.Gif;
import com.lowagie.text.ImgRaw;
import com.lowagie.text.Jpeg;
import com.lowagie.text.Png;
import com.lowagie.text.Rectangle;
import java.awt.Color;
import java.awt.image.PixelGrabber;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public abstract class Image
extends Rectangle
implements Element {
    public static final int DEFAULT = 0;
    public static final int RIGHT = 1;
    public static final int LEFT = 2;
    public static final int MIDDLE = 3;
    public static final int TEXTWRAP = 4;
    public static final int UNDERLYING = 8;
    public static final int AX = 0;
    public static final int AY = 1;
    public static final int BX = 2;
    public static final int BY = 3;
    public static final int CX = 4;
    public static final int CY = 5;
    public static final int DX = 6;
    public static final int DY = 7;
    protected int type;
    protected URL url;
    protected byte[] rawData;
    protected int alignment;
    protected String alt;
    protected float absoluteX = Float.NaN;
    protected float absoluteY = Float.NaN;
    protected float plainWidth;
    protected float plainHeight;
    protected float scaledWidth;
    protected float scaledHeight;
    protected float rotation;
    protected int colorspace = -1;
    protected int bpc = 1;
    protected int[] transparency;

    public Image(URL uRL) {
        super(0.0f, 0.0f);
        this.url = uRL;
        this.alignment = 0;
        this.rotation = 0.0f;
    }

    protected Image(Image image) {
        super(image);
        this.type = image.type;
        this.url = image.url;
        this.alignment = image.alignment;
        this.alt = image.alt;
        this.absoluteX = image.absoluteX;
        this.absoluteY = image.absoluteY;
        this.plainWidth = image.plainWidth;
        this.plainHeight = image.plainHeight;
        this.scaledWidth = image.scaledWidth;
        this.scaledHeight = image.scaledHeight;
        this.rotation = image.rotation;
        this.colorspace = image.colorspace;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Image getInstance(URL uRL) throws BadElementException, MalformedURLException, IOException {
        Png png;
        InputStream inputStream;
        block6: {
            Jpeg jpeg;
            block5: {
                Gif gif;
                block4: {
                    inputStream = null;
                    try {
                        inputStream = uRL.openStream();
                        int n = inputStream.read();
                        int n2 = inputStream.read();
                        inputStream.close();
                        inputStream = null;
                        if (n == 71 && n2 == 73) {
                            gif = new Gif(uRL);
                            Object var6_7 = null;
                            if (inputStream == null) return gif;
                            break block4;
                        }
                        if (n == 255 && n2 == 216) {
                            jpeg = new Jpeg(uRL);
                            break block5;
                        }
                        if (n != Png.PNGID[0]) throw new IOException(uRL.toString() + " is not a recognized imageformat.");
                        if (n2 != Png.PNGID[1]) throw new IOException(uRL.toString() + " is not a recognized imageformat.");
                        png = new Png(uRL);
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var6_10 = null;
                        if (inputStream == null) throw throwable;
                        inputStream.close();
                        throw throwable;
                    }
                }
                inputStream.close();
                return gif;
            }
            Object var6_8 = null;
            if (inputStream == null) return jpeg;
            inputStream.close();
            return jpeg;
        }
        Object var6_9 = null;
        if (inputStream == null) return png;
        inputStream.close();
        return png;
    }

    public static Image getInstance(java.awt.Image image, Color color) throws BadElementException, IOException {
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, -1, -1, true);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("java.awt.Image Interrupted waiting for pixels!");
        }
        if ((pixelGrabber.getStatus() & 0x80) != 0) {
            throw new IOException("java.awt.Image fetch aborted or errored");
        }
        int n = pixelGrabber.getWidth();
        int n2 = pixelGrabber.getHeight();
        int[] nArray = (int[])pixelGrabber.getPixels();
        byte[] byArray = new byte[n * n2 * 3];
        int n3 = 0;
        int n4 = n2 * n;
        int n5 = 255;
        int n6 = 255;
        int n7 = 255;
        if (color != null) {
            n5 = color.getRed();
            n6 = color.getGreen();
            n7 = color.getBlue();
        }
        int[] nArray2 = null;
        if (color != null) {
            int n8 = 0;
            while (n8 < n4) {
                int n9 = nArray[n8] >> 24 & 0xFF;
                if (n9 < 250) {
                    byArray[n3++] = (byte)n5;
                    byArray[n3++] = (byte)n6;
                    byArray[n3++] = (byte)n7;
                } else {
                    byArray[n3++] = (byte)(nArray[n8] >> 16 & 0xFF);
                    byArray[n3++] = (byte)(nArray[n8] >> 8 & 0xFF);
                    byArray[n3++] = (byte)(nArray[n8] & 0xFF);
                }
                ++n8;
            }
        } else {
            int n10 = 0;
            while (n10 < n4) {
                int n11;
                if (nArray2 == null && (n11 = nArray[n10] >> 24 & 0xFF) == 0) {
                    nArray2 = new int[6];
                    nArray2[0] = nArray2[1] = nArray[n10] >> 16 & 0xFF;
                    nArray2[2] = nArray2[3] = nArray[n10] >> 8 & 0xFF;
                    nArray2[4] = nArray2[5] = nArray[n10] & 0xFF;
                }
                byArray[n3++] = (byte)(nArray[n10] >> 16 & 0xFF);
                byArray[n3++] = (byte)(nArray[n10] >> 8 & 0xFF);
                byArray[n3++] = (byte)(nArray[n10] & 0xFF);
                ++n10;
            }
        }
        return Image.getInstance(n, n2, 3, 8, byArray, nArray2);
    }

    public static Image getInstance(String string) throws BadElementException, MalformedURLException, IOException {
        return Image.getInstance(Image.toURL(string));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Image getInstance(byte[] byArray) throws BadElementException, MalformedURLException, IOException {
        Png png;
        ByteArrayInputStream byteArrayInputStream;
        block6: {
            Jpeg jpeg;
            block5: {
                Gif gif;
                block4: {
                    byteArrayInputStream = null;
                    try {
                        byteArrayInputStream = new ByteArrayInputStream(byArray);
                        int n = ((InputStream)byteArrayInputStream).read();
                        int n2 = ((InputStream)byteArrayInputStream).read();
                        ((InputStream)byteArrayInputStream).close();
                        byteArrayInputStream = null;
                        if (n == 71 && n2 == 73) {
                            gif = new Gif(byArray);
                            Object var6_7 = null;
                            if (byteArrayInputStream == null) return gif;
                            break block4;
                        }
                        if (n == 255 && n2 == 216) {
                            jpeg = new Jpeg(byArray);
                            break block5;
                        }
                        if (n != Png.PNGID[0]) throw new IOException("Could not find a recognized imageformat.");
                        if (n2 != Png.PNGID[1]) throw new IOException("Could not find a recognized imageformat.");
                        png = new Png(byArray);
                        break block6;
                    }
                    catch (Throwable throwable) {
                        Object var6_10 = null;
                        if (byteArrayInputStream == null) throw throwable;
                        ((InputStream)byteArrayInputStream).close();
                        throw throwable;
                    }
                }
                ((InputStream)byteArrayInputStream).close();
                return gif;
            }
            Object var6_8 = null;
            if (byteArrayInputStream == null) return jpeg;
            ((InputStream)byteArrayInputStream).close();
            return jpeg;
        }
        Object var6_9 = null;
        if (byteArrayInputStream == null) return png;
        ((InputStream)byteArrayInputStream).close();
        return png;
    }

    public static Image getInstance(int n, int n2, int n3, int n4, byte[] byArray) throws BadElementException, MalformedURLException, IOException {
        return new ImgRaw(n, n2, n3, n4, byArray);
    }

    public static Image getInstance(int n, int n2, int n3, int n4, byte[] byArray, int[] nArray) throws BadElementException, MalformedURLException, IOException {
        if (nArray != null && nArray.length != n3 * 2) {
            throw new BadElementException("transparency length must be equal to (componentes * 2)");
        }
        ImgRaw imgRaw = new ImgRaw(n, n2, n3, n4, byArray);
        imgRaw.transparency = nArray;
        return imgRaw;
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public void setAlt(String string) {
        this.alt = string;
    }

    public void setAbsolutePosition(float f, float f2) {
        this.absoluteX = f;
        this.absoluteY = f2;
    }

    public void scaleAbsolute(float f, float f2) {
        this.plainWidth = f;
        this.plainHeight = f2;
        float[] fArray = this.matrix();
        this.scaledWidth = fArray[6] - fArray[4];
        this.scaledHeight = fArray[7] - fArray[5];
    }

    public void scalePercent(float f) {
        this.scalePercent(f, f);
    }

    public void scalePercent(float f, float f2) {
        this.plainWidth = this.width() * f / 100.0f;
        this.plainHeight = this.height() * f2 / 100.0f;
        float[] fArray = this.matrix();
        this.scaledWidth = fArray[6] - fArray[4];
        this.scaledHeight = fArray[7] - fArray[5];
    }

    public void scaleToFit(float f, float f2) {
        float f3;
        float f4 = f * 100.0f / this.width();
        this.scalePercent(f4 < (f3 = f2 * 100.0f / this.height()) ? f4 : f3);
    }

    public void setRotation(float f) {
        this.rotation = (float)((double)f % (Math.PI * 2));
        if (this.rotation < 0.0f) {
            this.rotation = (float)((double)this.rotation + Math.PI * 2);
        }
        float[] fArray = this.matrix();
        this.scaledWidth = fArray[6] - fArray[4];
        this.scaledHeight = fArray[7] - fArray[5];
    }

    public int bpc() {
        return this.bpc;
    }

    public byte[] rawData() {
        return this.rawData;
    }

    public boolean hasAbsolutePosition() {
        return !Float.isNaN(this.absoluteX) && !Float.isNaN(this.absoluteY);
    }

    public float absoluteX() {
        return this.absoluteX;
    }

    public float absoluteY() {
        return this.absoluteY;
    }

    public int type() {
        return this.type;
    }

    public boolean isGif() {
        return this.type == 31;
    }

    public boolean isJpeg() {
        return this.type == 32;
    }

    public boolean isPng() {
        return this.type == 33;
    }

    public boolean isImgRaw() {
        return this.type == 34;
    }

    public URL url() {
        return this.url;
    }

    public int alignment() {
        return this.alignment;
    }

    public String alt() {
        return this.alt;
    }

    public float scaledWidth() {
        return this.scaledWidth;
    }

    public float scaledHeight() {
        return this.scaledHeight;
    }

    public int colorspace() {
        return this.colorspace;
    }

    public float[] matrix() {
        float[] fArray = new float[8];
        float f = (float)Math.cos(this.rotation);
        float f2 = (float)Math.sin(this.rotation);
        fArray[0] = this.plainWidth * f;
        fArray[1] = this.plainWidth * f2;
        fArray[2] = -this.plainHeight * f2;
        fArray[3] = this.plainHeight * f;
        if ((double)this.rotation < 1.5707963267948966) {
            fArray[4] = fArray[2];
            fArray[5] = 0.0f;
            fArray[6] = fArray[0];
            fArray[7] = fArray[1] + fArray[3];
        } else if ((double)this.rotation < Math.PI) {
            fArray[4] = fArray[0] + fArray[2];
            fArray[5] = fArray[3];
            fArray[6] = 0.0f;
            fArray[7] = fArray[1];
        } else if ((double)this.rotation < 2.0943951023931953) {
            fArray[4] = fArray[0];
            fArray[5] = fArray[1] + fArray[3];
            fArray[6] = fArray[2];
            fArray[7] = 0.0f;
        } else if ((double)this.rotation < 1.5707963267948966) {
            fArray[4] = 0.0f;
            fArray[5] = fArray[1];
            fArray[6] = fArray[0] + fArray[2];
            fArray[7] = fArray[3];
        }
        return fArray;
    }

    public void skip(InputStream inputStream, int n) throws IOException {
        while (n > 0) {
            n = (int)((long)n - inputStream.skip(n));
        }
    }

    public static URL toURL(String string) throws MalformedURLException {
        File file = new File(string);
        String string2 = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            string2 = string2.replace(File.separatorChar, '/');
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        if (!string2.endsWith("/") && file.isDirectory()) {
            string2 = string2 + "/";
        }
        return new URL("file", "", string2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<IMG>");
        stringBuffer.append(super.toString());
        stringBuffer.append("</IMG>");
        return stringBuffer.toString();
    }

    public int[] getTransparency() {
        return this.transparency;
    }
}

