/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import com.lowagie.text.ListItem;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class List
implements Element {
    private ArrayList list = new ArrayList();
    private boolean numbered;
    private int first = 1;
    private Chunk symbol = new Chunk("-");
    private float indentationLeft;
    private float indentationRight;
    private int symbolIndent;

    public List(boolean bl, int n) {
        this.numbered = bl;
        this.symbolIndent = n;
    }

    public boolean process(ElementListener elementListener) {
        try {
            Iterator iterator = ((AbstractList)this.list).iterator();
            while (iterator.hasNext()) {
                elementListener.add((Element)iterator.next());
            }
            return true;
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public int type() {
        return 14;
    }

    public ArrayList getChunks() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = ((AbstractList)this.list).iterator();
        while (iterator.hasNext()) {
            arrayList.addAll(((Element)iterator.next()).getChunks());
        }
        return arrayList;
    }

    public void add(ListItem listItem) {
        if (this.numbered) {
            Chunk chunk = new Chunk(String.valueOf(this.first + this.list.size()));
            chunk.append(".");
            listItem.setListSymbol(chunk);
        } else {
            listItem.setListSymbol(this.symbol);
        }
        listItem.setIndentationLeft(this.symbolIndent);
        listItem.setIndentationRight(0.0f);
        this.list.add(listItem);
    }

    public void add(List list) {
        list.setIndentationLeft(list.indentationLeft() + (float)this.symbolIndent);
        --this.first;
        this.list.add(list);
    }

    public void add(String string) {
        this.add(new ListItem(string));
    }

    public final void setIndentationLeft(float f) {
        this.indentationLeft = f;
    }

    public final void setIndentationRight(float f) {
        this.indentationRight = f;
    }

    public final void setFirst(int n) {
        this.first = n;
    }

    public final void setListSymbol(Chunk chunk) {
        this.symbol = chunk;
    }

    public final void setListSymbol(String string) {
        this.symbol = new Chunk(string);
    }

    public ArrayList getItems() {
        return this.list;
    }

    public int size() {
        return this.list.size();
    }

    public float leading() {
        if (this.list.size() < 1) {
            return -1.0f;
        }
        ListItem listItem = (ListItem)this.list.get(0);
        return listItem.leading();
    }

    public final boolean isNumbered() {
        return this.numbered;
    }

    public final float indentationLeft() {
        return this.indentationLeft;
    }

    public final float indentationRight() {
        return this.indentationRight;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<LIST TYPE=\"");
        if (!this.numbered) {
            stringBuffer.append("NOT");
        }
        stringBuffer.append("NUMBERED\">\n");
        if (this.numbered) {
            stringBuffer.append("\t<FIRST>");
            stringBuffer.append(this.first);
            stringBuffer.append("</FIRST>\n");
        } else {
            stringBuffer.append("\t<SYMBOL>");
            stringBuffer.append(this.symbol.toString());
            stringBuffer.append("</SYMBOL>\n");
        }
        Iterator iterator = ((AbstractList)this.list).iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString());
        }
        stringBuffer.append("\n</LIST>\n");
        return stringBuffer.toString();
    }
}

