/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import java.awt.Color;
import java.util.ArrayList;

public class Rectangle
implements Element {
    public static final int UNDEFINED = -1;
    public static final int TOP = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int NO_BORDER = 0;
    public static final int BOX = 15;
    protected float llx;
    protected float lly;
    protected float urx;
    protected float ury;
    protected int border = -1;
    protected float borderWidth = -1.0f;
    protected Color color = null;
    protected Color background = null;
    protected float grayFill = 0.0f;

    public Rectangle(float f, float f2, float f3, float f4) {
        this.llx = f;
        this.lly = f2;
        this.urx = f3;
        this.ury = f4;
    }

    public Rectangle(float f, float f2) {
        this(0.0f, 0.0f, f, f2);
    }

    public Rectangle(Rectangle rectangle) {
        this(rectangle.left(), rectangle.bottom(), rectangle.right(), rectangle.top());
    }

    public boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public int type() {
        return 30;
    }

    public ArrayList getChunks() {
        return new ArrayList();
    }

    public Rectangle rectangle(float f, float f2) {
        Rectangle rectangle = new Rectangle(this);
        rectangle.setBorder(this.border);
        rectangle.setBorderWidth(this.borderWidth);
        rectangle.setBorderColor(this.color);
        rectangle.setBackgroundColor(this.background);
        rectangle.setGrayFill(this.grayFill);
        if (this.top() > f) {
            rectangle.setTop(f);
            rectangle.setBorder(this.border - (this.border & 1));
        }
        if (this.bottom() < f2) {
            rectangle.setBottom(f2);
            rectangle.setBorder(this.border - (this.border & 2));
        }
        return rectangle;
    }

    public Rectangle rotate() {
        return new Rectangle(this.lly, this.llx, this.ury, this.urx);
    }

    public void setLeft(float f) {
        this.llx = f;
    }

    public void setRight(float f) {
        this.urx = f;
    }

    public void setTop(float f) {
        this.ury = f;
    }

    public void setBottom(float f) {
        this.lly = f;
    }

    public void setBorder(int n) {
        this.border = n;
    }

    public void setBorderWidth(float f) {
        this.borderWidth = f;
    }

    public void setBorderColor(Color color) {
        this.color = color;
    }

    public void setBackgroundColor(Color color) {
        this.background = color;
    }

    public void setGrayFill(float f) {
        if (f >= 0.0f && (double)f <= 1.0) {
            this.grayFill = f;
        }
    }

    public float left() {
        return this.llx;
    }

    public float right() {
        return this.urx;
    }

    public float top() {
        return this.ury;
    }

    public float bottom() {
        return this.lly;
    }

    public float left(float f) {
        return this.llx + f;
    }

    public float right(float f) {
        return this.urx - f;
    }

    public float top(float f) {
        return this.ury - f;
    }

    public float bottom(float f) {
        return this.lly + f;
    }

    public float width() {
        return this.urx - this.llx;
    }

    public float height() {
        return this.ury - this.lly;
    }

    public final boolean hasBorders() {
        return this.border > 0 && this.borderWidth > 0.0f;
    }

    public final boolean hasBorder(int n) {
        return this.border != -1 && (this.border & n) == n;
    }

    public final int border() {
        return this.border;
    }

    public float borderWidth() {
        return this.borderWidth;
    }

    public final Color borderColor() {
        return this.color;
    }

    public final Color backgroundColor() {
        return this.background;
    }

    public final float grayFill() {
        return this.grayFill;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("<RECTANGLE X1=\"");
        stringBuffer.append(this.llx);
        stringBuffer.append("\" Y1=\"");
        stringBuffer.append(this.ury);
        stringBuffer.append("\" X2=\"");
        stringBuffer.append(this.urx);
        stringBuffer.append("\" Y2=\"");
        stringBuffer.append(this.lly);
        stringBuffer.append("\">\n");
        if (this.borderWidth != -1.0f) {
            stringBuffer.append("\t<BORDER WIDTH=\"");
            stringBuffer.append(this.borderWidth);
            stringBuffer.append("\">\n");
            if (this.hasBorder(4)) {
                stringBuffer.append("\t\tleft\n");
            }
            if (this.hasBorder(8)) {
                stringBuffer.append("\t\tright\n");
            }
            if (this.hasBorder(1)) {
                stringBuffer.append("\t\ttop\n");
            }
            if (this.hasBorder(2)) {
                stringBuffer.append("\t\tbottom\n");
            }
            stringBuffer.append("\t</BORDER>\n");
        }
        if (this.color != null) {
            stringBuffer.append("\t<COLOR RED=\"");
            stringBuffer.append(this.color.getRed());
            stringBuffer.append("\" GREEN=\"");
            stringBuffer.append(this.color.getGreen());
            stringBuffer.append("\" BLUE=\"");
            stringBuffer.append(this.color.getBlue());
            stringBuffer.append("\"></COLOR>\n");
        }
        stringBuffer.append("</RECTANGLE>\n");
        return stringBuffer.toString();
    }
}

