/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text;

import com.lowagie.text.Cell;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.ElementListener;
import java.util.ArrayList;

public class Row
implements Element {
    private int columns;
    private boolean[] reserved;
    private Cell[] cells;
    private int horizontalAlignment;
    private int verticalAlignment;

    Row(int n) {
        this.columns = n;
        this.reserved = new boolean[n];
        this.cells = new Cell[n];
    }

    public final boolean process(ElementListener elementListener) {
        try {
            return elementListener.add(this);
        }
        catch (DocumentException documentException) {
            return false;
        }
    }

    public final int type() {
        return 21;
    }

    public final ArrayList getChunks() {
        return new ArrayList();
    }

    final void deleteColumn(int n) {
        --this.columns;
        boolean[] blArray = new boolean[this.columns];
        Cell[] cellArray = new Cell[this.columns];
        int n2 = 0;
        while (n2 < n) {
            blArray[n2] = this.reserved[n2];
            cellArray[n2] = this.cells[n2];
            if (cellArray[n2] != null && n2 + cellArray[n2].colspan() > n) {
                cellArray[n2].setColspan(this.cells[n2].colspan() - 1);
            }
            ++n2;
        }
        int n3 = n;
        while (n3 < this.columns) {
            blArray[n3] = this.reserved[n3 + 1];
            cellArray[n3] = this.cells[n3 + 1];
            ++n3;
        }
        if (this.cells[n] != null && this.cells[n].colspan() > 1) {
            cellArray[n] = this.cells[n];
            cellArray[n].setColspan(cellArray[n].colspan() - 1);
        }
        this.reserved = blArray;
        this.cells = cellArray;
    }

    final int addCell(Cell cell) {
        int n = 0;
        while (n < this.columns) {
            if (!this.reserved[n]) {
                this.reserved[n] = true;
                this.cells[n] = cell;
                return n;
            }
            ++n;
        }
        return -1;
    }

    final boolean reserve(int n) {
        if (n >= this.columns || this.reserved[n]) {
            return false;
        }
        this.reserved[n] = true;
        return true;
    }

    public void setHorizontalAlignment(int n) {
        this.horizontalAlignment = n;
    }

    public void setVerticalAlignment(int n) {
        this.verticalAlignment = n;
    }

    public final Cell getCell(int n) {
        if (n >= this.columns) {
            return null;
        }
        return this.cells[n];
    }

    public final boolean isEmpty() {
        int n = 0;
        while (n < this.columns) {
            if (this.reserved[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public final int columns() {
        return this.columns;
    }

    public int horizontalAlignment() {
        return this.horizontalAlignment;
    }

    public int verticalAlignment() {
        return this.verticalAlignment;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer("\t<ROW COLUMNS=\"");
        stringBuffer.append(this.columns);
        stringBuffer.append(">\n");
        stringBuffer.append("\n\t\t<HORIZONTAL_ALIGNMENT>");
        switch (this.horizontalAlignment) {
            case 0: {
                stringBuffer.append("Left");
                break;
            }
            case 1: {
                stringBuffer.append("Center");
                break;
            }
            case 2: {
                stringBuffer.append("Right");
                break;
            }
            case 3: {
                stringBuffer.append("Justify");
                break;
            }
            default: {
                stringBuffer.append("Default");
            }
        }
        stringBuffer.append("</HORIZONTAL_ALIGNMENT>\n");
        stringBuffer.append("\t\t<VERTICAL_ALIGNMENT>");
        switch (this.verticalAlignment) {
            case 4: {
                stringBuffer.append("Top");
                break;
            }
            case 5: {
                stringBuffer.append("Middle");
                break;
            }
            case 6: {
                stringBuffer.append("Bottom");
                break;
            }
            case 7: {
                stringBuffer.append("Baseline");
                break;
            }
            default: {
                stringBuffer.append("Default");
            }
        }
        stringBuffer.append("</VERTICAL_ALIGNMENT>\n");
        int n = 0;
        while (n < this.columns) {
            Cell cell = this.cells[n];
            if (cell != null) {
                stringBuffer.append(cell.toString());
            }
            ++n;
        }
        stringBuffer.append("\n\t</ROW>\n");
        return stringBuffer.toString();
    }
}

