/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.html;

import java.awt.Color;

public class HtmlEncoder {
    private static final String[] htmlCode = new String[256];

    private HtmlEncoder() {
    }

    public static String encode(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            try {
                stringBuffer.append(htmlCode[c]);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String encode(Color color) {
        StringBuffer stringBuffer = new StringBuffer("#");
        if (color.getRed() < 16) {
            stringBuffer.append('0');
        }
        stringBuffer.append(Integer.toString(color.getRed(), 16));
        if (color.getGreen() < 16) {
            stringBuffer.append('0');
        }
        stringBuffer.append(Integer.toString(color.getGreen(), 16));
        if (color.getBlue() < 16) {
            stringBuffer.append('0');
        }
        stringBuffer.append(Integer.toString(color.getBlue(), 16));
        return stringBuffer.toString();
    }

    public static String getAlignment(int n) {
        switch (n) {
            case 0: {
                return "Left";
            }
            case 1: {
                return "Center";
            }
            case 2: {
                return "Right";
            }
            case 3: {
                return "Justify";
            }
            case 4: {
                return "Top";
            }
            case 5: {
                return "Middle";
            }
            case 6: {
                return "Bottom";
            }
            case 7: {
                return "Baseline";
            }
        }
        return "Left";
    }

    static {
        int n = 0;
        while (n < 10) {
            HtmlEncoder.htmlCode[n] = "&#00" + n + ";";
            ++n;
        }
        int n2 = 10;
        while (n2 < 32) {
            HtmlEncoder.htmlCode[n2] = "&#0" + n2 + ";";
            ++n2;
        }
        int n3 = 32;
        while (n3 < 128) {
            HtmlEncoder.htmlCode[n3] = String.valueOf((char)n3);
            ++n3;
        }
        HtmlEncoder.htmlCode[10] = "<BR>\n";
        HtmlEncoder.htmlCode[34] = "&quot;";
        HtmlEncoder.htmlCode[38] = "&amp;";
        HtmlEncoder.htmlCode[60] = "&lt;";
        HtmlEncoder.htmlCode[62] = "&gt;";
        int n4 = 128;
        while (n4 < 256) {
            HtmlEncoder.htmlCode[n4] = "&#" + n4 + ";";
            ++n4;
        }
    }
}

