/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Anchor;
import com.lowagie.text.Cell;
import com.lowagie.text.Chunk;
import com.lowagie.text.Element;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfChunk;
import com.lowagie.text.pdf.PdfLine;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;

public class PdfCell
extends Rectangle {
    private ArrayList lines;
    private float leading;
    private int rownumber;
    private int rowspan;
    private float cellpadding;
    private float cellspacing;
    private boolean header = false;

    public PdfCell(Cell cell, int n, float f, float f2, float f3, float f4, float f5) {
        super(f, f3, f2, f3);
        this.setBorder(cell.border());
        this.setBorderWidth(cell.borderWidth());
        this.setBorderColor(cell.borderColor());
        this.setBackgroundColor(cell.backgroundColor());
        this.setGrayFill(cell.grayFill());
        this.lines = new ArrayList();
        this.leading = cell.leading();
        int n2 = cell.horizontalAlignment();
        f += f4 + f5;
        f2 -= f4 + f5;
        float f6 = this.leading + f4;
        float f7 = cell.rowspan();
        switch (cell.verticalAlignment()) {
            case 6: {
                f6 *= f7;
                break;
            }
            case 5: {
                f6 = (float)((double)f6 * ((double)f7 / 1.5));
                break;
            }
            default: {
                if (!(f7 < 2.0f)) break;
                f6 = (float)((double)f6 - (double)f6 / 2.5);
            }
        }
        PdfLine pdfLine = new PdfLine(f, f2, n2, f6);
        Iterator iterator = cell.getElements();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            switch (element.type()) {
                case 14: {
                    PdfChunk pdfChunk;
                    PdfChunk pdfChunk2;
                    Iterator iterator2;
                    if (pdfLine.size() > 0) {
                        pdfLine.resetAlignment();
                        this.lines.add(pdfLine);
                    }
                    ArrayList arrayList = new ArrayList();
                    this.processActions(element, null, arrayList);
                    int n3 = 0;
                    Iterator iterator3 = ((AbstractList)((List)element).getItems()).iterator();
                    while (iterator3.hasNext()) {
                        ListItem listItem = (ListItem)iterator3.next();
                        pdfLine = new PdfLine(f + listItem.indentationLeft(), f2, n2, this.leading);
                        pdfLine.setListItem(listItem);
                        iterator2 = ((AbstractList)listItem.getChunks()).iterator();
                        while (iterator2.hasNext()) {
                            pdfChunk2 = new PdfChunk((Chunk)iterator2.next(), (PdfAction)arrayList.get(n3++));
                            while ((pdfChunk = pdfLine.add(pdfChunk2)) != null) {
                                this.lines.add(pdfLine);
                                pdfLine = new PdfLine(f + listItem.indentationLeft(), f2, n2, this.leading);
                                pdfChunk2 = pdfChunk;
                            }
                            pdfLine.resetAlignment();
                            this.lines.add(pdfLine);
                            pdfLine = new PdfLine(f + listItem.indentationLeft(), f2, n2, this.leading);
                        }
                    }
                    pdfLine = new PdfLine(f, f2, n2, this.leading);
                    break;
                }
                default: {
                    PdfChunk pdfChunk;
                    PdfChunk pdfChunk2;
                    ArrayList arrayList = new ArrayList();
                    this.processActions(element, null, arrayList);
                    int n3 = 0;
                    Iterator iterator2 = ((AbstractList)element.getChunks()).iterator();
                    while (iterator2.hasNext()) {
                        pdfChunk2 = new PdfChunk((Chunk)iterator2.next(), (PdfAction)arrayList.get(n3++));
                        while ((pdfChunk = pdfLine.add(pdfChunk2)) != null) {
                            this.lines.add(pdfLine);
                            pdfLine = new PdfLine(f, f2, n2, this.leading);
                            pdfChunk2 = pdfChunk;
                        }
                    }
                    switch (element.type()) {
                        case 12: 
                        case 13: 
                        case 16: {
                            pdfLine.resetAlignment();
                            this.lines.add(pdfLine);
                            pdfLine = new PdfLine(f, f2, n2, this.leading);
                        }
                    }
                }
            }
        }
        if (pdfLine.size() > 0) {
            this.lines.add(pdfLine);
        }
        this.setBottom(f3 - this.leading * (float)this.lines.size() - 5.0f * f4 / 2.0f);
        this.cellpadding = f5;
        this.cellspacing = f4;
        this.rowspan = cell.rowspan();
        this.rownumber = n;
    }

    public float left() {
        return super.left(this.cellpadding);
    }

    public float right() {
        return super.right(this.cellpadding);
    }

    public float top() {
        return super.top(this.cellpadding);
    }

    public float bottom() {
        return super.bottom(this.cellpadding);
    }

    public ArrayList getLines(float f, float f2) {
        if (this.top() < f2) {
            return null;
        }
        float f3 = Math.min(this.top(), f);
        ArrayList<PdfLine> arrayList = new ArrayList<PdfLine>();
        int n = this.lines.size();
        int n2 = 0;
        while (n2 < n) {
            PdfLine pdfLine = (PdfLine)this.lines.get(n2);
            float f4 = pdfLine.height();
            if ((f3 -= f4) > f2) {
                arrayList.add(pdfLine);
                if (!this.header) {
                    this.lines.set(n2, new PdfLine(this.left(-this.cellpadding - this.cellspacing), this.right(-this.cellpadding - this.cellspacing), 0, this.leading));
                }
            }
            ++n2;
        }
        if (!this.header && f2 <= this.bottom()) {
            this.lines = new ArrayList();
        }
        return arrayList;
    }

    final void setHeader() {
        this.header = true;
    }

    final boolean mayBeRemoved() {
        return this.header || this.lines.size() < 1;
    }

    public int size() {
        return this.lines.size();
    }

    public float leading() {
        return this.leading;
    }

    public int rownumber() {
        return this.rownumber;
    }

    public int rowspan() {
        return this.rowspan;
    }

    public float cellspacing() {
        return this.cellspacing;
    }

    public float cellpadding() {
        return this.cellpadding;
    }

    protected void processActions(Element element, PdfAction pdfAction, ArrayList arrayList) {
        Iterator iterator;
        if (element.type() == 17 && (iterator = ((Anchor)element).url()) != null) {
            pdfAction = new PdfAction((URL)((Object)iterator));
        }
        switch (element.type()) {
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                iterator = ((AbstractList)((ArrayList)((Object)element))).iterator();
                while (iterator.hasNext()) {
                    this.processActions((Element)iterator.next(), pdfAction, arrayList);
                }
                break;
            }
            case 10: {
                arrayList.add(pdfAction);
                break;
            }
            case 14: {
                iterator = ((AbstractList)((List)element).getItems()).iterator();
                while (iterator.hasNext()) {
                    this.processActions((Element)iterator.next(), pdfAction, arrayList);
                }
                break;
            }
            default: {
                ArrayList arrayList2 = element.getChunks();
                int n = element.getChunks().size();
                while (n-- > 0) {
                    arrayList.add(pdfAction);
                }
                break block0;
            }
        }
    }
}

