/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfFont;
import com.lowagie.text.pdf.PdfFontMetrics;
import com.lowagie.text.pdf.PdfString;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;

class PdfChunk
extends PdfString {
    private static final HashMap keysAttributes = new HashMap();
    private static final HashMap keysNoStroke = new HashMap();
    protected PdfFont font;
    protected HashMap attributes = new HashMap();
    protected HashMap noStroke = new HashMap();
    protected boolean newlineSplit;
    protected Image image;
    protected float offsetX;
    protected float offsetY;

    private PdfChunk(String string, PdfFont pdfFont, HashMap hashMap, HashMap hashMap2) {
        super(string);
        this.font = pdfFont;
        this.attributes = hashMap;
        this.noStroke = hashMap2;
        Object[] objectArray = (Object[])hashMap.get("IMAGE");
        if (objectArray == null) {
            this.image = null;
        } else {
            this.image = (Image)objectArray[0];
            this.offsetX = ((Float)objectArray[1]).floatValue();
            this.offsetY = ((Float)objectArray[2]).floatValue();
        }
        this.encoding = pdfFont.getFont().getEncoding();
    }

    PdfChunk(Chunk chunk, PdfAction pdfAction) {
        super(chunk.content());
        BaseFont baseFont;
        Font font = chunk.font();
        float f = font.size();
        if (f == -1.0f) {
            f = 12.0f;
        }
        if ((baseFont = font.getBaseFont()) == null) {
            int n;
            int n2 = font.style();
            if (n2 == -1) {
                n2 = 0;
            }
            block0 : switch (font.family()) {
                case 0: {
                    switch (n2 & 3) {
                        case 1: {
                            n = 1;
                            break block0;
                        }
                        case 2: {
                            n = 2;
                            break block0;
                        }
                        case 3: {
                            n = 3;
                            break block0;
                        }
                    }
                    n = 0;
                    break;
                }
                case 2: {
                    switch (n2 & 3) {
                        case 1: {
                            n = 10;
                            break block0;
                        }
                        case 2: {
                            n = 11;
                            break block0;
                        }
                        case 3: {
                            n = 12;
                            break block0;
                        }
                    }
                    n = 9;
                    break;
                }
                case 3: {
                    n = 8;
                    break;
                }
                case 4: {
                    n = 13;
                    break;
                }
                default: {
                    switch (n2 & 3) {
                        case 1: {
                            n = 5;
                            break block0;
                        }
                        case 2: {
                            n = 6;
                            break block0;
                        }
                        case 3: {
                            n = 7;
                            break block0;
                        }
                    }
                    n = 4;
                }
            }
            this.font = new PdfFont(n, f);
        } else {
            this.font = new PdfFont(baseFont, f);
        }
        HashMap hashMap = chunk.getAttributes();
        if (hashMap != null) {
            Iterator iterator = hashMap.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                if (keysAttributes.containsKey(k)) {
                    this.attributes.put(k, hashMap.get(k));
                    continue;
                }
                if (!keysNoStroke.containsKey(k)) continue;
                this.noStroke.put(k, hashMap.get(k));
            }
        }
        if (font.isUnderlined()) {
            this.attributes.put("UNDERLINE", null);
        }
        if (font.isStrikethru()) {
            this.attributes.put("STRIKETHRU", null);
        }
        if (pdfAction != null) {
            this.attributes.put("LINK", pdfAction);
        }
        this.noStroke.put("COLOR", font.color());
        this.noStroke.put("ENCODING", this.font.getFont().getEncoding());
        Object[] objectArray = (Object[])this.attributes.get("IMAGE");
        if (objectArray == null) {
            this.image = null;
        } else {
            this.image = (Image)objectArray[0];
            this.offsetX = ((Float)objectArray[1]).floatValue();
            this.offsetY = ((Float)objectArray[2]).floatValue();
        }
        this.font.setImage(this.image);
        this.encoding = this.font.getFont().getEncoding();
    }

    PdfChunk split(float f) {
        this.newlineSplit = false;
        if (this.image != null) {
            if (this.image.scaledWidth() > f) {
                PdfChunk pdfChunk = new PdfChunk("", this.font, this.attributes, this.noStroke);
                this.value = "";
                this.attributes.remove("IMAGE");
                this.image = null;
                this.font = new PdfFont(4, 12.0f);
                return pdfChunk;
            }
            return null;
        }
        int n = 0;
        int n2 = -1;
        float f2 = 0.0f;
        int n3 = this.value.length();
        while (n < n3) {
            char c = this.value.charAt(n);
            if (c == '\r' || c == '\n') {
                this.newlineSplit = true;
                int n4 = 1;
                if (c == '\r' && n + 1 < n3 && this.value.charAt(n) == '\n') {
                    n4 = 2;
                }
                String string = this.value.substring(n + n4);
                this.value = this.value.substring(0, n);
                if (this.value.length() < 1) {
                    this.value = " ";
                }
                this.setContent(this.value);
                PdfChunk pdfChunk = new PdfChunk(string, this.font, this.attributes, this.noStroke);
                return pdfChunk;
            }
            if ((f2 += this.font.width(c)) > f) break;
            if (PdfFontMetrics.isSplitCharacter(c)) {
                n2 = n + 1;
            }
            ++n;
        }
        if (n == n3) {
            return null;
        }
        if (n2 < 0) {
            String string = this.value;
            this.value = "";
            this.setContent(this.value);
            PdfChunk pdfChunk = new PdfChunk(string, this.font, this.attributes, this.noStroke);
            return pdfChunk;
        }
        String string = this.value.substring(n2);
        this.value = PdfFontMetrics.trim(this.value.substring(0, n2));
        this.setContent(this.value);
        PdfChunk pdfChunk = new PdfChunk(string, this.font, this.attributes, this.noStroke);
        return pdfChunk;
    }

    PdfChunk truncate(float f) {
        if (this.image != null) {
            if (this.image.scaledWidth() > f) {
                PdfChunk pdfChunk = new PdfChunk("", this.font, this.attributes, this.noStroke);
                this.value = "";
                this.attributes.remove("IMAGE");
                this.image = null;
                this.font = new PdfFont(4, 12.0f);
                return pdfChunk;
            }
            return null;
        }
        int n = 0;
        float f2 = 0.0f;
        if (f < this.font.width()) {
            String string = this.value.substring(1);
            this.value = this.value.substring(0, 1);
            this.setContent(this.value);
            PdfChunk pdfChunk = new PdfChunk(string, this.font, this.attributes, this.noStroke);
            return pdfChunk;
        }
        int n2 = this.value.length();
        while (n < n2) {
            char c = this.value.charAt(n);
            if ((f2 += this.font.width(c)) > f) break;
            ++n;
        }
        if (n == n2) {
            return null;
        }
        if ((n -= 2) < 0) {
            n = 1;
        }
        String string = this.value.substring(n);
        this.value = this.value.substring(0, n);
        this.setContent(this.value);
        PdfChunk pdfChunk = new PdfChunk(string, this.font, this.attributes, this.noStroke);
        return pdfChunk;
    }

    PdfFont font() {
        return this.font;
    }

    Color color() {
        return (Color)this.noStroke.get("COLOR");
    }

    float width() {
        if (this.image != null) {
            return this.image.scaledWidth();
        }
        return this.font.getFont().getWidthPoint(this.value, this.font.size());
    }

    public boolean isNewlineSplit() {
        return this.newlineSplit;
    }

    public float getWidthCorrected(float f, float f2) {
        if (this.image != null) {
            return this.image.scaledWidth() + f;
        }
        int n = 0;
        int n2 = -1;
        while ((n2 = this.value.indexOf(32, n2 + 1)) >= 0) {
            ++n;
        }
        return this.font.getFont().getWidthPoint(this.value, this.font.size()) + (float)this.value.length() * f + (float)n * f2;
    }

    public float trimLastSpace() {
        if (this.value.length() > 1 && this.value.endsWith(" ")) {
            this.value = this.value.substring(0, this.value.length() - 1);
            this.setContent(this.value);
            return this.font.width(' ');
        }
        return 0.0f;
    }

    Object getAttribute(String string) {
        if (this.attributes.containsKey(string)) {
            return this.attributes.get(string);
        }
        return this.noStroke.get(string);
    }

    boolean isAttribute(String string) {
        if (this.attributes.containsKey(string)) {
            return true;
        }
        return this.noStroke.containsKey(string);
    }

    boolean isStroked() {
        return this.attributes.size() > 0;
    }

    boolean isImage() {
        return this.image != null;
    }

    Image getImage() {
        return this.image;
    }

    float getImageOffsetX() {
        return this.offsetX;
    }

    float getImageOffsetY() {
        return this.offsetY;
    }

    void setValue(String string) {
        this.value = string;
        this.setContent(string);
    }

    static {
        keysAttributes.put("LINK", null);
        keysAttributes.put("STRIKETHRU", null);
        keysAttributes.put("UNDERLINE", null);
        keysAttributes.put("REMOTEGOTO", null);
        keysAttributes.put("LOCALGOTO", null);
        keysAttributes.put("LOCALDESTINATION", null);
        keysAttributes.put("GENERICTAG", null);
        keysAttributes.put("IMAGE", null);
        keysNoStroke.put("SUBSUPSCRIPT", null);
    }
}

