/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Anchor;
import com.lowagie.text.Annotation;
import com.lowagie.text.Chunk;
import com.lowagie.text.DocListener;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Graphic;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Image;
import com.lowagie.text.List;
import com.lowagie.text.ListItem;
import com.lowagie.text.Meta;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Section;
import com.lowagie.text.StringCompare;
import com.lowagie.text.Table;
import com.lowagie.text.Watermark;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfCell;
import com.lowagie.text.pdf.PdfChunk;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfContents;
import com.lowagie.text.pdf.PdfDate;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfException;
import com.lowagie.text.pdf.PdfFont;
import com.lowagie.text.pdf.PdfFontDictionary;
import com.lowagie.text.pdf.PdfImage;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfLine;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfPage;
import com.lowagie.text.pdf.PdfPageEvent;
import com.lowagie.text.pdf.PdfProcSet;
import com.lowagie.text.pdf.PdfRectangle;
import com.lowagie.text.pdf.PdfResources;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTable;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfTextArray;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.PdfXObjectDictionary;
import java.awt.Color;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

class PdfDocument
extends Document
implements DocListener {
    static final float ratio = 2.5f;
    static final String hangingPunctuation = ".,;:'";
    private PdfWriter writer;
    private PdfInfo info = new PdfInfo();
    private boolean firstPageEvent = true;
    private PdfLine line = null;
    private float indentLeft = 0.0f;
    private float indentRight = 0.0f;
    private float listIndentLeft = 0.0f;
    private int alignment = 0;
    private PdfContentByte text;
    private PdfContentByte graphics;
    private ArrayList lines = new ArrayList();
    private float leading = 0.0f;
    private float currentHeight = 0.0f;
    private float indentTop = 0.0f;
    private float indentBottom = 0.0f;
    private boolean pageEmpty = true;
    protected Rectangle thisPageSize = null;
    protected PdfFontDictionary fontDictionary;
    protected PdfXObjectDictionary xObjectDictionary;
    private HashMap images = new HashMap();
    private Image imageWait = null;
    private float imageEnd = -1.0f;
    private float imageIndentLeft = 0.0f;
    private float imageIndentRight = 0.0f;
    private PdfArray annotations;
    private ArrayList outlines;
    private PdfOutline currentOutline;
    private PdfAction currentAction = null;
    private TreeMap localDestinations = new TreeMap(new StringCompare());
    private HashMap localPageDestinations = new HashMap();

    public PdfDocument() throws DocumentException {
        this.addProducer();
        this.addCreationDate();
    }

    public final void addWriter(PdfWriter pdfWriter) throws DocumentException {
        if (this.writer == null) {
            this.writer = pdfWriter;
            return;
        }
        throw new DocumentException("You can only add a writer to a PdfDocument once.");
    }

    public boolean setPageSize(Rectangle rectangle) {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        this.pageSize = rectangle;
        return true;
    }

    public void setHeader(HeaderFooter headerFooter) {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.setHeader(headerFooter);
    }

    public void resetHeader() {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.resetHeader();
    }

    public void setFooter(HeaderFooter headerFooter) {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.setFooter(headerFooter);
    }

    public void resetFooter() {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.resetFooter();
    }

    public void resetPageCount() {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.resetPageCount();
    }

    public void setPageCount(int n) {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        super.setPageCount(n);
    }

    public boolean add(Watermark watermark) {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        this.watermark = watermark;
        return true;
    }

    public void removeWatermark() {
        if (this.writer != null && this.writer.isPaused()) {
            return;
        }
        this.watermark = null;
    }

    public boolean setMargins(float f, float f2, float f3, float f4) {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        this.marginLeft = f;
        this.marginRight = f2;
        this.marginTop = f3;
        this.marginBottom = f4;
        return true;
    }

    public boolean newPage() throws DocumentException {
        Object object;
        if (this.writer.getDirectContent().size() == 0 && this.writer.getDirectContentUnder().size() == 0 && (this.pageEmpty || this.writer != null && this.writer.isPaused())) {
            return false;
        }
        PdfPageEvent pdfPageEvent = this.writer.getPageEvent();
        if (pdfPageEvent != null) {
            pdfPageEvent.onEndPage(this.writer, this);
        }
        super.newPage();
        this.flushLines();
        PdfResources pdfResources = new PdfResources();
        int n = 1;
        if (this.fontDictionary.containsFont()) {
            pdfResources.add(this.fontDictionary);
            n |= 2;
        }
        if (this.xObjectDictionary.containsXObject()) {
            pdfResources.add(this.xObjectDictionary);
            n |= 8;
        }
        pdfResources.add(new PdfProcSet(n));
        PdfPage pdfPage = new PdfPage(new PdfRectangle(this.thisPageSize), pdfResources);
        if (this.annotations.size() > 0) {
            pdfPage.put(PdfName.ANNOTS, this.annotations);
        }
        if (!this.open || this.close) {
            throw new PdfException("The document isn't open.");
        }
        this.text.endText();
        PdfIndirectReference pdfIndirectReference = this.writer.add(pdfPage, new PdfContents(this.writer.getDirectContentUnder(), this.graphics, this.text, this.writer.getDirectContent()));
        Iterator iterator = ((AbstractList)this.outlines).iterator();
        while (iterator.hasNext()) {
            object = (PdfOutline)iterator.next();
            ((PdfOutline)object).setDestinationPage(pdfIndirectReference);
        }
        object = this.localPageDestinations.keySet().iterator();
        while (object.hasNext()) {
            PdfDestination pdfDestination = (PdfDestination)object.next();
            pdfDestination.addPage(pdfIndirectReference);
        }
        this.localPageDestinations.clear();
        this.initPage();
        return true;
    }

    public void open() {
        if (!this.open) {
            super.open();
            this.writer.open();
            this.outlines = new ArrayList();
            PdfOutline pdfOutline = new PdfOutline();
            this.outlines.add(pdfOutline);
            this.currentOutline = pdfOutline;
        }
        try {
            this.initPage();
        }
        catch (DocumentException documentException) {
            // empty catch block
        }
    }

    public void close() {
        if (this.close) {
            return;
        }
        try {
            this.newPage();
            this.newPage();
        }
        catch (DocumentException documentException) {
            // empty catch block
        }
        PdfPageEvent pdfPageEvent = this.writer.getPageEvent();
        if (pdfPageEvent != null) {
            pdfPageEvent.onCloseDocument(this.writer, this);
        }
        super.close();
        try {
            this.writer.addLocalDestinations(this.localDestinations);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.outlines.size() > 1) {
            Object object;
            int n = this.writer.size();
            int n2 = 0;
            Iterator iterator = ((AbstractList)this.outlines).iterator();
            while (iterator.hasNext()) {
                PdfOutline pdfOutline = (PdfOutline)iterator.next();
                if (pdfOutline.level() > n2) {
                    n2 = pdfOutline.level();
                }
                object = new PdfIndirectReference(6, n);
                pdfOutline.setIndirectReference((PdfIndirectReference)object);
                ++n;
            }
            int n3 = 0;
            while (n3 <= n2) {
                object = null;
                Iterator iterator2 = ((AbstractList)this.outlines).iterator();
                while (iterator2.hasNext()) {
                    PdfOutline pdfOutline = (PdfOutline)iterator2.next();
                    if (pdfOutline.level() == n3) {
                        if (object == null) {
                            object = pdfOutline;
                            continue;
                        }
                        if (pdfOutline.parent().indirectReference().getNumber() == ((PdfOutline)object).parent().indirectReference().getNumber()) {
                            ((PdfDictionary)object).put(PdfName.NEXT, pdfOutline.indirectReference());
                            pdfOutline.put(PdfName.PREV, ((PdfOutline)object).indirectReference());
                        }
                        object = pdfOutline;
                        continue;
                    }
                    if (pdfOutline.level() != n3 + 1) continue;
                    if (pdfOutline.parent().get(PdfName.FIRST) == null) {
                        pdfOutline.parent().put(PdfName.FIRST, pdfOutline.indirectReference());
                    }
                    pdfOutline.parent().put(PdfName.LAST, pdfOutline.indirectReference());
                }
                ++n3;
            }
            try {
                object = ((AbstractList)this.outlines).iterator();
                while (object.hasNext()) {
                    this.writer.add((PdfOutline)object.next());
                }
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
            }
        }
        this.writer.close();
    }

    private void add(PdfFont pdfFont) throws PdfException {
        if (!this.open || this.close) {
            throw new PdfException("The document isn't open.");
        }
        pdfFont.setName(this.writer.add(pdfFont.getFont()));
    }

    public void addFont(PdfName pdfName, PdfIndirectReference pdfIndirectReference) {
        this.fontDictionary.put(pdfName, pdfIndirectReference);
    }

    public boolean add(Element element) throws DocumentException {
        if (this.writer != null && this.writer.isPaused()) {
            return false;
        }
        try {
            switch (element.type()) {
                case 0: {
                    return false;
                }
                case 1: {
                    this.info.addTitle(((Meta)element).content());
                    break;
                }
                case 2: {
                    this.info.addSubject(((Meta)element).content());
                    break;
                }
                case 3: {
                    this.info.addKeywords(((Meta)element).content());
                    break;
                }
                case 4: {
                    this.info.addAuthor(((Meta)element).content());
                    break;
                }
                case 5: {
                    this.info.addProducer();
                    break;
                }
                case 6: {
                    this.info.addCreationDate();
                    break;
                }
                case 10: {
                    PdfChunk pdfChunk;
                    if (this.line == null) {
                        this.carriageReturn();
                    }
                    PdfChunk pdfChunk2 = new PdfChunk((Chunk)element, this.currentAction);
                    while ((pdfChunk = this.line.add(pdfChunk2)) != null) {
                        this.carriageReturn();
                        pdfChunk2 = pdfChunk;
                    }
                    this.pageEmpty = false;
                    break;
                }
                case 17: {
                    Anchor anchor = (Anchor)element;
                    URL uRL = anchor.url();
                    this.leading = anchor.leading();
                    if (uRL != null) {
                        this.currentAction = new PdfAction(uRL);
                    }
                    element.process(this);
                    this.currentAction = null;
                    break;
                }
                case 29: {
                    if (this.line == null) {
                        this.carriageReturn();
                    }
                    Annotation annotation = (Annotation)element;
                    this.annotations.add(new PdfAnnotation(this.indentRight() - this.line.widthLeft(), this.indentTop() - this.currentHeight, this.indentRight() - this.line.widthLeft() + 20.0f, this.indentTop() - this.currentHeight - 20.0f, new PdfString(annotation.title()), new PdfString(annotation.content())));
                    this.pageEmpty = false;
                    break;
                }
                case 11: {
                    this.leading = ((Phrase)element).leading();
                    element.process(this);
                    break;
                }
                case 12: {
                    PdfPageEvent pdfPageEvent;
                    Paragraph paragraph = (Paragraph)element;
                    this.alignment = paragraph.alignment();
                    this.indentLeft += paragraph.indentationLeft();
                    this.indentRight += paragraph.indentationRight();
                    this.leading = paragraph.leading();
                    this.carriageReturn();
                    if (this.currentHeight + this.line.height() + this.leading > this.indentTop() - this.indentBottom()) {
                        this.newPage();
                    }
                    if ((pdfPageEvent = this.writer.getPageEvent()) != null) {
                        pdfPageEvent.onParagraph(this.writer, this, this.indentTop() - this.currentHeight);
                    }
                    element.process(this);
                    this.carriageReturn();
                    this.alignment = 0;
                    this.indentLeft -= paragraph.indentationLeft();
                    this.indentRight -= paragraph.indentationRight();
                    break;
                }
                case 13: 
                case 16: {
                    Section section = (Section)element;
                    PdfDestination pdfDestination = new PdfDestination(2, this.indentTop() - this.currentHeight);
                    while (this.currentOutline.level() >= section.depth()) {
                        this.currentOutline = this.currentOutline.parent();
                    }
                    PdfOutline pdfOutline = new PdfOutline(this.currentOutline, pdfDestination, section.title());
                    this.outlines.add(pdfOutline);
                    this.currentOutline = pdfOutline;
                    this.carriageReturn();
                    this.indentLeft += section.indentationLeft();
                    this.indentRight += section.indentationRight();
                    if (section.title() != null) {
                        this.add(section.title());
                    }
                    this.indentLeft += section.indentation();
                    element.process(this);
                    this.indentLeft -= section.indentationLeft() + section.indentation();
                    this.indentRight -= section.indentationRight();
                    if (section.isChapter()) {
                        this.newPage();
                        break;
                    }
                    this.newLine();
                    break;
                }
                case 14: {
                    List list = (List)element;
                    this.listIndentLeft += list.indentationLeft();
                    this.indentRight += list.indentationRight();
                    element.process(this);
                    this.listIndentLeft -= list.indentationLeft();
                    this.indentRight -= list.indentationRight();
                    break;
                }
                case 15: {
                    ListItem listItem = (ListItem)element;
                    this.alignment = listItem.alignment();
                    this.listIndentLeft += listItem.indentationLeft();
                    this.indentRight += listItem.indentationRight();
                    this.leading = listItem.leading();
                    this.carriageReturn();
                    this.line.setListItem(listItem);
                    element.process(this);
                    this.carriageReturn();
                    this.listIndentLeft -= listItem.indentationLeft();
                    this.indentRight -= listItem.indentationRight();
                    break;
                }
                case 30: {
                    Rectangle rectangle = (Rectangle)element;
                    this.graphics.rectangle(rectangle);
                    this.pageEmpty = false;
                    break;
                }
                case 22: {
                    this.newLine();
                    this.flushLines();
                    boolean bl = false;
                    float f = this.indentTop();
                    float f2 = this.currentHeight;
                    PdfTable pdfTable = new PdfTable((Table)element, this.indentLeft(), this.indentRight(), this.currentHeight > 0.0f ? f - this.currentHeight : f);
                    ArrayList arrayList = pdfTable.getCells();
                    ArrayList arrayList2 = null;
                    while (!arrayList.isEmpty()) {
                        float f3;
                        float f4;
                        float f5;
                        float f6;
                        PdfCell pdfCell;
                        bl = false;
                        if (pdfTable.bottom() < this.indentBottom()) {
                            bl = true;
                        }
                        if (pdfTable.hasHeader()) {
                            this.graphics.rectangle(pdfTable.rectangle(this.top(), this.indentBottom()));
                        } else {
                            this.graphics.rectangle(pdfTable.rectangle(this.indentTop(), this.indentBottom()));
                        }
                        Iterator iterator = ((AbstractList)arrayList).iterator();
                        while (iterator.hasNext()) {
                            pdfCell = (PdfCell)iterator.next();
                            this.lines = pdfCell.getLines(f, this.indentBottom());
                            if (this.lines != null && this.lines.size() > 0) {
                                if (f == this.indentTop()) {
                                    this.graphics.rectangle(pdfCell.rectangle(f - this.leading / 2.0f, this.indentBottom()));
                                } else {
                                    this.graphics.rectangle(pdfCell.rectangle(f, this.indentBottom()));
                                }
                                f6 = pdfCell.top(f - f2);
                                this.text.moveText(0.0f, f6);
                                f5 = this.flushLines() - f6;
                                this.text.moveText(0.0f, f5);
                                if (f2 + f5 > this.currentHeight) {
                                    this.currentHeight = f2 + f5;
                                }
                            }
                            if (!pdfCell.mayBeRemoved()) continue;
                            iterator.remove();
                        }
                        if (!bl || arrayList.isEmpty()) continue;
                        f6 = this.indentBottom() + this.leading;
                        this.pageEmpty = false;
                        this.newPage();
                        this.flushLines();
                        arrayList2 = pdfTable.getHeaderCells();
                        int n = arrayList2.size();
                        if (n > 0) {
                            pdfCell = (PdfCell)arrayList2.get(0);
                            float f7 = pdfCell.top(-pdfTable.cellpadding());
                            int n2 = 0;
                            while (n2 < n) {
                                pdfCell = (PdfCell)arrayList2.get(n2);
                                f4 = this.indentTop() + pdfCell.top(-pdfTable.cellpadding()) - f7;
                                pdfCell.setTop(f4);
                                f3 = this.indentTop() + pdfCell.bottom() - f7;
                                pdfCell.setBottom(f3);
                                f = pdfCell.bottom();
                                this.graphics.rectangle(pdfCell.rectangle(this.indentTop() - this.leading / 2.0f, this.indentBottom()));
                                this.lines = pdfCell.getLines(this.indentTop(), this.indentBottom());
                                float f8 = pdfCell.top(this.indentTop());
                                this.text.moveText(0.0f, f8);
                                f5 = this.flushLines() - f8;
                                this.text.moveText(0.0f, f5);
                                ++n2;
                            }
                            this.currentHeight = this.indentTop() - f - pdfTable.cellpadding();
                            this.text.moveText(0.0f, f - this.indentTop() + pdfTable.cellpadding() - this.currentHeight);
                        }
                        f2 = this.currentHeight;
                        pdfTable.setTop(this.indentTop());
                        pdfTable.setBottom(f - f6 + pdfTable.bottom(pdfTable.cellpadding()));
                        n = arrayList.size();
                        int n3 = 0;
                        while (n3 < n) {
                            pdfCell = (PdfCell)arrayList.get(n3);
                            f4 = f - f6 + pdfCell.top(-pdfTable.cellpadding());
                            f3 = f - f6 + pdfCell.bottom();
                            pdfCell.setTop(f4);
                            pdfCell.setBottom(f3);
                            ++n3;
                        }
                    }
                    this.text.moveText(0.0f, f2 - this.currentHeight);
                    this.lines.add(this.line);
                    this.currentHeight += this.line.height() - f + this.indentTop();
                    this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
                    this.pageEmpty = false;
                    break;
                }
                case 31: 
                case 32: 
                case 33: 
                case 34: {
                    this.carriageReturn();
                    this.add((Image)element);
                    this.pageEmpty = false;
                    break;
                }
                case 39: {
                    this.graphics.add((Graphic)element);
                    this.pageEmpty = false;
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        catch (Exception exception) {
            throw new DocumentException(exception.getMessage());
        }
    }

    PdfName addDirectImage(Image image) throws PdfException, DocumentException {
        PdfName pdfName = this.addDirectImageSimple(image);
        this.xObjectDictionary.put(pdfName, this.writer.getImageReference(pdfName));
        return pdfName;
    }

    PdfName addDirectImageSimple(Image image) throws PdfException, DocumentException {
        PdfName pdfName;
        if (this.images.containsKey(image)) {
            pdfName = (PdfName)this.images.get(image);
        } else {
            PdfImage pdfImage = new PdfImage(image, "img" + this.images.size());
            this.writer.add(pdfImage);
            pdfName = pdfImage.name();
            this.images.put(image, pdfName);
        }
        return pdfName;
    }

    private void add(Image image) throws PdfException, DocumentException {
        this.pageEmpty = false;
        if (this.images.containsKey(image)) {
            PdfName pdfName = (PdfName)this.images.get(image);
        } else {
            PdfImage pdfImage = new PdfImage(image, "img" + this.images.size());
            this.writer.add(pdfImage);
            PdfName pdfName = pdfImage.name();
            this.images.put(image, pdfName);
        }
        if (image.hasAbsolutePosition()) {
            this.graphics.addImage(image);
            return;
        }
        if (this.currentHeight != 0.0f && this.indentTop() - this.currentHeight - image.scaledHeight() < this.indentBottom()) {
            if (this.imageWait == null) {
                this.imageWait = image;
                return;
            }
            this.newPage();
            if (this.currentHeight != 0.0f && this.indentTop() - this.currentHeight - image.scaledHeight() < this.indentBottom()) {
                this.imageWait = image;
                return;
            }
        }
        boolean bl = (image.alignment() & 4) == 4 && (image.alignment() & 3) != 3;
        boolean bl2 = (image.alignment() & 8) == 8;
        float f = this.leading / 2.0f;
        if (bl) {
            f += this.leading;
        }
        float f2 = this.indentTop() - this.currentHeight - image.scaledHeight() - f;
        float[] fArray = image.matrix();
        switch (image.alignment() & 3) {
            case 1: {
                this.graphics.addImage(image, fArray[0], fArray[1], fArray[2], fArray[3], this.indentRight() - image.scaledWidth() - fArray[4], f2 - fArray[5]);
                break;
            }
            case 3: {
                float f3 = this.indentRight() - this.indentLeft() - image.scaledWidth();
                this.graphics.addImage(image, fArray[0], fArray[1], fArray[2], fArray[3], this.indentLeft() + f3 / 2.0f - fArray[4], f2 - fArray[5]);
                break;
            }
            default: {
                this.graphics.addImage(image, fArray[0], fArray[1], fArray[2], fArray[3], this.indentLeft() - fArray[4], f2 - fArray[5]);
            }
        }
        if (bl) {
            if (this.imageEnd < 0.0f || this.imageEnd < this.currentHeight + image.scaledHeight() + f) {
                this.imageEnd = this.currentHeight + image.scaledHeight() + f;
            }
            if ((image.alignment() & 1) == 1) {
                this.imageIndentRight += image.scaledWidth();
            } else {
                this.imageIndentLeft += image.scaledWidth();
            }
        }
        if (!bl && !bl2) {
            this.currentHeight += image.scaledHeight() + f;
            this.flushLines();
            this.text.moveText(0.0f, -(image.scaledHeight() + f));
            this.newLine();
        }
    }

    private void initPage() throws DocumentException {
        Object object;
        this.annotations = new PdfArray();
        this.fontDictionary = new PdfFontDictionary();
        this.xObjectDictionary = new PdfXObjectDictionary();
        this.writer.resetContent();
        ++this.pageN;
        float f = this.leading;
        int n = this.alignment;
        this.imageEnd = -1.0f;
        this.imageIndentRight = 0.0f;
        this.imageIndentLeft = 0.0f;
        this.graphics = new PdfContentByte(this.writer);
        this.text = new PdfContentByte(this.writer);
        this.text.beginText();
        this.leading = 16.0f;
        this.indentBottom = 0.0f;
        this.indentTop = 0.0f;
        this.currentHeight = 0.0f;
        this.thisPageSize = this.pageSize;
        if (this.pageSize.backgroundColor() != null || this.pageSize.hasBorders() || this.pageSize.borderColor() != null || this.pageSize.grayFill() > 0.0f) {
            this.add(this.pageSize);
        }
        if (this.watermark != null) {
            Object object2;
            if (this.images.containsKey(this.watermark)) {
                object = (PdfName)this.images.get(this.watermark);
            } else {
                object2 = new PdfImage(this.watermark, "img" + this.images.size());
                this.writer.add((PdfImage)object2);
                object = ((PdfImage)object2).name();
                this.images.put(this.watermark, object);
            }
            object2 = this.watermark.matrix();
            this.graphics.addImage(this.watermark, object2[0], object2[1], (float)object2[2], (float)object2[3], this.watermark.offsetX() - object2[4], this.watermark.offsetY() - object2[5]);
        }
        if (this.footer != null) {
            this.footer.setPageNumber(this.pageN);
            this.leading = this.footer.paragraph().leading();
            this.add(this.footer.paragraph());
            this.indentBottom = this.currentHeight;
            this.text.moveText(this.left(), this.indentBottom());
            this.flushLines();
            this.text.moveText(-this.left(), -this.bottom());
            this.footer.setTop(this.bottom(this.currentHeight));
            this.footer.setBottom(this.bottom() - 0.75f * this.leading);
            this.footer.setLeft(this.left());
            this.footer.setRight(this.right());
            this.graphics.rectangle(this.footer);
            this.indentBottom = this.currentHeight + this.leading * 3.0f / 2.0f;
            this.currentHeight = 0.0f;
        }
        this.text.moveText(this.left(), this.top());
        if (this.header != null) {
            this.header.setPageNumber(this.pageN);
            this.leading = this.header.paragraph().leading();
            this.text.moveText(0.0f, this.leading);
            this.add(this.header.paragraph());
            this.newLine();
            this.indentTop = this.currentHeight - this.leading;
            this.header.setTop(this.top() + this.leading);
            this.header.setBottom(this.indentTop() + this.leading * 2.0f / 3.0f);
            this.header.setLeft(this.left());
            this.header.setRight(this.right());
            this.graphics.rectangle(this.header);
            this.flushLines();
            this.currentHeight = 0.0f;
        }
        this.pageEmpty = true;
        try {
            if (this.imageWait != null) {
                this.add(this.imageWait);
                this.imageWait = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.leading = f;
        this.alignment = n;
        this.carriageReturn();
        object = this.writer.getPageEvent();
        if (object != null) {
            if (this.firstPageEvent) {
                object.onOpenDocument(this.writer, this);
            }
            object.onStartPage(this.writer, this);
        }
        this.firstPageEvent = false;
    }

    private void carriageReturn() throws DocumentException {
        if (this.lines == null) {
            this.lines = new ArrayList();
        }
        if (this.line != null) {
            if (this.currentHeight + this.line.height() < this.indentTop() - this.indentBottom()) {
                if (this.line.size() > 0) {
                    this.currentHeight += this.line.height();
                    this.lines.add(this.line);
                }
            } else {
                this.newPage();
            }
        }
        if (this.imageEnd > -1.0f && this.currentHeight > this.imageEnd) {
            this.imageEnd = -1.0f;
            this.imageIndentRight = 0.0f;
            this.imageIndentLeft = 0.0f;
        }
        this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
    }

    private void newLine() throws DocumentException {
        this.carriageReturn();
        if (this.lines != null && this.lines.size() > 0) {
            this.lines.add(this.line);
            this.currentHeight += this.line.height();
        }
        this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
    }

    private float flushLines() throws DocumentException {
        if (this.lines == null) {
            return 0.0f;
        }
        if (this.line != null && this.line.size() > 0) {
            this.lines.add(this.line);
            this.line = new PdfLine(this.indentLeft(), this.indentRight(), this.alignment, this.leading);
        }
        if (this.lines.size() == 0) {
            return 0.0f;
        }
        Object[] objectArray = new Object[2];
        PdfFont pdfFont = null;
        boolean bl = false;
        float f = 0.0f;
        Float f2 = new Float(0.0f);
        objectArray[1] = f2;
        Iterator iterator = ((AbstractList)this.lines).iterator();
        while (iterator.hasNext()) {
            PdfLine pdfLine = (PdfLine)iterator.next();
            this.text.moveText(pdfLine.indentLeft() - this.indentLeft() + this.listIndentLeft, -pdfLine.height());
            if (pdfLine.listSymbol() != null) {
                PdfChunk pdfChunk = pdfLine.listSymbol();
                this.text.moveText(-pdfLine.listIndent(), 0.0f);
                if (pdfChunk.font().compareTo(pdfFont) != 0) {
                    pdfFont = pdfChunk.font();
                    this.text.setFontAndSize(pdfFont.getFont(), pdfFont.size());
                }
                if (pdfChunk.color() != null) {
                    Color color = pdfChunk.color();
                    this.text.setRGBColorFill(color.getRed(), color.getGreen(), color.getBlue());
                    this.text.showText(pdfChunk);
                    this.text.resetRGBColorFill();
                } else {
                    this.text.showText(pdfChunk);
                }
                this.text.moveText(pdfLine.listIndent(), 0.0f);
            }
            objectArray[0] = pdfFont;
            this.writeLineToContent(pdfLine, this.text, this.graphics, objectArray);
            pdfFont = (PdfFont)objectArray[0];
            f += pdfLine.height();
            if (this.indentLeft() - this.listIndentLeft == pdfLine.indentLeft()) continue;
            this.text.moveText(this.indentLeft() - pdfLine.indentLeft() - this.listIndentLeft, 0.0f);
        }
        this.lines = new ArrayList();
        return f;
    }

    PdfInfo getInfo() {
        return this.info;
    }

    PdfCatalog getCatalog(PdfIndirectReference pdfIndirectReference) {
        PdfCatalog pdfCatalog;
        if (this.outlines.size() > 1) {
            PdfOutline pdfOutline = (PdfOutline)this.outlines.get(0);
            pdfCatalog = new PdfCatalog(pdfIndirectReference, pdfOutline.indirectReference());
        } else {
            pdfCatalog = new PdfCatalog(pdfIndirectReference);
        }
        pdfCatalog.addNames(this.localDestinations);
        return pdfCatalog;
    }

    float bottom(Table table) {
        PdfTable pdfTable = new PdfTable(table, this.indentLeft(), this.indentRight(), this.currentHeight > 0.0f ? this.indentTop() - this.currentHeight : this.indentTop());
        return pdfTable.bottom();
    }

    private float indentLeft() {
        return this.left(this.indentLeft + this.listIndentLeft + this.imageIndentLeft);
    }

    private float indentRight() {
        return this.right(this.indentRight + this.imageIndentRight);
    }

    private float indentTop() {
        return this.top(this.indentTop);
    }

    float indentBottom() {
        return this.bottom(this.indentBottom);
    }

    void addOutline(PdfOutline pdfOutline) {
        this.outlines.add(pdfOutline);
    }

    void addOutline(PdfOutline pdfOutline, String string) {
        this.outlines.add(pdfOutline);
        this.localDestination(string, pdfOutline.getPdfDestination());
    }

    public PdfOutline getRootOutline() {
        return (PdfOutline)this.outlines.get(0);
    }

    PdfName addTemplateToPage(PdfTemplate pdfTemplate) {
        PdfName pdfName = this.writer.addDirectTemplateSimple(pdfTemplate);
        this.xObjectDictionary.put(pdfName, pdfTemplate.getIndirectReference());
        return pdfName;
    }

    void writeLineToContent(PdfLine pdfLine, PdfContentByte pdfContentByte, PdfContentByte pdfContentByte2, Object[] objectArray) throws DocumentException {
        float f;
        float f2;
        boolean bl;
        PdfFont pdfFont = (PdfFont)objectArray[0];
        float f3 = ((Float)objectArray[1]).floatValue();
        float f4 = 0.0f;
        int n = pdfLine.numberOfSpaces();
        int n2 = pdfLine.toString().length();
        boolean bl2 = bl = pdfLine.hasToBeJustified() && (n != 0 || n2 > 1);
        if (bl) {
            if (pdfLine.isNewlineSplit() && pdfLine.widthLeft() >= f3 * (2.5f * (float)n + (float)n2 - 1.0f)) {
                pdfContentByte.setWordSpacing(2.5f * f3);
                pdfContentByte.setCharacterSpacing(f3);
            } else {
                char c;
                String string;
                float f5 = pdfLine.widthLeft();
                PdfChunk pdfChunk = pdfLine.getChunk(pdfLine.size() - 1);
                if (pdfChunk != null && (string = pdfChunk.toString()).length() > 0 && hangingPunctuation.indexOf(c = string.charAt(string.length() - 1)) >= 0) {
                    f2 = f5;
                    f4 = (f5 += pdfChunk.font().width(c) * 0.4f) - f2;
                }
                f = f5 / (2.5f * (float)n + (float)n2 - 1.0f);
                pdfContentByte.setWordSpacing(2.5f * f);
                pdfContentByte.setCharacterSpacing(f);
                f3 = f;
            }
        }
        int n3 = pdfLine.getLastStrokeChunk();
        int n4 = 0;
        float f6 = f = pdfContentByte.getXTLM();
        f2 = pdfContentByte.getYTLM();
        boolean bl3 = false;
        Iterator iterator = pdfLine.iterator();
        while (iterator.hasNext()) {
            PdfObject pdfObject;
            float f7;
            PdfChunk pdfChunk = (PdfChunk)iterator.next();
            if (pdfChunk.font().compareTo(pdfFont) != 0) {
                pdfFont = pdfChunk.font();
                pdfContentByte.setFontAndSize(pdfFont.getFont(), pdfFont.size());
            }
            Color color = pdfChunk.color();
            float f8 = 0.0f;
            Float f9 = (Float)pdfChunk.getAttribute("SUBSUPSCRIPT");
            if (f9 != null) {
                f8 = f9.floatValue();
            }
            if (color != null) {
                pdfContentByte.setRGBColorFill(color.getRed(), color.getGreen(), color.getBlue());
            }
            if (f8 != 0.0f) {
                pdfContentByte.setTextRise(f8);
            }
            if (pdfChunk.isImage()) {
                bl3 = true;
            } else if (bl && n > 0 && pdfChunk.isCJKEncoding()) {
                String string = pdfChunk.toString();
                int n5 = string.indexOf(32);
                if (n5 < 0) {
                    pdfContentByte.showText(pdfChunk);
                } else {
                    f7 = -2.5f * f3 * 1000.0f / pdfChunk.font.size();
                    pdfObject = new PdfTextArray(new PdfString(string.substring(0, n5), pdfChunk.getEncoding()));
                    int n6 = n5;
                    while ((n5 = string.indexOf(32, n6 + 1)) >= 0) {
                        ((PdfTextArray)pdfObject).add(new PdfNumber(f7));
                        ((PdfTextArray)pdfObject).add(new PdfString(string.substring(n6, n5), pdfChunk.getEncoding()));
                        n6 = n5;
                    }
                    ((PdfTextArray)pdfObject).add(new PdfNumber(f7));
                    ((PdfTextArray)pdfObject).add(new PdfString(string.substring(n6), pdfChunk.getEncoding()));
                    pdfContentByte.showText((PdfTextArray)pdfObject);
                }
            } else {
                pdfContentByte.showText(pdfChunk);
            }
            if (f8 != 0.0f) {
                pdfContentByte.setTextRise(0.0f);
            }
            if (color != null) {
                pdfContentByte.resetRGBColorFill();
            }
            if (n4 > n3) continue;
            boolean bl4 = pdfChunk.isAttribute("STRIKETHRU") || pdfChunk.isAttribute("UNDERLINE");
            f7 = 0.0f;
            float f10 = bl ? pdfChunk.getWidthCorrected(f3, 2.5f * f3) : pdfChunk.width();
            if (pdfChunk.isStroked()) {
                Object object;
                Object object2;
                float f11;
                pdfObject = pdfLine.getChunk(n4 + 1);
                if (bl4) {
                    pdfContentByte2.setLineWidth(pdfChunk.font().size() / 15.0f);
                    if (color != null) {
                        pdfContentByte2.setRGBColorStroke(color.getRed(), color.getGreen(), color.getBlue());
                    }
                }
                float f12 = pdfChunk.font().size() / 3.0f;
                if (pdfChunk.isAttribute("STRIKETHRU")) {
                    f11 = f3;
                    if (pdfObject != null && ((PdfChunk)pdfObject).isAttribute("STRIKETHRU")) {
                        f11 = 0.0f;
                    }
                    if (pdfObject == null) {
                        f11 += f4;
                    }
                    pdfContentByte2.moveTo(f, f2 + f12);
                    pdfContentByte2.lineTo(f + f10 - f11, f2 + f12);
                    pdfContentByte2.stroke();
                }
                if (pdfChunk.isAttribute("UNDERLINE")) {
                    f11 = f3;
                    if (pdfObject != null && ((PdfChunk)pdfObject).isAttribute("UNDERLINE")) {
                        f11 = 0.0f;
                    }
                    if (pdfObject == null) {
                        f11 += f4;
                    }
                    pdfContentByte2.moveTo(f, f2 - f12);
                    pdfContentByte2.lineTo(f + f10 - f11, f2 - f12);
                    pdfContentByte2.stroke();
                }
                if (pdfChunk.isAttribute("LINK")) {
                    f11 = f3;
                    if (pdfObject != null && ((PdfChunk)pdfObject).isAttribute("LINK")) {
                        f11 = 0.0f;
                    }
                    if (pdfObject == null) {
                        f11 += f4;
                    }
                    this.annotations.add(new PdfAnnotation(f, f2, f + f10 - f11, f2 + pdfChunk.font().size(), (PdfAction)pdfChunk.getAttribute("LINK")));
                }
                if (pdfChunk.isAttribute("REMOTEGOTO")) {
                    f11 = f3;
                    if (pdfObject != null && ((PdfChunk)pdfObject).isAttribute("REMOTEGOTO")) {
                        f11 = 0.0f;
                    }
                    if (pdfObject == null) {
                        f11 += f4;
                    }
                    object2 = (Object[])pdfChunk.getAttribute("REMOTEGOTO");
                    object = (String)object2[0];
                    if (object2[1] instanceof String) {
                        this.remoteGoto((String)object, (String)object2[1], f, f2, f + f10 - f11, f2 + pdfChunk.font().size());
                    } else {
                        this.remoteGoto((String)object, (Integer)object2[1], f, f2, f + f10 - f11, f2 + pdfChunk.font().size());
                    }
                }
                if (pdfChunk.isAttribute("LOCALGOTO")) {
                    f11 = f3;
                    if (pdfObject != null && ((PdfChunk)pdfObject).isAttribute("LOCALGOTO")) {
                        f11 = 0.0f;
                    }
                    if (pdfObject == null) {
                        f11 += f4;
                    }
                    this.localGoto((String)pdfChunk.getAttribute("LOCALGOTO"), f, f2, f + f10 - f11, f2 + pdfChunk.font().size());
                }
                if (pdfChunk.isAttribute("LOCALDESTINATION")) {
                    f11 = f3;
                    if (pdfObject != null && ((PdfChunk)pdfObject).isAttribute("LOCALDESTINATION")) {
                        f11 = 0.0f;
                    }
                    if (pdfObject == null) {
                        f11 += f4;
                    }
                    this.localDestination((String)pdfChunk.getAttribute("LOCALDESTINATION"), new PdfDestination(0, f, f2 + pdfChunk.font().size(), 0.0f));
                }
                if (pdfChunk.isAttribute("GENERICTAG")) {
                    f11 = f3;
                    if (pdfObject != null && ((PdfChunk)pdfObject).isAttribute("GENERICTAG")) {
                        f11 = 0.0f;
                    }
                    if (pdfObject == null) {
                        f11 += f4;
                    }
                    object2 = new Rectangle(f, f2, f + f10 - f11, f2 + pdfChunk.font().size());
                    object = this.writer.getPageEvent();
                    if (object != null) {
                        object.onGenericTag(this.writer, this, (Rectangle)object2, (String)pdfChunk.getAttribute("GENERICTAG"));
                    }
                }
                if (pdfChunk.isImage()) {
                    Image image = pdfChunk.getImage();
                    object2 = image.matrix();
                    object2[4] = f + pdfChunk.getImageOffsetX() - object2[4];
                    object2[5] = f2 + pdfChunk.getImageOffsetY() - object2[5];
                    pdfContentByte2.addImage(image, (float)object2[0], (float)object2[1], (float)object2[2], (float)object2[3], (float)object2[4], (float)object2[5]);
                    pdfContentByte.setTextMatrix(f + f3 + image.scaledWidth(), f2);
                }
                if (bl4) {
                    pdfContentByte2.setLineWidth(pdfChunk.font().size() / 15.0f);
                    if (color != null) {
                        pdfContentByte2.resetRGBColorStroke();
                    }
                }
            }
            f += f10;
            ++n4;
        }
        if (bl) {
            pdfContentByte.setWordSpacing(0.0f);
            pdfContentByte.setCharacterSpacing(0.0f);
        }
        if (bl3) {
            pdfContentByte.setTextMatrix(f6, f2);
        }
        objectArray[0] = pdfFont;
        objectArray[1] = new Float(f3);
    }

    void localGoto(String string, float f, float f2, float f3, float f4) {
        PdfAction pdfAction;
        Object[] objectArray = (Object[])this.localDestinations.get(string);
        if (objectArray == null) {
            objectArray = new Object[3];
        }
        if (objectArray[0] == null) {
            if (objectArray[1] == null) {
                objectArray[1] = this.writer.getPdfIndirectReference();
            }
            pdfAction = new PdfAction((PdfIndirectReference)objectArray[1]);
            objectArray[0] = pdfAction;
            this.localDestinations.put(string, objectArray);
        } else {
            pdfAction = (PdfAction)objectArray[0];
        }
        this.annotations.add(new PdfAnnotation(f, f2, f3, f4, pdfAction));
    }

    boolean localDestination(String string, PdfDestination pdfDestination) {
        Object[] objectArray = (Object[])this.localDestinations.get(string);
        if (objectArray == null) {
            objectArray = new Object[3];
        }
        if (objectArray[2] != null) {
            return false;
        }
        objectArray[2] = pdfDestination;
        this.localDestinations.put(string, objectArray);
        this.localPageDestinations.put(pdfDestination, null);
        return true;
    }

    void remoteGoto(String string, String string2, float f, float f2, float f3, float f4) {
        this.annotations.add(new PdfAnnotation(f, f2, f3, f4, new PdfAction(string, string2)));
    }

    void remoteGoto(String string, int n, float f, float f2, float f3, float f4) {
        this.annotations.add(new PdfAnnotation(f, f2, f3, f4, new PdfAction(string, n)));
    }

    class PdfCatalog
    extends PdfDictionary {
        PdfCatalog(PdfIndirectReference pdfIndirectReference) {
            super(PdfDictionary.CATALOG);
            this.put(PdfName.PAGES, pdfIndirectReference);
        }

        PdfCatalog(PdfIndirectReference pdfIndirectReference, PdfIndirectReference pdfIndirectReference2) {
            super(PdfDictionary.CATALOG);
            this.put(PdfName.PAGES, pdfIndirectReference);
            this.put(PdfName.PAGEMODE, PdfName.USEOUTLINES);
            this.put(PdfName.OUTLINES, pdfIndirectReference2);
        }

        void addNames(TreeMap treeMap) {
            PdfObject pdfObject;
            Object object;
            Object object2;
            if (treeMap.size() == 0) {
                return;
            }
            PdfArray pdfArray = new PdfArray();
            Iterator iterator = treeMap.keySet().iterator();
            while (iterator.hasNext()) {
                object2 = (String)iterator.next();
                object = (Object[])treeMap.get(object2);
                pdfObject = (PdfIndirectReference)object[1];
                pdfArray.add(new PdfString((String)object2));
                pdfArray.add(pdfObject);
            }
            object2 = new PdfArray();
            ((PdfArray)object2).add((PdfString)pdfArray.getArrayList().get(0));
            ((PdfArray)object2).add((PdfString)pdfArray.getArrayList().get(pdfArray.size() - 2));
            object = new PdfDictionary();
            pdfObject = new PdfDictionary();
            ((PdfDictionary)object).put(PdfName.LIMITS, (PdfObject)object2);
            ((PdfDictionary)object).put(PdfName.NAMES, pdfArray);
            ((PdfDictionary)pdfObject).put(PdfName.DESTS, (PdfObject)object);
            this.put(PdfName.NAMES, pdfObject);
        }
    }

    public class PdfInfo
    extends PdfDictionary {
        PdfInfo() {
            this.addProducer();
            this.addCreationDate();
        }

        PdfInfo(String string, String string2, String string3) {
            this();
            this.addTitle(string2);
            this.addSubject(string3);
            this.addAuthor(string);
        }

        void addTitle(String string) {
            this.put(PdfName.TITLE, new PdfString(string));
        }

        void addSubject(String string) {
            this.put(PdfName.SUBJECT, new PdfString(string));
        }

        void addKeywords(String string) {
            this.put(PdfName.KEYWORDS, new PdfString(string));
        }

        void addAuthor(String string) {
            this.put(PdfName.AUTHOR, new PdfString(string));
        }

        void addProducer() {
            this.put(PdfName.PRODUCER, new PdfString("iText by lowagie.com - build 78"));
        }

        void addCreationDate() {
            this.put(PdfName.CREATIONDATE, new PdfDate());
        }
    }
}

