/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocWriter;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

class PdfIndirectObject {
    protected int number;
    protected int generation = 0;
    protected int type;
    ByteArrayOutputStream bytes;

    PdfIndirectObject(int n, PdfObject pdfObject) {
        this(n, 0, pdfObject);
    }

    PdfIndirectObject(int n, int n2, PdfObject pdfObject) {
        this.number = n;
        this.generation = n2;
        this.type = pdfObject.type();
        try {
            this.bytes = new ByteArrayOutputStream();
            this.bytes.write(DocWriter.getISOBytes(String.valueOf(n)));
            this.bytes.write(DocWriter.getISOBytes(" "));
            this.bytes.write(DocWriter.getISOBytes(String.valueOf(n2)));
            this.bytes.write(DocWriter.getISOBytes(" obj\n"));
            this.bytes.write(pdfObject.toPdf());
            this.bytes.write(DocWriter.getISOBytes("\nendobj\n"));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    public final int length() {
        return this.bytes.size();
    }

    final PdfIndirectReference getIndirectReference() {
        return new PdfIndirectReference(this.type, this.number, this.generation);
    }

    final void writeTo(OutputStream outputStream) throws IOException {
        this.bytes.writeTo(outputStream);
    }
}

