/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfFontDictionary;
import com.lowagie.text.pdf.PdfFormXObject;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfProcSet;
import com.lowagie.text.pdf.PdfResources;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.PdfXObjectDictionary;

public class PdfTemplate
extends PdfContentByte {
    protected PdfIndirectReference thisReference;
    protected PdfFontDictionary fontDictionary;
    protected PdfXObjectDictionary xObjectDictionary;
    protected float width;
    protected float height;

    private PdfTemplate() {
        super(null);
    }

    public PdfTemplate(PdfWriter pdfWriter) {
        super(pdfWriter);
        this.fontDictionary = new PdfFontDictionary();
        this.xObjectDictionary = new PdfXObjectDictionary();
        this.thisReference = this.writer.getPdfIndirectReference();
    }

    public void setWidth(float f) {
        this.width = f;
    }

    public void setHeight(float f) {
        this.height = f;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    PdfIndirectReference getIndirectReference() {
        return this.thisReference;
    }

    public void addTemplate(PdfTemplate pdfTemplate, float f, float f2, float f3, float f4, float f5, float f6) {
        PdfName pdfName = this.writer.addDirectTemplateSimple(pdfTemplate);
        this.content.append("q ");
        this.content.append(f).append(' ');
        this.content.append(f2).append(' ');
        this.content.append(f3).append(' ');
        this.content.append(f4).append(' ');
        this.content.append(f5).append(' ');
        this.content.append(f6).append(" cm ");
        this.content.append(pdfName.toString()).append(" Do Q\n");
        this.xObjectDictionary.put(pdfName, pdfTemplate.getIndirectReference());
    }

    public void addImage(Image image, float f, float f2, float f3, float f4, float f5, float f6) throws DocumentException {
        try {
            PdfName pdfName = this.pdf.addDirectImageSimple(image);
            this.content.append("q ");
            this.content.append(f).append(' ');
            this.content.append(f2).append(' ');
            this.content.append(f3).append(' ');
            this.content.append(f4).append(' ');
            this.content.append(f5).append(' ');
            this.content.append(f6).append(" cm ");
            this.content.append(pdfName.toString()).append(" Do Q\n");
            this.xObjectDictionary.put(pdfName, this.writer.getImageReference(pdfName));
        }
        catch (Exception exception) {
            throw new DocumentException(exception.getMessage());
        }
    }

    PdfResources getResources() {
        PdfResources pdfResources = new PdfResources();
        int n = 1;
        if (this.fontDictionary.containsFont()) {
            pdfResources.add(this.fontDictionary);
            n |= 2;
        }
        if (this.xObjectDictionary.containsXObject()) {
            pdfResources.add(this.xObjectDictionary);
            n |= 8;
        }
        pdfResources.add(new PdfProcSet(n));
        return pdfResources;
    }

    PdfFormXObject getFormXObject() {
        return new PdfFormXObject(this);
    }

    public void setFontAndSize(BaseFont baseFont, float f) {
        this.state.font = baseFont;
        this.state.size = f;
        Object[] objectArray = this.writer.addSimple(baseFont);
        PdfName pdfName = (PdfName)objectArray[0];
        this.content.append(pdfName.toPdf()).append(' ').append(f).append(" Tf\n");
        this.fontDictionary.put(pdfName, (PdfIndirectReference)objectArray[1]);
    }

    public PdfContentByte getDuplicate() {
        PdfTemplate pdfTemplate = new PdfTemplate();
        pdfTemplate.writer = this.writer;
        pdfTemplate.pdf = this.pdf;
        pdfTemplate.thisReference = this.thisReference;
        pdfTemplate.fontDictionary = this.fontDictionary;
        pdfTemplate.xObjectDictionary = this.xObjectDictionary;
        pdfTemplate.width = this.width;
        pdfTemplate.height = this.height;
        return pdfTemplate;
    }
}

