/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JSpinField
extends JPanel
implements ChangeListener,
CaretListener,
ActionListener {
    protected JSpinner spinner;
    protected JTextField textField;
    protected int min;
    protected int max;
    protected int value;
    protected Color darkGreen;

    public JSpinField() {
        this(0, Integer.MAX_VALUE);
    }

    public JSpinField(int n, int n2) {
        this.min = n;
        if (n2 < n) {
            n2 = n;
        }
        this.max = n2;
        this.value = 0;
        if (this.value < n) {
            this.value = n;
        }
        if (this.value > n2) {
            this.value = n2;
        }
        this.darkGreen = new Color(0, 150, 0);
        this.setLayout(new BorderLayout());
        this.textField = new JTextField();
        this.textField.addCaretListener(this);
        this.textField.addActionListener(this);
        this.textField.setHorizontalAlignment(4);
        this.textField.setBorder(BorderFactory.createEmptyBorder());
        this.textField.setText(Integer.toString(this.value));
        this.spinner = new JSpinner();
        this.spinner.setEditor(this.textField);
        this.spinner.addChangeListener(this);
        this.add((Component)this.spinner, "Center");
    }

    public void adjustWidthToMaximumValue() {
        JTextField jTextField = new JTextField(Integer.toString(this.max));
        int n = jTextField.getPreferredSize().width;
        int n2 = jTextField.getPreferredSize().height;
        this.textField.setPreferredSize(new Dimension(n, n2));
        this.textField.revalidate();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        SpinnerNumberModel spinnerNumberModel = (SpinnerNumberModel)this.spinner.getModel();
        int n = spinnerNumberModel.getNumber().intValue();
        this.setValue(n);
    }

    protected void setValue(int n, boolean bl, boolean bl2) {
        int n2 = this.value;
        this.value = n < this.min ? this.min : (n > this.max ? this.max : n);
        if (bl) {
            this.textField.setText(Integer.toString(this.value));
            this.textField.setForeground(Color.black);
        }
        if (bl2) {
            this.firePropertyChange("value", n2, this.value);
        }
    }

    public void setValue(int n) {
        this.setValue(n, true, true);
        this.spinner.setValue(new Integer(this.value));
    }

    public int getValue() {
        return this.value;
    }

    public void setMinimum(int n) {
        this.min = n;
    }

    public int getMinimum() {
        return this.min;
    }

    public void setMaximum(int n) {
        this.max = n;
    }

    public void setHorizontalAlignment(int n) {
        this.textField.setHorizontalAlignment(n);
    }

    public int getMaximum() {
        return this.max;
    }

    public void setFont(Font font) {
        if (this.textField != null) {
            this.textField.setFont(font);
        }
    }

    public void setForeground(Color color) {
        if (this.textField != null) {
            this.textField.setForeground(color);
        }
    }

    public void caretUpdate(CaretEvent caretEvent) {
        block4: {
            try {
                int n = Integer.valueOf(this.textField.getText());
                if (n >= this.min && n <= this.max) {
                    this.textField.setForeground(this.darkGreen);
                    this.setValue(n, false, true);
                } else {
                    this.textField.setForeground(Color.red);
                }
            }
            catch (Exception exception) {
                if (!(exception instanceof NumberFormatException)) break block4;
                this.textField.setForeground(Color.red);
            }
        }
        this.textField.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.textField.getForeground().equals(this.darkGreen)) {
            this.setValue(Integer.valueOf(this.textField.getText()));
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.textField.setEnabled(bl);
        this.spinner.setEnabled(bl);
    }

    public Component getSpinner() {
        return this.spinner;
    }

    public String getName() {
        return "JSpinField";
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("JSpinField2");
        jFrame.getContentPane().add(new JSpinField());
        jFrame.pack();
        jFrame.setVisible(true);
    }
}

