/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql;

public class EscapeTokenizer {
    protected char _last_char = '\u0000';
    protected boolean _in_quotes = false;
    protected boolean _in_braces = false;
    protected char _quote_char = '\u0000';
    protected boolean _emitting_escape_code = false;
    protected String _Source = null;
    protected int _pos = 0;

    public EscapeTokenizer(String string) {
        this._Source = string;
        this._pos = 0;
    }

    public synchronized boolean hasMoreTokens() {
        return this._pos < this._Source.length();
    }

    /*
     * Enabled aggressive block sorting
     */
    public synchronized String nextToken() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this._emitting_escape_code) {
            stringBuffer.append("{");
            this._emitting_escape_code = false;
        }
        while (this._pos < this._Source.length()) {
            char c = this._Source.charAt(this._pos);
            if (c == '\'') {
                if (this._last_char != '\\') {
                    if (this._in_quotes) {
                        if (this._quote_char == c) {
                            this._in_quotes = false;
                        }
                    } else {
                        this._in_quotes = true;
                        this._quote_char = c;
                    }
                }
                stringBuffer.append(c);
            } else if (c == '\"') {
                if (this._last_char != '\\' && this._last_char != '\"') {
                    if (this._in_quotes) {
                        if (this._quote_char == c) {
                            this._in_quotes = false;
                        }
                    } else {
                        this._in_quotes = true;
                        this._quote_char = c;
                    }
                }
                stringBuffer.append(c);
            } else if (c == '{') {
                if (!this._in_quotes) {
                    ++this._pos;
                    this._emitting_escape_code = true;
                    return stringBuffer.toString();
                }
                stringBuffer.append(c);
            } else if (c == '}') {
                stringBuffer.append(c);
                if (!this._in_quotes) {
                    this._last_char = c;
                    ++this._pos;
                    return stringBuffer.toString();
                }
            } else {
                stringBuffer.append(c);
            }
            this._last_char = c;
            ++this._pos;
        }
        return stringBuffer.toString();
    }
}

