/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql;

import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Vector;
import org.gjt.mm.mysql.Connection;
import org.gjt.mm.mysql.EscapeProcessor;
import org.gjt.mm.mysql.MysqlIO;
import org.gjt.mm.mysql.ResultSet;

public class Statement {
    protected Connection _Conn = null;
    ResultSet _Results = null;
    ResultSet _NextResults = null;
    SQLWarning _Warnings = null;
    int _timeout = 0;
    boolean _escapeProcessing = true;
    EscapeProcessor _Escaper = null;
    int _max_field_size = MysqlIO.MAXBUF;
    int _max_rows = -1;
    long _update_count = -1L;
    long _last_insert_id = -1L;
    String _Catalog = null;
    protected Vector _Batched = null;

    public Statement(Connection connection, String string) {
        this._Conn = connection;
        this._Escaper = new EscapeProcessor();
        this._Catalog = string;
        if (this._Conn != null) {
            this._max_field_size = this._Conn.getMaxAllowedPacket();
        }
    }

    public java.sql.ResultSet executeQuery(String string) throws SQLException {
        if (this._escapeProcessing) {
            string = this._Escaper.escapeSQL(string);
        }
        if (string.indexOf("||") != -1) {
            string = EscapeProcessor.doConcat(string);
        }
        if (this._Results != null) {
            this._Results.close();
        }
        Object object = this._Conn.getMutex();
        synchronized (object) {
            String string2 = null;
            if (!this._Conn.getCatalog().equals(this._Catalog)) {
                string2 = this._Conn.getCatalog();
                this._Conn.setCatalog(this._Catalog);
            }
            if (this._Conn.useMaxRows()) {
                if (string.toUpperCase().indexOf("LIMIT") != -1) {
                    this._Results = this._Conn.execSQL(string, this._max_rows);
                } else {
                    if (this._max_rows <= 0) {
                        this._Conn.execSQL("SET OPTION SQL_SELECT_LIMIT=50000000", -1);
                    } else {
                        this._Conn.execSQL("SET OPTION SQL_SELECT_LIMIT=" + this._max_rows, -1);
                    }
                    this._Results = this._Conn.execSQL(string, -1);
                    if (string2 != null) {
                        this._Conn.setCatalog(string2);
                    }
                }
            } else {
                this._Results = this._Conn.execSQL(string, -1);
            }
            if (string2 != null) {
                this._Conn.setCatalog(string2);
            }
        }
        this._last_insert_id = this._Results.getUpdateID();
        this._NextResults = this._Results;
        this._Results.setConnection(this._Conn);
        return (java.sql.ResultSet)((Object)this._Results);
    }

    public int executeUpdate(String string) throws SQLException {
        if (this._escapeProcessing) {
            string = this._Escaper.escapeSQL(string);
        }
        if (string.indexOf("||") != -1) {
            string = EscapeProcessor.doConcat(string);
        }
        ResultSet resultSet = null;
        Object object = this._Conn.getMutex();
        synchronized (object) {
            String string2 = null;
            if (!this._Conn.getCatalog().equals(this._Catalog)) {
                string2 = this._Conn.getCatalog();
                this._Conn.setCatalog(this._Catalog);
            }
            resultSet = this._Conn.execSQL(string, -1);
            resultSet.setConnection(this._Conn);
            if (string2 != null) {
                this._Conn.setCatalog(string2);
            }
        }
        if (resultSet.reallyResult()) {
            throw new SQLException("Results returned for UPDATE ONLY.", "01S03");
        }
        this._update_count = resultSet.getUpdateCount();
        int n = 0;
        n = this._update_count > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this._update_count;
        this._last_insert_id = resultSet.getUpdateID();
        return n;
    }

    public void close() throws SQLException {
        this._Results = null;
        this._Conn = null;
        this._Warnings = null;
        this._Escaper = null;
    }

    public int getMaxFieldSize() throws SQLException {
        return this._max_field_size;
    }

    public void setMaxFieldSize(int n) throws SQLException {
        int n2;
        int n3 = n2 = this._Conn != null ? this._Conn.getMaxAllowedPacket() : MysqlIO.MAXBUF;
        if (n > n2) {
            throw new SQLException("Can not set max field size > max allowed packet: " + n2, "S1009");
        }
        this._max_field_size = n;
    }

    public int getMaxRows() throws SQLException {
        if (this._max_rows <= 0) {
            return 0;
        }
        return this._max_rows;
    }

    public void setMaxRows(int n) throws SQLException {
        if (n > 50000000) {
            throw new SQLException("setMaxRows() out of range. " + n + " > " + 50000000 + ".", "S1009");
        }
        if (n == 0) {
            n = -1;
        }
        this._max_rows = n;
        this._Conn.maxRowsChanged();
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this._escapeProcessing = bl;
    }

    public int getQueryTimeout() throws SQLException {
        return this._timeout;
    }

    public void setQueryTimeout(int n) throws SQLException {
        this._timeout = n;
    }

    public void cancel() throws SQLException {
    }

    public SQLWarning getWarnings() throws SQLException {
        return this._Warnings;
    }

    public void clearWarnings() throws SQLException {
        this._Warnings = null;
    }

    public void setCursorName(String string) throws SQLException {
    }

    public boolean execute(String string) throws SQLException {
        if (this._escapeProcessing) {
            string = this._Escaper.escapeSQL(string);
        }
        if (string.indexOf("||") != -1) {
            string = EscapeProcessor.doConcat(string);
        }
        if (this._Results != null) {
            this._Results.close();
        }
        ResultSet resultSet = null;
        Object object = this._Conn.getMutex();
        synchronized (object) {
            String string2 = null;
            if (!this._Conn.getCatalog().equals(this._Catalog)) {
                string2 = this._Conn.getCatalog();
                this._Conn.setCatalog(this._Catalog);
            }
            if (this._Conn.useMaxRows()) {
                if (string.toUpperCase().indexOf("LIMIT") != -1) {
                    resultSet = this._Conn.execSQL(string, this._max_rows);
                } else {
                    if (this._max_rows <= 0) {
                        this._Conn.execSQL("SET OPTION SQL_SELECT_LIMIT=50000000", -1);
                    } else {
                        this._Conn.execSQL("SET OPTION SQL_SELECT_LIMIT=" + this._max_rows, -1);
                    }
                    resultSet = this._Conn.execSQL(string, -1);
                }
            } else {
                resultSet = this._Conn.execSQL(string, -1);
            }
            if (string2 != null) {
                this._Conn.setCatalog(string2);
            }
        }
        this._last_insert_id = resultSet.getUpdateID();
        if (resultSet != null) {
            this._Results = resultSet;
        }
        resultSet.setConnection(this._Conn);
        return resultSet != null && resultSet.reallyResult();
    }

    public java.sql.ResultSet getResultSet() throws SQLException {
        return this._Results != null && this._Results.reallyResult() ? (java.sql.ResultSet)((Object)this._Results) : null;
    }

    public int getUpdateCount() throws SQLException {
        if (this._Results == null) {
            return -1;
        }
        if (this._Results.reallyResult()) {
            return -1;
        }
        int n = 0;
        n = this._Results.getUpdateCount() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this._Results.getUpdateCount();
        return n;
    }

    public long getLongUpdateCount() {
        if (this._Results == null) {
            return -1L;
        }
        if (this._Results.reallyResult()) {
            return -1L;
        }
        return this._update_count;
    }

    public long getLastInsertID() {
        return this._last_insert_id;
    }

    public boolean getMoreResults() throws SQLException {
        if (this._Results != null) {
            this._Results.close();
        }
        this._Results = this._NextResults;
        this._NextResults = null;
        return this._Results != null && this._Results.reallyResult();
    }

    public void setFetchDirection(int n) throws SQLException {
    }

    public int getFetchDirection() throws SQLException {
        return 0;
    }

    public void setFetchSize(int n) throws SQLException {
    }

    public int getFetchSize() throws SQLException {
        return 0;
    }

    public int getResultSetConcurrency() throws SQLException {
        return 0;
    }

    public int getResultSetType() throws SQLException {
        return 0;
    }

    public void addBatch(String string) throws SQLException {
        throw new SQLException("Not implemented");
    }

    public void clearBatch() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public int[] executeBatch() throws SQLException {
        throw new SQLException("Not implemented");
    }

    public java.sql.Connection getConnection() throws SQLException {
        return (java.sql.Connection)((Object)this._Conn);
    }
}

